/*
 * Decompiled with CFR 0.152.
 */
package org.apache.excalibur.instrument.manager.impl;

import java.io.PrintWriter;
import java.util.Arrays;
import java.util.Comparator;
import java.util.HashMap;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.avalon.framework.logger.Logger;
import org.apache.excalibur.instrument.manager.CounterInstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentListener;
import org.apache.excalibur.instrument.manager.InstrumentSampleDescriptor;
import org.apache.excalibur.instrument.manager.InstrumentSampleUtils;
import org.apache.excalibur.instrument.manager.ValueInstrumentListener;
import org.apache.excalibur.instrument.manager.impl.AbstractInstrumentSample;
import org.apache.excalibur.instrument.manager.impl.AbstractValueInstrumentSample;
import org.apache.excalibur.instrument.manager.impl.CounterInstrumentSample;
import org.apache.excalibur.instrument.manager.impl.DefaultInstrumentManagerImpl;
import org.apache.excalibur.instrument.manager.impl.InstrumentDescriptorImpl;
import org.apache.excalibur.instrument.manager.impl.InstrumentSample;
import org.apache.excalibur.instrument.manager.impl.InstrumentSampleFactory;
import org.apache.excalibur.instrument.manager.impl.InstrumentableProxy;
import org.apache.excalibur.instrument.manager.impl.XMLUtil;

public class InstrumentProxy
extends AbstractLogEnabled
implements org.apache.excalibur.instrument.InstrumentProxy,
Configurable {
    private InstrumentableProxy m_instrumentableProxy;
    private boolean m_configured;
    private boolean m_registered;
    private String m_name;
    private String m_description;
    private InstrumentDescriptor m_descriptor;
    private int m_type;
    private InstrumentListener[] m_listeners;
    private HashMap m_samples = new HashMap();
    private InstrumentSample[] m_sampleArray;
    private InstrumentSampleDescriptor[] m_sampleDescriptorArray;
    private Logger m_valueLogger;
    private int m_lastValue;
    private int m_stateVersion;

    InstrumentProxy(InstrumentableProxy instrumentableProxy, String name, String description) {
        this.m_instrumentableProxy = instrumentableProxy;
        this.m_name = name;
        this.m_description = description;
        this.m_descriptor = new InstrumentDescriptorImpl(this);
    }

    public void enableLogging(Logger logger) {
        super.enableLogging(logger);
        this.m_valueLogger = logger.getChildLogger("values");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configure(Configuration configuration) throws ConfigurationException {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            this.m_description = configuration.getAttribute("description", this.m_description);
            if (this.getLogger().isDebugEnabled()) {
                this.getLogger().debug("Configuring Instrument: " + this.m_name + " as \"" + this.m_description + "\"");
            }
            this.m_configured = true;
            Configuration[] sampleConfs = configuration.getChildren("sample");
            for (int i = 0; i < sampleConfs.length; ++i) {
                AbstractInstrumentSample instrumentSample;
                String fullSampleName;
                InstrumentSample sample;
                Configuration sampleConf = sampleConfs[i];
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType((String)sampleConf.getAttribute("type"));
                long sampleInterval = sampleConf.getAttributeAsLong("interval");
                int sampleSize = sampleConf.getAttributeAsInteger("size", 1);
                String sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)sampleInterval, (int)sampleSize);
                String defaultDescription = InstrumentSampleUtils.generateInstrumentSampleName((int)sampleType, (long)sampleInterval, (int)sampleSize);
                String sampleDescription = sampleConf.getAttribute("description", defaultDescription);
                if (this.getLogger().isDebugEnabled()) {
                    this.getLogger().debug("Configuring InstrumentSample: " + sampleName + " as \"" + sampleDescription + "\"");
                }
                if ((sample = this.getInstrumentSample(fullSampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)sampleInterval, (int)sampleSize))) == null) {
                    instrumentSample = (AbstractInstrumentSample)InstrumentSampleFactory.getInstrumentSample(this, sampleType, sampleName, sampleInterval, sampleSize, sampleDescription, 0L);
                    instrumentSample.enableLogging(this.getLogger());
                    instrumentSample.setConfigured();
                    this.addInstrumentSample(instrumentSample);
                    continue;
                }
                if (sample instanceof AbstractInstrumentSample) {
                    instrumentSample = (AbstractInstrumentSample)sample;
                    instrumentSample.setConfigured();
                    instrumentSample.makePermanent();
                    continue;
                }
                this.getLogger().warn("Instrument sample was configured but already existed and could not be cast to an AbstractInstrumentSample.  Name: " + fullSampleName + ", Class: " + sample.getClass().getName());
            }
        }
    }

    public boolean isActive() {
        return this.m_listeners != null;
    }

    public void increment(int count) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        InstrumentListener[] listeners = this.m_listeners;
        if (listeners != null) {
            if (this.m_valueLogger.isDebugEnabled()) {
                this.m_valueLogger.debug("increment() called for Instrument, " + this.m_name);
            }
            long time = System.currentTimeMillis();
            for (int i = 0; i < listeners.length; ++i) {
                CounterInstrumentListener listener = (CounterInstrumentListener)listeners[i];
                listener.increment(this.getName(), count, time);
            }
        }
    }

    public void setValue(int value) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        this.m_lastValue = value;
        InstrumentListener[] listeners = this.m_listeners;
        if (listeners != null) {
            if (this.m_valueLogger.isDebugEnabled()) {
                this.m_valueLogger.debug("setValue( " + value + " ) called for Instrument, " + this.m_name);
            }
            long time = System.currentTimeMillis();
            for (int i = 0; i < listeners.length; ++i) {
                ValueInstrumentListener listener = (ValueInstrumentListener)listeners[i];
                listener.setValue(this.getName(), value, time);
            }
        }
    }

    InstrumentableProxy getInstrumentableProxy() {
        return this.m_instrumentableProxy;
    }

    boolean isConfigured() {
        return this.m_configured;
    }

    boolean isRegistered() {
        return this.m_registered;
    }

    void setRegistered() {
        if (!this.m_registered) {
            this.m_registered = true;
            this.stateChanged();
        }
    }

    String getName() {
        return this.m_name;
    }

    void setDescription(String description) {
        String oldDescription = this.m_description;
        if (!(oldDescription == description || description != null && description.equals(oldDescription))) {
            this.m_description = description;
            this.stateChanged();
        }
    }

    String getDescription() {
        return this.m_description;
    }

    InstrumentDescriptor getDescriptor() {
        return this.m_descriptor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void setType(int type) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            if (this.m_type != 0) {
                throw new IllegalStateException("Type already set.");
            }
            switch (type) {
                case 1: 
                case 2: {
                    this.m_type = type;
                    break;
                }
                default: {
                    throw new IllegalStateException(type + " is not a valid type.");
                }
            }
        }
    }

    int getType() {
        return this.m_type;
    }

    void addCounterInstrumentListener(CounterInstrumentListener listener) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A CounterInstrumentListener was added to Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.addInstrumentListener((InstrumentListener)listener);
    }

    void removeCounterInstrumentListener(CounterInstrumentListener listener) {
        if (this.m_type != 1) {
            throw new IllegalStateException("The proxy is not configured to handle CounterInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A CounterInstrumentListener was removed from Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.removeInstrumentListener((InstrumentListener)listener);
    }

    void addValueInstrumentListener(ValueInstrumentListener listener) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A ValueInstrumentListener was added to Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.addInstrumentListener((InstrumentListener)listener);
        long time = System.currentTimeMillis();
        listener.setValue(this.getName(), this.m_lastValue, time);
    }

    void removeValueInstrumentListener(ValueInstrumentListener listener) {
        if (this.m_type != 2) {
            throw new IllegalStateException("The proxy is not configured to handle ValueInstruments.");
        }
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("A ValueInstrumentListener was removed from Instrument, " + this.m_name + " : " + listener.getClass().getName());
        }
        this.removeInstrumentListener((InstrumentListener)listener);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentSample(InstrumentSample instrumentSample) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            if (this.m_type == 0) {
                this.setType(instrumentSample.getInstrumentType());
            } else if (this.m_type != instrumentSample.getInstrumentType()) {
                throw new IllegalStateException("The sample '" + instrumentSample.getName() + "' had its type set to " + InstrumentProxy.getTypeName(this.m_type) + " by another sample.  This sample has a type of " + InstrumentProxy.getTypeName(instrumentSample.getInstrumentType()) + " and is not compatible.");
            }
            String sampleName = instrumentSample.getName();
            if (this.m_samples.get(sampleName) != null) {
                throw new IllegalStateException("More than one sample with the same name, '" + sampleName + "', can not be configured.");
            }
            this.m_samples.put(sampleName, instrumentSample);
            this.m_sampleArray = null;
            this.m_sampleDescriptorArray = null;
            switch (this.m_type) {
                case 1: {
                    this.addCounterInstrumentListener((CounterInstrumentSample)instrumentSample);
                    break;
                }
                case 2: {
                    this.addValueInstrumentListener((AbstractValueInstrumentSample)instrumentSample);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to deal with the type: " + this.m_type);
                }
            }
        }
        if (instrumentSample.getLeaseExpirationTime() == 0L) {
            this.m_instrumentableProxy.getInstrumentManager().incrementPermanentSampleCount();
        } else {
            this.m_instrumentableProxy.getInstrumentManager().incrementLeasedSampleCount();
        }
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeInstrumentSample(InstrumentSample instrumentSample) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            switch (this.m_type) {
                case 1: {
                    this.removeCounterInstrumentListener((CounterInstrumentSample)instrumentSample);
                    break;
                }
                case 2: {
                    this.removeValueInstrumentListener((AbstractValueInstrumentSample)instrumentSample);
                    break;
                }
                default: {
                    throw new IllegalStateException("Don't know how to deal with the type: " + this.m_type);
                }
            }
            this.m_samples.remove(instrumentSample.getName());
            this.m_sampleArray = null;
            this.m_sampleDescriptorArray = null;
        }
        this.m_instrumentableProxy.getInstrumentManager().decrementLeasedSampleCount();
        this.stateChanged();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentSample getInstrumentSample(String InstrumentSampleName) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            return (InstrumentSample)this.m_samples.get(InstrumentSampleName);
        }
    }

    InstrumentSample[] getInstrumentSamples() {
        InstrumentSample[] samples = this.m_sampleArray;
        if (samples == null) {
            samples = this.updateInstrumentSampleArray();
        }
        return samples;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    InstrumentSample createInstrumentSample(String sampleDescription, long sampleInterval, int sampleSize, long sampleLease, int sampleType) {
        InstrumentSample instrumentSample;
        this.getLogger().debug("Create new sample for " + this.m_name + ": interval=" + sampleInterval + ", size=" + sampleSize + ", lease=" + sampleLease + ", type=" + InstrumentSampleUtils.getInstrumentSampleTypeName((int)sampleType));
        DefaultInstrumentManagerImpl manager = this.m_instrumentableProxy.getInstrumentManager();
        sampleSize = Math.max(1, Math.min(sampleSize, manager.getMaxLeasedSampleSize()));
        String sampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)sampleInterval, (int)sampleSize);
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            instrumentSample = this.getInstrumentSample(sampleName);
            if (instrumentSample != null) {
                instrumentSample.extendLease(sampleLease);
            } else {
                boolean expired = false;
                sampleLease = Math.max(1L, Math.min(sampleLease, manager.getMaxLeasedSampleLease()));
                if (manager.getLeaseSampleCount() >= manager.getMaxLeasedSamples() || sampleLease == 1L) {
                    sampleLease = 1L;
                    expired = true;
                }
                instrumentSample = InstrumentSampleFactory.getInstrumentSample(this, sampleType, sampleName, sampleInterval, sampleSize, sampleDescription, sampleLease);
                instrumentSample.enableLogging(this.getLogger());
                if (!expired) {
                    this.m_instrumentableProxy.getInstrumentManager().incrementLeaseRequests();
                    this.addInstrumentSample(instrumentSample);
                    this.getInstrumentableProxy().getInstrumentManager().registerLeasedInstrumentSample(instrumentSample);
                }
            }
        }
        return instrumentSample;
    }

    InstrumentSampleDescriptor[] getInstrumentSampleDescriptors() {
        InstrumentSampleDescriptor[] descriptors = this.m_sampleDescriptorArray;
        if (descriptors == null) {
            descriptors = this.updateInstrumentSampleDescriptorArray();
        }
        return descriptors;
    }

    int getStateVersion() {
        return this.m_stateVersion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addInstrumentListener(InstrumentListener listener) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            InstrumentListener[] newListeners;
            InstrumentListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = new InstrumentListener[]{listener};
            } else {
                newListeners = new InstrumentListener[oldListeners.length + 1];
                System.arraycopy(oldListeners, 0, newListeners, 0, oldListeners.length);
                newListeners[oldListeners.length] = listener;
            }
            this.m_listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeInstrumentListener(InstrumentListener listener) {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            InstrumentListener[] newListeners;
            InstrumentListener[] oldListeners = this.m_listeners;
            if (oldListeners == null) {
                newListeners = null;
            } else if (oldListeners.length == 1) {
                newListeners = oldListeners[0] == listener ? null : oldListeners;
            } else {
                int pos = -1;
                for (int i = 0; i < oldListeners.length; ++i) {
                    if (oldListeners[i] != listener) continue;
                    pos = i;
                    break;
                }
                if (pos < 0) {
                    newListeners = oldListeners;
                } else {
                    newListeners = new InstrumentListener[oldListeners.length - 1];
                    if (pos > 0) {
                        System.arraycopy(oldListeners, 0, newListeners, 0, pos);
                    }
                    if (pos < oldListeners.length - 1) {
                        System.arraycopy(oldListeners, pos + 1, newListeners, pos, oldListeners.length - 1 - pos);
                    }
                }
            }
            this.m_listeners = newListeners;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentSample[] updateInstrumentSampleArray() {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            this.m_sampleArray = new InstrumentSample[this.m_samples.size()];
            this.m_samples.values().toArray(this.m_sampleArray);
            Arrays.sort(this.m_sampleArray, new Comparator(){

                public int compare(Object o1, Object o2) {
                    return ((InstrumentSample)o1).getDescription().compareTo(((InstrumentSample)o2).getDescription());
                }

                public boolean equals(Object obj) {
                    return false;
                }
            });
            return this.m_sampleArray;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private InstrumentSampleDescriptor[] updateInstrumentSampleDescriptorArray() {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            if (this.m_sampleArray == null) {
                this.updateInstrumentSampleArray();
            }
            this.m_sampleDescriptorArray = new InstrumentSampleDescriptor[this.m_sampleArray.length];
            for (int i = 0; i < this.m_sampleArray.length; ++i) {
                this.m_sampleDescriptorArray[i] = this.m_sampleArray[i].getDescriptor();
            }
            return this.m_sampleDescriptorArray;
        }
    }

    boolean hasState() {
        InstrumentSample[] samples = this.getInstrumentSamples();
        for (int i = 0; i < samples.length; ++i) {
            InstrumentSample sample = samples[i];
            if (!sample.hasState()) continue;
            return true;
        }
        return false;
    }

    void writeState(PrintWriter out) {
        out.print("<instrument name=\"");
        out.print(XMLUtil.getXMLSafeString(this.m_name));
        out.println("\">");
        InstrumentSample[] samples = this.getInstrumentSamples();
        for (int i = 0; i < samples.length; ++i) {
            InstrumentSample sample = samples[i];
            if (!sample.hasState()) continue;
            sample.writeState(out);
        }
        out.println("</instrument>");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void loadState(Configuration state) throws ConfigurationException {
        InstrumentProxy instrumentProxy = this;
        synchronized (instrumentProxy) {
            Configuration[] instrumentSampleConfs = state.getChildren("sample");
            for (int i = 0; i < instrumentSampleConfs.length; ++i) {
                int sampleSize;
                long sampleInterval;
                Configuration instrumentSampleConf = instrumentSampleConfs[i];
                int sampleType = InstrumentSampleUtils.resolveInstrumentSampleType((String)instrumentSampleConf.getAttribute("type"));
                String fullSampleName = InstrumentSampleUtils.generateFullInstrumentSampleName((String)this.m_name, (int)sampleType, (long)(sampleInterval = instrumentSampleConf.getAttributeAsLong("interval")), (int)(sampleSize = instrumentSampleConf.getAttributeAsInteger("size", 1)));
                InstrumentSample sample = this.getInstrumentSample(fullSampleName);
                if (sample == null) {
                    long leaseExpirationTime = instrumentSampleConf.getAttributeAsLong("lease-expiration", 0L);
                    if (leaseExpirationTime > 0L) {
                        String sampleName = InstrumentSampleUtils.generateInstrumentSampleName((int)sampleType, (long)sampleInterval, (int)sampleSize);
                        String sampleDescription = instrumentSampleConf.getAttribute("description", sampleName);
                        AbstractInstrumentSample instrumentSample = (AbstractInstrumentSample)InstrumentSampleFactory.getInstrumentSample(this, sampleType, fullSampleName, sampleInterval, sampleSize, sampleDescription, 1L);
                        instrumentSample.enableLogging(this.getLogger());
                        instrumentSample.loadState(instrumentSampleConf);
                        this.addInstrumentSample(instrumentSample);
                        continue;
                    }
                    this.getLogger().debug("InstrumentSample entry ignored while loading state because the sample does not exist: " + fullSampleName);
                    continue;
                }
                sample.loadState(instrumentSampleConf);
            }
        }
        this.stateChanged();
    }

    protected void stateChanged() {
        ++this.m_stateVersion;
        this.m_instrumentableProxy.stateChanged();
    }

    public static String getTypeName(int type) {
        switch (type) {
            case 0: {
                return "none";
            }
            case 1: {
                return "counter";
            }
            case 2: {
                return "value";
            }
        }
        throw new IllegalArgumentException(type + " is not a known Instrument type.");
    }
}

