/*
 * Decompiled with CFR 0.152.
 */
package ucar.unidata.geoloc;

import ucar.unidata.geoloc.Earth;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;

public class Bearing {
    private static final Earth defaultEarth = new Earth(6378137.0, 0.0, 298.257223563);
    private static double A;
    private static double F;
    private static final double EPS = 5.0E-14;
    private static double R;
    private static final double rad;
    private static final double deg;
    private static int maxLoopCnt;
    private double azimuth;
    private double backazimuth;
    private double distance;

    public static Bearing calculateBearing(Earth e, LatLonPoint pt1, LatLonPoint pt2, Bearing result) {
        return Bearing.calculateBearing(e, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude(), result);
    }

    public static Bearing calculateBearing(LatLonPoint pt1, LatLonPoint pt2, Bearing result) {
        return Bearing.calculateBearing(defaultEarth, pt1.getLatitude(), pt1.getLongitude(), pt2.getLatitude(), pt2.getLongitude(), result);
    }

    public static Bearing calculateBearing(double lat1, double lon1, double lat2, double lon2, Bearing result) {
        return Bearing.calculateBearing(defaultEarth, lat1, lon1, lat2, lon2, result);
    }

    public static Bearing calculateBearing(Earth e, double lat1, double lon1, double lat2, double lon2, Bearing result) {
        double E;
        double CZ;
        double C2A;
        double Y;
        double CY;
        double SY;
        double CX;
        double SX;
        double C;
        double D;
        if (result == null) {
            result = new Bearing();
        }
        if (lat1 == lat2 && lon1 == lon2) {
            result.distance = 0.0;
            result.azimuth = 0.0;
            result.backazimuth = 0.0;
            return result;
        }
        A = e.getMajor();
        F = e.getFlattening();
        R = 1.0 - F;
        double GLAT1 = rad * lat1;
        double GLAT2 = rad * lat2;
        double TU1 = R * Math.sin(GLAT1) / Math.cos(GLAT1);
        double TU2 = R * Math.sin(GLAT2) / Math.cos(GLAT2);
        double CU1 = 1.0 / Math.sqrt(TU1 * TU1 + 1.0);
        double SU1 = CU1 * TU1;
        double CU2 = 1.0 / Math.sqrt(TU2 * TU2 + 1.0);
        double S = CU1 * CU2;
        double BAZ = S * TU2;
        double FAZ = BAZ * TU1;
        double GLON1 = rad * lon1;
        double GLON2 = rad * lon2;
        double X = GLON2 - GLON1;
        int loopCnt = 0;
        do {
            if (++loopCnt > 1000) {
                throw new IllegalArgumentException("Too many iterations calculating bearing:" + lat1 + " " + lon1 + " " + lat2 + " " + lon2);
            }
            SX = Math.sin(X);
            CX = Math.cos(X);
            TU1 = CU2 * SX;
            TU2 = BAZ - SU1 * CU2 * CX;
            SY = Math.sqrt(TU1 * TU1 + TU2 * TU2);
            CY = S * CX + FAZ;
            Y = Math.atan2(SY, CY);
            double SA = S * SX / SY;
            C2A = -SA * SA + 1.0;
            CZ = FAZ + FAZ;
            if (C2A > 0.0) {
                CZ = -CZ / C2A + CY;
            }
            E = CZ * CZ * 2.0 - 1.0;
            C = ((-3.0 * C2A + 4.0) * F + 4.0) * C2A * F / 16.0;
            D = X;
            X = ((E * CY * C + CZ) * SY * C + Y) * SA;
        } while (Math.abs(D - (X = (1.0 - C) * X * F + GLON2 - GLON1)) > 5.0E-14);
        if (loopCnt > maxLoopCnt) {
            maxLoopCnt = loopCnt;
        }
        FAZ = Math.atan2(TU1, TU2);
        BAZ = Math.atan2(CU1 * SX, BAZ * CX - SU1 * CU2) + Math.PI;
        X = Math.sqrt((1.0 / R / R - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        D = (0.375 * X * X - 1.0) * X;
        X = E * CY;
        S = 1.0 - E - E;
        S = ((((SY * SY * 4.0 - 3.0) * S * CZ * D / 6.0 - X) * D / 4.0 + CZ) * SY * D + Y) * C * A * R;
        result.distance = S / 1000.0;
        result.azimuth = FAZ * deg;
        if (result.azimuth < 0.0) {
            result.azimuth += 360.0;
        }
        result.backazimuth = BAZ * deg;
        return result;
    }

    public double getAngle() {
        return this.azimuth;
    }

    public double getBackAzimuth() {
        return this.backazimuth;
    }

    public double getDistance() {
        return this.distance;
    }

    public String toString() {
        StringBuilder buf = new StringBuilder();
        buf.append("Azimuth: ");
        buf.append(this.azimuth);
        buf.append(" Back azimuth: ");
        buf.append(this.backazimuth);
        buf.append(" Distance: ");
        buf.append(this.distance);
        return buf.toString();
    }

    public static void main(String[] args) {
        LatLonPointImpl pt1 = new LatLonPointImpl(40.0, -105.0);
        LatLonPointImpl pt2 = new LatLonPointImpl(37.4, -118.4);
        Bearing b = Bearing.calculateBearing(pt1, pt2, null);
        System.out.println("Bearing from " + pt1 + " to " + pt2 + " = \n\t" + b);
        LatLonPointImpl pt3 = new LatLonPointImpl();
        pt3 = Bearing.findPoint(pt1, b.getAngle(), b.getDistance(), pt3);
        System.out.println("using first point, angle and distance, found second point at " + pt3);
        pt3 = Bearing.findPoint(pt2, b.getBackAzimuth(), b.getDistance(), pt3);
        System.out.println("using second point, backazimuth and distance, found first point at " + pt3);
    }

    public static LatLonPointImpl findPoint(Earth e, LatLonPoint pt1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(e, pt1.getLatitude(), pt1.getLongitude(), az, dist, result);
    }

    public static LatLonPointImpl findPoint(LatLonPoint pt1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(defaultEarth, pt1.getLatitude(), pt1.getLongitude(), az, dist, result);
    }

    public static LatLonPointImpl findPoint(double lat1, double lon1, double az, double dist, LatLonPointImpl result) {
        return Bearing.findPoint(defaultEarth, lat1, lon1, az, dist, result);
    }

    public static LatLonPointImpl findPoint(Earth e, double lat1, double lon1, double az, double dist, LatLonPointImpl result) {
        double E;
        double CY;
        double CZ;
        double SY;
        if (result == null) {
            result = new LatLonPointImpl();
        }
        if (dist == 0.0) {
            result.setLatitude(lat1);
            result.setLongitude(lon1);
            return result;
        }
        A = e.getMajor();
        F = e.getFlattening();
        R = 1.0 - F;
        if (az < 0.0) {
            az += 360.0;
        }
        double FAZ = az * rad;
        double GLAT1 = lat1 * rad;
        double GLON1 = lon1 * rad;
        double S = dist * 1000.0;
        double TU = R * Math.sin(GLAT1) / Math.cos(GLAT1);
        double SF = Math.sin(FAZ);
        double CF = Math.cos(FAZ);
        double BAZ = 0.0;
        if (CF != 0.0) {
            BAZ = Math.atan2(TU, CF) * 2.0;
        }
        double CU = 1.0 / Math.sqrt(TU * TU + 1.0);
        double SU = TU * CU;
        double SA = CU * SF;
        double C2A = -SA * SA + 1.0;
        double X = Math.sqrt((1.0 / R / R - 1.0) * C2A + 1.0) + 1.0;
        X = (X - 2.0) / X;
        double C = 1.0 - X;
        C = (X * X / 4.0 + 1.0) / C;
        double D = (0.375 * X * X - 1.0) * X;
        double Y = TU = S / R / A / C;
        do {
            SY = Math.sin(Y);
            CY = Math.cos(Y);
            CZ = Math.cos(BAZ + Y);
            E = CZ * CZ * 2.0 - 1.0;
            C = Y;
            X = E * CY;
            Y = E + E - 1.0;
        } while (Math.abs((Y = (((SY * SY * 4.0 - 3.0) * Y * CZ * D / 6.0 + X) * D / 4.0 - CZ) * SY * D + TU) - C) > 5.0E-14);
        BAZ = CU * CY * CF - SU * SY;
        C = R * Math.sqrt(SA * SA + BAZ * BAZ);
        D = SU * CY + CU * SY * CF;
        double GLAT2 = Math.atan2(D, C);
        C = CU * CY - SU * SY * CF;
        X = Math.atan2(SY * SF, C);
        C = ((-3.0 * C2A + 4.0) * F + 4.0) * C2A * F / 16.0;
        D = ((E * CY * C + CZ) * SY * C + Y) * SA;
        double GLON2 = GLON1 + X - (1.0 - C) * D * F;
        BAZ = (Math.atan2(SA, BAZ) + Math.PI) * deg;
        result.setLatitude(GLAT2 * deg);
        result.setLongitude(GLON2 * deg);
        return result;
    }

    static {
        rad = Math.toRadians(1.0);
        deg = Math.toDegrees(1.0);
        maxLoopCnt = 0;
    }
}

