/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend.graphite;

import java.text.DecimalFormat;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import org.apache.commons.lang3.StringUtils;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.visualizers.backend.AbstractBackendListenerClient;
import org.apache.jmeter.visualizers.backend.BackendListenerContext;
import org.apache.jmeter.visualizers.backend.SamplerMetric;
import org.apache.jmeter.visualizers.backend.graphite.AbstractGraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.GraphiteMetricsSender;
import org.apache.jmeter.visualizers.backend.graphite.TextGraphiteMetricsSender;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class GraphiteBackendListenerClient
extends AbstractBackendListenerClient
implements Runnable {
    private static final int DEFAULT_PLAINTEXT_PROTOCOL_PORT = 2003;
    private static final String TEST_CONTEXT_NAME = "test";
    private static final String ALL_CONTEXT_NAME = "all";
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private static final String DEFAULT_METRICS_PREFIX = "jmeter.";
    private static final String CUMULATED_METRICS = "__cumulated__";
    private static final String METRIC_MAX_ACTIVE_THREADS = "maxAT";
    private static final String METRIC_MIN_ACTIVE_THREADS = "minAT";
    private static final String METRIC_MEAN_ACTIVE_THREADS = "meanAT";
    private static final String METRIC_STARTED_THREADS = "startedT";
    private static final String METRIC_FINISHED_THREADS = "endedT";
    private static final String METRIC_SEPARATOR = ".";
    private static final String METRIC_OK_PREFIX = "ok";
    private static final String METRIC_KO_PREFIX = "ko";
    private static final String METRIC_ALL_PREFIX = "a";
    private static final String METRIC_COUNT = "count";
    private static final String METRIC_MIN_RESPONSE_TIME = "min";
    private static final String METRIC_MAX_RESPONSE_TIME = "max";
    private static final String METRIC_PERCENTILE = "pct";
    private static final String METRIC_OK_COUNT = "ok.count";
    private static final String METRIC_OK_MIN_RESPONSE_TIME = "ok.min";
    private static final String METRIC_OK_MAX_RESPONSE_TIME = "ok.max";
    private static final String METRIC_OK_PERCENTILE_PREFIX = "ok.pct";
    private static final String METRIC_KO_COUNT = "ko.count";
    private static final String METRIC_KO_MIN_RESPONSE_TIME = "ko.min";
    private static final String METRIC_KO_MAX_RESPONSE_TIME = "ko.max";
    private static final String METRIC_KO_PERCENTILE_PREFIX = "ko.pct";
    private static final String METRIC_ALL_COUNT = "a.count";
    private static final String METRIC_ALL_MIN_RESPONSE_TIME = "a.min";
    private static final String METRIC_ALL_MAX_RESPONSE_TIME = "a.max";
    private static final String METRIC_ALL_PERCENTILE_PREFIX = "a.pct";
    private static final long ONE_SECOND = 1L;
    private static final int MAX_POOL_SIZE = 1;
    private static final String DEFAULT_PERCENTILES = "90;95;99";
    private static final String SEPARATOR = ";";
    private static final Object LOCK = new Object();
    private String graphiteHost;
    private int graphitePort;
    private boolean summaryOnly;
    private String rootMetricsPrefix;
    private String samplersList = "";
    private Set<String> samplersToFilter;
    private Map<String, Float> okPercentiles;
    private Map<String, Float> koPercentiles;
    private Map<String, Float> allPercentiles;
    private GraphiteMetricsSender graphiteMetricsManager;
    private ScheduledExecutorService scheduler;
    private ScheduledFuture<?> timerHandle;

    @Override
    public void run() {
        this.sendMetrics();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void sendMetrics() {
        long timestampInSeconds = TimeUnit.SECONDS.convert(System.currentTimeMillis(), TimeUnit.MILLISECONDS);
        Object object = LOCK;
        synchronized (object) {
            for (Map.Entry<String, SamplerMetric> entry : this.getMetricsPerSampler().entrySet()) {
                SamplerMetric metric = entry.getValue();
                if (entry.getKey().equals(CUMULATED_METRICS)) {
                    this.addMetrics(timestampInSeconds, ALL_CONTEXT_NAME, metric);
                } else {
                    this.addMetrics(timestampInSeconds, AbstractGraphiteMetricsSender.sanitizeString(entry.getKey()), metric);
                }
                metric.resetForTimeInterval();
            }
        }
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MIN_ACTIVE_THREADS, Integer.toString(this.getUserMetrics().getMinActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MAX_ACTIVE_THREADS, Integer.toString(this.getUserMetrics().getMaxActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_MEAN_ACTIVE_THREADS, Integer.toString(this.getUserMetrics().getMeanActiveThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_STARTED_THREADS, Integer.toString(this.getUserMetrics().getStartedThreads()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, TEST_CONTEXT_NAME, METRIC_FINISHED_THREADS, Integer.toString(this.getUserMetrics().getFinishedThreads()));
        this.graphiteMetricsManager.writeAndSendMetrics();
    }

    private void addMetrics(long timestampInSeconds, String contextName, SamplerMetric metric) {
        this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_COUNT, Integer.toString(metric.getSuccesses()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_COUNT, Integer.toString(metric.getFailures()));
        this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_COUNT, Integer.toString(metric.getTotal()));
        if (metric.getTotal() > 0) {
            if (metric.getSuccesses() > 0) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_MIN_RESPONSE_TIME, Double.toString(metric.getOkMinTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_OK_MAX_RESPONSE_TIME, Double.toString(metric.getOkMaxTime()));
                for (Map.Entry<String, Float> entry : this.okPercentiles.entrySet()) {
                    this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getOkPercentile(entry.getValue().floatValue())));
                }
            }
            if (metric.getFailures() > 0) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_MIN_RESPONSE_TIME, Double.toString(metric.getKoMinTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_KO_MAX_RESPONSE_TIME, Double.toString(metric.getKoMaxTime()));
                for (Map.Entry<String, Float> entry : this.koPercentiles.entrySet()) {
                    this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getKoPercentile(entry.getValue().floatValue())));
                }
            }
            if (metric.getTotal() > 0) {
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_MIN_RESPONSE_TIME, Double.toString(metric.getAllMinTime()));
                this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, METRIC_ALL_MAX_RESPONSE_TIME, Double.toString(metric.getAllMaxTime()));
                for (Map.Entry<String, Float> entry : this.allPercentiles.entrySet()) {
                    this.graphiteMetricsManager.addMetric(timestampInSeconds, contextName, entry.getKey(), Double.toString(metric.getAllPercentile(entry.getValue().floatValue())));
                }
            }
        }
    }

    public String getSamplersList() {
        return this.samplersList;
    }

    public void setSamplersList(String samplersList) {
        this.samplersList = samplersList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleSampleResults(List<SampleResult> sampleResults, BackendListenerContext context) {
        Object object = LOCK;
        synchronized (object) {
            for (SampleResult sampleResult : sampleResults) {
                this.getUserMetrics().add(sampleResult);
                if (!this.summaryOnly && this.samplersToFilter.contains(sampleResult.getSampleLabel())) {
                    SamplerMetric samplerMetric = this.getSamplerMetric(sampleResult.getSampleLabel());
                    samplerMetric.add(sampleResult);
                }
                SamplerMetric cumulatedMetrics = this.getSamplerMetric(CUMULATED_METRICS);
                cumulatedMetrics.add(sampleResult);
            }
        }
    }

    @Override
    public void setupTest(BackendListenerContext context) throws Exception {
        String graphiteMetricsSenderClass = context.getParameter("graphiteMetricsSender");
        this.graphiteHost = context.getParameter("graphiteHost");
        this.graphitePort = context.getIntParameter("graphitePort", 2003);
        this.summaryOnly = context.getBooleanParameter("summaryOnly", true);
        this.samplersList = context.getParameter("samplersList", "");
        this.rootMetricsPrefix = context.getParameter("rootMetricsPrefix", DEFAULT_METRICS_PREFIX);
        String percentilesAsString = context.getParameter("percentiles", DEFAULT_METRICS_PREFIX);
        String[] percentilesStringArray = percentilesAsString.split(SEPARATOR);
        this.okPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.koPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        this.allPercentiles = new HashMap<String, Float>(percentilesStringArray.length);
        DecimalFormat format = new DecimalFormat("0.##");
        for (int i = 0; i < percentilesStringArray.length; ++i) {
            if (StringUtils.isEmpty((CharSequence)percentilesStringArray[i].trim())) continue;
            try {
                Float percentileValue = Float.valueOf(Float.parseFloat(percentilesStringArray[i].trim()));
                this.okPercentiles.put(METRIC_OK_PERCENTILE_PREFIX + AbstractGraphiteMetricsSender.sanitizeString(format.format(percentileValue)), percentileValue);
                this.koPercentiles.put(METRIC_KO_PERCENTILE_PREFIX + AbstractGraphiteMetricsSender.sanitizeString(format.format(percentileValue)), percentileValue);
                this.allPercentiles.put(METRIC_ALL_PERCENTILE_PREFIX + AbstractGraphiteMetricsSender.sanitizeString(format.format(percentileValue)), percentileValue);
                continue;
            }
            catch (Exception e) {
                LOGGER.error("Error parsing percentile:'" + percentilesStringArray[i] + "'", (Throwable)e);
            }
        }
        Class<?> clazz = Class.forName(graphiteMetricsSenderClass);
        this.graphiteMetricsManager = (GraphiteMetricsSender)clazz.newInstance();
        this.graphiteMetricsManager.setup(this.graphiteHost, this.graphitePort, this.rootMetricsPrefix);
        String[] samplers = this.samplersList.split(SEPARATOR);
        this.samplersToFilter = new HashSet<String>();
        for (String samplerName : samplers) {
            this.samplersToFilter.add(samplerName);
        }
        this.scheduler = Executors.newScheduledThreadPool(1);
        this.timerHandle = this.scheduler.scheduleAtFixedRate(this, 1L, 1L, TimeUnit.SECONDS);
    }

    @Override
    public void teardownTest(BackendListenerContext context) throws Exception {
        boolean cancelState = this.timerHandle.cancel(false);
        if (LOGGER.isDebugEnabled()) {
            LOGGER.debug("Canceled state:" + cancelState);
        }
        this.scheduler.shutdown();
        try {
            this.scheduler.awaitTermination(30L, TimeUnit.SECONDS);
        }
        catch (InterruptedException e) {
            LOGGER.error("Error waiting for end of scheduler");
        }
        this.sendMetrics();
        this.samplersToFilter.clear();
        this.graphiteMetricsManager.destroy();
        super.teardownTest(context);
    }

    @Override
    public Arguments getDefaultParameters() {
        Arguments arguments = new Arguments();
        arguments.addArgument("graphiteMetricsSender", TextGraphiteMetricsSender.class.getName());
        arguments.addArgument("graphiteHost", "");
        arguments.addArgument("graphitePort", Integer.toString(2003));
        arguments.addArgument("rootMetricsPrefix", DEFAULT_METRICS_PREFIX);
        arguments.addArgument("summaryOnly", "true");
        arguments.addArgument("samplersList", "");
        arguments.addArgument("percentiles", DEFAULT_PERCENTILES);
        return arguments;
    }
}

