/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.test;

import java.awt.Color;
import java.awt.Paint;
import org.jCharts.chartData.ChartDataException;
import org.jCharts.chartData.PieChartDataSet;
import org.jCharts.imageMap.ImageMap;
import org.jCharts.nonAxisChart.PieChart2D;
import org.jCharts.properties.ChartProperties;
import org.jCharts.properties.LegendProperties;
import org.jCharts.properties.PieChart2DProperties;
import org.jCharts.properties.PropertyException;
import org.jCharts.properties.util.ChartStroke;
import org.jCharts.test.ChartTestDriver;
import org.jCharts.test.HTMLGenerator;
import org.jCharts.test.TestDataGenerator;
import org.jCharts.types.PieLabelType;

abstract class PieTestDriver {
    PieTestDriver() {
    }

    static void test() throws ChartDataException, PropertyException {
        int n = 15;
        HTMLGenerator hTMLGenerator = new HTMLGenerator("pieChart2dTest.html");
        int n2 = 0;
        while (n2 < n) {
            ImageMap imageMap;
            boolean bl = true;
            int n3 = (int)TestDataGenerator.getRandomNumber(1.0, 10.0);
            PieChartDataSet pieChartDataSet = PieTestDriver.getPieChartDataSet(n3, 1, 7);
            int n4 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            int n5 = (int)TestDataGenerator.getRandomNumber(100.0, 600.0);
            LegendProperties legendProperties = new LegendProperties();
            TestDataGenerator.randomizeLegend(legendProperties);
            ChartProperties chartProperties = new ChartProperties();
            chartProperties.setBackgroundPaint(TestDataGenerator.getRandomPaint());
            PieChart2D pieChart2D = new PieChart2D(pieChartDataSet, legendProperties, chartProperties, n4, n5);
            String string = "pieChart2d" + n2 + ".png";
            if (bl) {
                pieChart2D.renderWithImageMap();
                imageMap = pieChart2D.getImageMap();
            } else {
                imageMap = null;
            }
            ChartTestDriver.exportImage(pieChart2D, string);
            hTMLGenerator.chartTableStart("PieChart2D", string, imageMap);
            hTMLGenerator.propertiesTableRowStart();
            pieChartDataSet.toHTML(hTMLGenerator);
            hTMLGenerator.propertiesTableRowStart();
            pieChart2D.toHTML(hTMLGenerator, string);
            hTMLGenerator.addLineBreak();
            ++n2;
        }
        hTMLGenerator.saveFile();
    }

    private static PieChartDataSet getPieChartDataSet(int n, int n2, int n3) throws ChartDataException {
        PieChart2DProperties pieChart2DProperties = new PieChart2DProperties();
        pieChart2DProperties.setBorderPaint(TestDataGenerator.getRandomPaint());
        String[] stringArray = TestDataGenerator.getRandomStrings(n, (int)TestDataGenerator.getRandomNumber(3.0, 20.0), false);
        Paint[] paintArray = TestDataGenerator.getRandomPaints(n);
        return new PieChartDataSet("This is a test title", TestDataGenerator.getRandomNumbers(n, n2, n3), stringArray, paintArray, pieChart2DProperties);
    }

    public static void main(String[] stringArray) throws ChartDataException, PropertyException {
        double[] dArray = new double[]{73.6, 5.0, 1.5, 3.6};
        String[] stringArray2 = new String[]{"Equities", "Bonds", "Money Market", "Alternative Investments"};
        Paint[] paintArray = new Paint[]{Color.lightGray, Color.green, Color.blue, Color.red};
        PieChart2DProperties pieChart2DProperties = new PieChart2DProperties();
        pieChart2DProperties.setPieLabelType(PieLabelType.VALUE_LABELS);
        pieChart2DProperties.setZeroDegreeOffset(110.0f);
        LegendProperties legendProperties = new LegendProperties();
        legendProperties.setPlacement(1);
        legendProperties.setNumColumns(1);
        PieChartDataSet pieChartDataSet = new PieChartDataSet("Investment Categories", dArray, stringArray2, paintArray, pieChart2DProperties);
        ChartProperties chartProperties = new ChartProperties();
        chartProperties.setBorderStroke(ChartStroke.DEFAULT_CHART_OUTLINE);
        PieChart2D pieChart2D = new PieChart2D(pieChartDataSet, legendProperties, chartProperties, 520, 520);
        ChartTestDriver.exportImage(pieChart2D, "pie.png");
    }
}

