/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.IOException;
import java.io.OutputStream;
import java.util.Vector;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.MultipartDataSource;
import javax.mail.Part;

public abstract class Multipart {
    protected String contentType;
    protected Part parent;
    protected Vector parts = new Vector();

    protected Multipart() {
    }

    public void addBodyPart(BodyPart part) throws MessagingException {
        this.parts.add(part);
    }

    public void addBodyPart(BodyPart part, int pos) throws MessagingException {
        this.parts.add(pos, part);
    }

    public BodyPart getBodyPart(int index) throws MessagingException {
        return (BodyPart)this.parts.get(index);
    }

    public String getContentType() {
        return this.contentType;
    }

    public int getCount() throws MessagingException {
        return this.parts.size();
    }

    public Part getParent() {
        return this.parent;
    }

    public boolean removeBodyPart(BodyPart part) throws MessagingException {
        return this.parts.remove(part);
    }

    public void removeBodyPart(int index) throws MessagingException {
        this.parts.remove(index);
    }

    protected void setMultipartDataSource(MultipartDataSource mds) throws MessagingException {
        this.contentType = mds.getContentType();
        int size = mds.getCount();
        for (int i = 0; i < size; ++i) {
            this.addBodyPart(mds.getBodyPart(i));
        }
    }

    public void setParent(Part part) {
        this.parent = part;
    }

    public abstract void writeTo(OutputStream var1) throws IOException, MessagingException;
}

