/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.component.UIDataAdaptor;
import org.richfaces.component.UIDataGrid;
import org.richfaces.renderkit.AbstractRowsRenderer;
import org.richfaces.renderkit.TableHolder;

public abstract class AbstractGridRenderer
extends AbstractRowsRenderer {
    public void encodeHeader(FacesContext context, UIDataGrid table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent header = table.getHeader();
        if (header != null) {
            writer.startElement("thead", (UIComponent)table);
            String headerClass = (String)table.getAttributes().get("headerClass");
            this.encodeTableHeaderFacet(context, table.getColumns(), writer, header, "rich-table-header", "rich-table-header-continue", "rich-table-headercell", headerClass, "th");
            writer.endElement("thead");
        }
    }

    public void encodeFooter(FacesContext context, UIDataGrid table) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        UIComponent footer = table.getFooter();
        if (footer != null) {
            writer.startElement("tfoot", (UIComponent)table);
            String footerClass = (String)table.getAttributes().get("footerClass");
            this.encodeTableHeaderFacet(context, table.getColumns(), writer, footer, "rich-table-footer", "rich-table-footer-continue", "rich-table-footercell", footerClass, "td");
            writer.endElement("tfoot");
        }
    }

    public void encodeOneRow(FacesContext context, TableHolder holder) throws IOException {
        int cols;
        UIDataAdaptor table = holder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        int currentRow = holder.getRowCounter();
        Integer columns = (Integer)table.getAttributes().get("columns");
        int n = cols = null != columns && columns != Integer.MIN_VALUE ? columns : 1;
        if (columns == 0) {
            cols = 1;
        }
        int gridRowCounter = holder.getGridRowCounter();
        if (cols > 0 && currentRow % cols == 0) {
            if (currentRow != 0) {
                writer.endElement("tr");
                holder.setGridRowCounter(++gridRowCounter);
            }
            writer.startElement("tr", (UIComponent)table);
            String rowClass = holder.getRowClass(gridRowCounter);
            this.encodeStyleClass(writer, null, "rich-table-row", null, rowClass);
            this.encodeRowEvents(context, table);
        }
        writer.startElement("td", (UIComponent)table);
        this.getUtils().encodeId(context, (UIComponent)table);
        String columnClass = holder.getColumnClass(currentRow - gridRowCounter * cols);
        this.encodeStyleClass(writer, null, "rich-table-cell", null, columnClass);
        this.renderChildren(context, (UIComponent)table);
        writer.endElement("td");
    }

    protected void doCleanup(FacesContext context, TableHolder tableHolder) throws IOException {
        int rest = 0;
        UIDataAdaptor table = tableHolder.getTable();
        ResponseWriter writer = context.getResponseWriter();
        Integer columns = (Integer)table.getAttributes().get("columns");
        boolean isCleanable = null != columns && columns != Integer.MIN_VALUE;
        int cols = isCleanable ? columns : 1;
        rest = tableHolder.getRowCounter() - tableHolder.getGridRowCounter() * cols;
        if (rest != 0) {
            for (int i = rest; i < columns; ++i) {
                writer.startElement("td", (UIComponent)table);
                String columnClass = tableHolder.getColumnClass(i);
                this.encodeStyleClass(writer, null, "rich-table-cell", null, columnClass);
                writer.write("&#160;");
                writer.endElement("td");
            }
        }
        if (rest != 0) {
            writer.endElement("tr");
        }
    }
}

