/*
 * Decompiled with CFR 0.152.
 */
package liquibase.change.core;

import liquibase.change.AbstractChange;
import liquibase.database.Database;
import liquibase.database.core.SQLiteDatabase;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.DropForeignKeyConstraintStatement;

public class DropForeignKeyConstraintChange
extends AbstractChange {
    private String baseTableSchemaName;
    private String baseTableName;
    private String constraintName;

    public DropForeignKeyConstraintChange() {
        super("dropForeignKeyConstraint", "Drop Foreign Key Constraint", 1);
    }

    public String getBaseTableSchemaName() {
        return this.baseTableSchemaName;
    }

    public void setBaseTableSchemaName(String baseTableSchemaName) {
        this.baseTableSchemaName = baseTableSchemaName;
    }

    public String getBaseTableName() {
        return this.baseTableName;
    }

    public void setBaseTableName(String baseTableName) {
        this.baseTableName = baseTableName;
    }

    public String getConstraintName() {
        return this.constraintName;
    }

    public void setConstraintName(String constraintName) {
        this.constraintName = constraintName;
    }

    public SqlStatement[] generateStatements(Database database) {
        if (database instanceof SQLiteDatabase) {
            return this.generateStatementsForSQLiteDatabase(database);
        }
        return new SqlStatement[]{new DropForeignKeyConstraintStatement(this.getBaseTableSchemaName() == null ? database.getDefaultSchemaName() : this.getBaseTableSchemaName(), this.getBaseTableName(), this.getConstraintName())};
    }

    private SqlStatement[] generateStatementsForSQLiteDatabase(Database database) {
        return new SqlStatement[0];
    }

    public String getConfirmationMessage() {
        return "Foreign key " + this.getConstraintName() + " dropped";
    }
}

