/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit;

import java.io.IOException;
import java.util.Map;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.convert.ConverterException;
import org.ajax4jsf.javascript.JSFunctionDefinition;
import org.ajax4jsf.javascript.ScriptUtils;
import org.ajax4jsf.renderkit.HeaderResourcesRendererBase;
import org.ajax4jsf.util.InputUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.richfaces.component.UIInplaceInput;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class InplaceInputBaseRenderer
extends HeaderResourcesRendererBase {
    private static Log logger = LogFactory.getLog(InplaceInputBaseRenderer.class);
    private static final String CONTROLS_FACET = "controls";
    private static final String EMPTY_DEFAULT_LABEL = "\u00a0\u00a0\u00a0";

    protected Class<? extends UIComponent> getComponentClass() {
        return UIInplaceInput.class;
    }

    protected void doDecode(FacesContext context, UIComponent component) {
        UIInplaceInput inplaceInput = null;
        if (!(component instanceof UIInplaceInput)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is not an instance or a sub class of UIInplaceInput"));
            }
            return;
        }
        inplaceInput = (UIInplaceInput)component;
        String clientId = component.getClientId(context);
        if (clientId == null) {
            throw new NullPointerException("component client id is NULL");
        }
        if (InputUtils.isDisabled((UIComponent)inplaceInput) || InputUtils.isReadOnly((UIComponent)inplaceInput)) {
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("No decoding necessary since the component " + component.getId() + " is disabled"));
            }
            return;
        }
        Map request = context.getExternalContext().getRequestParameterMap();
        String newValue = (String)request.get(clientId);
        if (newValue != null) {
            inplaceInput.setSubmittedValue(newValue);
        }
    }

    public void encodeControlsFacet(FacesContext context, UIComponent component) throws IOException {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        if (facet != null && facet.isRendered()) {
            this.renderChild(context, facet);
        }
    }

    public boolean isControlsFacetExists(FacesContext context, UIComponent component) {
        UIComponent facet = component.getFacet(CONTROLS_FACET);
        return facet != null && facet.isRendered();
    }

    public String getDefaultLabel(FacesContext context, UIComponent component) {
        String defaultLabel = (String)component.getAttributes().get("defaultLabel");
        if (defaultLabel == null || defaultLabel.trim().equals("")) {
            defaultLabel = EMPTY_DEFAULT_LABEL;
        }
        return defaultLabel;
    }

    public String getAsEventHandler(FacesContext context, UIComponent component, String attributeName) {
        JSFunctionDefinition script = this.getUtils().getAsEventHandler(context, component, attributeName, null);
        return ScriptUtils.toScript((Object)script);
    }

    public Object getConvertedValue(FacesContext context, UIComponent component, Object submittedValue) throws ConverterException {
        return InputUtils.getConvertedValue((FacesContext)context, (UIComponent)component, (Object)submittedValue);
    }

    protected String getConvertedStringValue(FacesContext context, UIInplaceInput component, Object value) {
        return InputUtils.getConvertedStringValue((FacesContext)context, (UIComponent)component, (Object)value);
    }

    protected boolean isEmptyDefaultLabel(String defaultLabel) {
        return EMPTY_DEFAULT_LABEL.equals(defaultLabel);
    }
}

