/*
 * Decompiled with CFR 0.152.
 */
package liquibase.util.csv;

import java.io.IOException;
import java.io.Writer;
import java.sql.Date;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Time;
import java.sql.Timestamp;
import liquibase.util.ISODateFormat;

public class CSVWriter
extends liquibase.util.csv.opencsv.CSVWriter {
    private static final ISODateFormat ISO_DATE_FORMAT = new ISODateFormat();

    public CSVWriter(Writer writer) {
        super(writer);
    }

    public CSVWriter(Writer writer, char c) {
        super(writer, c);
    }

    public CSVWriter(Writer writer, char c, char c1) {
        super(writer, c, c1);
    }

    public CSVWriter(Writer writer, char c, char c1, char c2) {
        super(writer, c, c1, c2);
    }

    public CSVWriter(Writer writer, char c, char c1, String s) {
        super(writer, c, c1, s);
    }

    public CSVWriter(Writer writer, char c, char c1, char c2, String s) {
        super(writer, c, c1, c2, s);
    }

    public void writeAll(ResultSet rs, boolean includeColumnNames) throws SQLException, IOException {
        ResultSetMetaData metadata = rs.getMetaData();
        if (includeColumnNames) {
            this.writeColumnNames(metadata);
        }
        int columnCount = metadata.getColumnCount();
        while (rs.next()) {
            String[] nextLine = new String[columnCount];
            for (int i = 0; i < columnCount; ++i) {
                nextLine[i] = this.getColumnValue(rs, metadata.getColumnType(i + 1), i + 1);
            }
            this.writeNext(nextLine);
        }
    }

    private String getColumnValue(ResultSet rs, int colType, int colIndex) throws SQLException, IOException {
        Object value = rs.getObject(colIndex);
        if (rs.wasNull()) {
            return "NULL";
        }
        if (value instanceof Date) {
            return ISO_DATE_FORMAT.format((Date)value);
        }
        if (value instanceof Time) {
            return ISO_DATE_FORMAT.format((Time)value);
        }
        if (value instanceof Timestamp) {
            return ISO_DATE_FORMAT.format((Timestamp)value);
        }
        return value.toString();
    }
}

