/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.DataConverter;
import com.rmemoria.datastream.DataInterceptor;
import com.rmemoria.datastream.DataMarshaller;
import com.rmemoria.datastream.DataUnmarshaller;
import com.rmemoria.datastream.StreamContext;
import com.rmemoria.datastream.StreamFileType;
import com.rmemoria.datastream.StreamFileTypeXML;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.ClassPropertyScanner;
import com.rmemoria.datastream.impl.CollectionMetaData;
import com.rmemoria.datastream.impl.DefaultConverters;
import com.rmemoria.datastream.impl.XmlDataMarshallerImpl;
import com.rmemoria.datastream.impl.XmlDataUnmarshallerImpl;
import com.rmemoria.datastream.jaxb.GraphSchema;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Unmarshaller;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;

public class StreamContextImpl
implements StreamContext {
    private GraphSchema graphSchema;
    private List<DataInterceptor> interceptors = new ArrayList<DataInterceptor>();
    private Map<Class, DataConverter> converters = new HashMap<Class, DataConverter>();
    private ClassMetaData classMetaData;
    private CollectionMetaData collectionMetaData;
    private static final DataConverter defaultConverter = new DefaultConverters();

    @Override
    public void setSchema(URL schema) {
        try {
            Unmarshaller unmarshaller = this.createSAXUnmarshaller();
            this.graphSchema = (GraphSchema)unmarshaller.unmarshal(schema);
            this.initializeGraphSchema();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void setSchema(InputStream inputStream) {
        Unmarshaller unmarshaller = this.createSAXUnmarshaller();
        try {
            this.graphSchema = (GraphSchema)unmarshaller.unmarshal(inputStream);
        }
        catch (JAXBException e) {
            e.printStackTrace();
            throw new RuntimeException(e);
        }
        this.initializeGraphSchema();
    }

    private void initializeGraphSchema() {
        if (this.graphSchema.getObjectGraph() != null && this.graphSchema.getObjectCollection() != null) {
            throw new IllegalArgumentException("The schema contains more than 1 item bellow graphSchema tag");
        }
        ClassPropertyScanner scan = new ClassPropertyScanner();
        if (this.graphSchema.getObjectGraph() != null) {
            this.classMetaData = scan.scan(this, this.graphSchema.getObjectGraph());
        } else {
            this.collectionMetaData = scan.scan(this, this.graphSchema.getObjectCollection());
        }
    }

    protected Unmarshaller createSAXUnmarshaller() {
        try {
            SchemaFactory sf = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
            URL url = this.getClass().getClassLoader().getResource("datastream-1.2.xsd");
            Schema xmlSchema = sf.newSchema(url);
            JAXBContext context = JAXBContext.newInstance((Class[])new Class[]{GraphSchema.class});
            Unmarshaller unmarshaller = context.createUnmarshaller();
            unmarshaller.setSchema(xmlSchema);
            return unmarshaller;
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public DataConverter findConverter(Class type) {
        DataConverter converter = this.converters.get(type);
        if (converter != null) {
            return converter;
        }
        return defaultConverter;
    }

    @Override
    public DataMarshaller createMarshaller(Class<? extends StreamFileType> type) {
        if (type != StreamFileTypeXML.class) {
            throw new RuntimeException("Only the interface " + StreamFileTypeXML.class.getName() + " is supported by now");
        }
        return new XmlDataMarshallerImpl(this);
    }

    @Override
    public DataUnmarshaller createUnmarshaller(Class<? extends StreamFileType> type) {
        if (type != StreamFileTypeXML.class) {
            throw new RuntimeException("Only the interface " + StreamFileTypeXML.class.getName() + " is supported by now");
        }
        return new XmlDataUnmarshallerImpl(this);
    }

    @Override
    public void addInterceptor(DataInterceptor interceptor) {
        this.interceptors.add(interceptor);
    }

    @Override
    public void removeInterceptor(DataInterceptor interceptor) {
        this.interceptors.remove(interceptor);
    }

    @Override
    public void setConverter(Class type, DataConverter converter) {
        this.converters.put(type, converter);
    }

    protected Class getObjectClass(Object object) {
        for (DataInterceptor interceptor : this.interceptors) {
            Class clazz = interceptor.getObjectClass(object);
            if (clazz == null) continue;
            return clazz;
        }
        return object.getClass();
    }

    protected ClassMetaData findClassMetaData(Object object) {
        Class clazz = this.getObjectClass(object);
        return this.findClassMetaDataByClass(clazz);
    }

    protected ClassMetaData findClassMetaDataByClass(Class clazz) {
        if (this.classMetaData != null) {
            if (this.classMetaData.getGraphClass() == clazz) {
                return this.classMetaData;
            }
        } else {
            for (ClassMetaData cmd : this.collectionMetaData.getClassesMetaData()) {
                if (cmd.getGraphClass() != clazz) continue;
                return cmd;
            }
        }
        return null;
    }

    protected ClassMetaData findClassByElement(String elname) {
        if (this.classMetaData != null) {
            if (this.classMetaData.getGraph().getName().equals(elname)) {
                return this.classMetaData;
            }
        } else {
            for (ClassMetaData clazz : this.collectionMetaData.getClassesMetaData()) {
                if (!clazz.getGraph().getName().equals(elname)) continue;
                return clazz;
            }
        }
        return null;
    }

    @Override
    public Object createInstance(Class clazz, Map<String, Object> params) {
        DataInterceptor dataInterceptor;
        Object val = null;
        Iterator<DataInterceptor> iterator = this.interceptors.iterator();
        while (iterator.hasNext() && (val = (dataInterceptor = iterator.next()).newObject(clazz, params)) == null) {
        }
        if (val == null && params.size() > 0) {
            try {
                val = clazz.newInstance();
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
        return val;
    }

    public GraphSchema getGraphSchema() {
        return this.graphSchema;
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public CollectionMetaData getCollectionMetaData() {
        return this.collectionMetaData;
    }
}

