/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.util.HashMap;
import java.util.Map;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import org.apache.jmeter.samplers.Clearable;
import org.apache.jmeter.samplers.SampleResult;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.MonitorAccumModel;
import org.apache.jmeter.visualizers.MonitorGraph;
import org.apache.jmeter.visualizers.MonitorListener;
import org.apache.jmeter.visualizers.MonitorModel;

public class MonitorPerformancePanel
extends JSplitPane
implements TreeSelectionListener,
MonitorListener,
Clearable {
    private static final long serialVersionUID = 240L;
    private JScrollPane TREEPANE;
    private JPanel GRAPHPANEL;
    private JTree SERVERTREE;
    private DefaultTreeModel TREEMODEL;
    private final MonitorGraph GRAPH;
    private DefaultMutableTreeNode ROOTNODE;
    private final Map<String, DefaultMutableTreeNode> SERVERMAP;
    private final MonitorAccumModel MODEL;
    private SampleResult ROOTSAMPLE;
    private final String LEGEND_HEALTH = JMeterUtils.getResString((String)"monitor_legend_health");
    private final String LEGEND_LOAD = JMeterUtils.getResString((String)"monitor_legend_load");
    private final String LEGEND_MEM = JMeterUtils.getResString((String)"monitor_legend_memory_per");
    private final String LEGEND_THREAD = JMeterUtils.getResString((String)"monitor_legend_thread_per");
    private final ImageIcon LEGEND_HEALTH_ICON = JMeterUtils.getImage((String)"monitor-green-legend.gif");
    private final ImageIcon LEGEND_LOAD_ICON = JMeterUtils.getImage((String)"monitor-blue-legend.gif");
    private final ImageIcon LEGEND_MEM_ICON = JMeterUtils.getImage((String)"monitor-orange-legend.gif");
    private final ImageIcon LEGEND_THREAD_ICON = JMeterUtils.getImage((String)"monitor-red-legend.gif");
    private final String GRID_LABEL_TOP = JMeterUtils.getResString((String)"monitor_label_left_top");
    private final String GRID_LABEL_MIDDLE = JMeterUtils.getResString((String)"monitor_label_left_middle");
    private final String GRID_LABEL_BOTTOM = JMeterUtils.getResString((String)"monitor_label_left_bottom");
    private final String GRID_LABEL_HEALTHY = JMeterUtils.getResString((String)"monitor_label_right_healthy");
    private final String GRID_LABEL_DEAD = JMeterUtils.getResString((String)"monitor_label_right_dead");
    private final String PERF_TITLE = JMeterUtils.getResString((String)"monitor_performance_title");
    private final String SERVER_TITLE = JMeterUtils.getResString((String)"monitor_performance_servers");
    private Font plaintext = new Font("plain", 0, 10);

    @Deprecated
    public MonitorPerformancePanel() {
        this.SERVERMAP = null;
        this.MODEL = null;
        this.GRAPH = null;
    }

    public MonitorPerformancePanel(MonitorAccumModel model, MonitorGraph graph) {
        this.SERVERMAP = new HashMap<String, DefaultMutableTreeNode>();
        this.MODEL = model;
        this.MODEL.addListener(this);
        this.GRAPH = graph;
        this.init();
    }

    private void init() {
        this.ROOTSAMPLE = new SampleResult();
        this.ROOTSAMPLE.setSampleLabel(this.SERVER_TITLE);
        this.ROOTSAMPLE.setSuccessful(true);
        this.ROOTNODE = new DefaultMutableTreeNode(this.ROOTSAMPLE);
        this.TREEMODEL = new DefaultTreeModel(this.ROOTNODE);
        this.SERVERTREE = new JTree(this.TREEMODEL);
        this.SERVERTREE.getSelectionModel().setSelectionMode(1);
        this.SERVERTREE.addTreeSelectionListener(this);
        this.SERVERTREE.setShowsRootHandles(true);
        this.TREEPANE = new JScrollPane(this.SERVERTREE);
        this.TREEPANE.setPreferredSize(new Dimension(150, 200));
        this.add((Component)this.TREEPANE, "left");
        this.setDividerLocation(0.18);
        JPanel right = new JPanel();
        right.setLayout(new BorderLayout());
        JLabel title = new JLabel(" " + this.PERF_TITLE);
        title.setPreferredSize(new Dimension(200, 40));
        this.GRAPHPANEL = new JPanel();
        this.GRAPHPANEL.setLayout(new BorderLayout());
        this.GRAPHPANEL.setMaximumSize(new Dimension(this.MODEL.getBufferSize(), this.MODEL.getBufferSize()));
        this.GRAPHPANEL.setBackground(Color.white);
        this.GRAPHPANEL.add((Component)this.GRAPH, "Center");
        right.add((Component)this.GRAPHPANEL, "Center");
        right.add((Component)title, "North");
        right.add((Component)this.createLegend(), "South");
        right.add((Component)this.createLeftGridLabels(), "West");
        right.add((Component)this.createRightGridLabels(), "East");
        this.add((Component)right, "right");
    }

    private JPanel createLegend() {
        Dimension lsize = new Dimension(130, 18);
        JPanel legend = new JPanel();
        legend.setLayout(new FlowLayout());
        JLabel load = new JLabel(this.LEGEND_LOAD);
        load.setFont(this.plaintext);
        load.setPreferredSize(lsize);
        load.setIcon(this.LEGEND_LOAD_ICON);
        legend.add(load);
        JLabel mem = new JLabel(this.LEGEND_MEM);
        mem.setFont(this.plaintext);
        mem.setPreferredSize(lsize);
        mem.setIcon(this.LEGEND_MEM_ICON);
        legend.add(mem);
        JLabel thd = new JLabel(this.LEGEND_THREAD);
        thd.setFont(this.plaintext);
        thd.setPreferredSize(lsize);
        thd.setIcon(this.LEGEND_THREAD_ICON);
        legend.add(thd);
        JLabel health = new JLabel(this.LEGEND_HEALTH);
        health.setFont(this.plaintext);
        health.setPreferredSize(lsize);
        health.setIcon(this.LEGEND_HEALTH_ICON);
        legend.add(health);
        return legend;
    }

    private JPanel createLeftGridLabels() {
        Dimension lsize = new Dimension(33, 20);
        JPanel labels = new JPanel();
        labels.setLayout(new BorderLayout());
        JLabel top = new JLabel(" " + this.GRID_LABEL_TOP);
        top.setFont(this.plaintext);
        top.setPreferredSize(lsize);
        labels.add((Component)top, "North");
        JLabel mid = new JLabel(" " + this.GRID_LABEL_MIDDLE);
        mid.setFont(this.plaintext);
        mid.setPreferredSize(lsize);
        labels.add((Component)mid, "Center");
        JLabel bottom = new JLabel(" " + this.GRID_LABEL_BOTTOM);
        bottom.setFont(this.plaintext);
        bottom.setPreferredSize(lsize);
        labels.add((Component)bottom, "South");
        return labels;
    }

    private JPanel createRightGridLabels() {
        JPanel labels = new JPanel();
        labels.setLayout(new BorderLayout());
        labels.setPreferredSize(new Dimension(40, this.GRAPHPANEL.getWidth() - 100));
        Dimension lsize = new Dimension(40, 20);
        JLabel h = new JLabel(this.GRID_LABEL_HEALTHY);
        h.setFont(this.plaintext);
        h.setPreferredSize(lsize);
        labels.add((Component)h, "North");
        JLabel d = new JLabel(this.GRID_LABEL_DEAD);
        d.setFont(this.plaintext);
        d.setPreferredSize(lsize);
        labels.add((Component)d, "South");
        return labels;
    }

    @Override
    public synchronized void addSample(MonitorModel model) {
        Object usrobj;
        DefaultMutableTreeNode node;
        if (!this.SERVERMAP.containsKey(model.getURL())) {
            DefaultMutableTreeNode newnode = new DefaultMutableTreeNode(model);
            newnode.setAllowsChildren(false);
            this.SERVERMAP.put(model.getURL(), newnode);
            this.ROOTNODE.add(newnode);
            this.TREEPANE.updateUI();
        }
        if ((node = (DefaultMutableTreeNode)this.SERVERTREE.getLastSelectedPathComponent()) != null && (usrobj = node.getUserObject()) instanceof MonitorModel) {
            this.GRAPH.updateGui((MonitorModel)usrobj);
        }
    }

    @Override
    public void valueChanged(TreeSelectionEvent e) {
        if (this.SERVERTREE.getLastSelectedPathComponent() != null) {
            DefaultMutableTreeNode node = (DefaultMutableTreeNode)this.SERVERTREE.getLastSelectedPathComponent();
            Object usrobj = node.getUserObject();
            if (usrobj instanceof MonitorModel) {
                MonitorModel mo = (MonitorModel)usrobj;
                this.GRAPH.updateGui(mo);
                this.updateUI();
            }
            this.TREEPANE.updateUI();
        }
    }

    public void clearData() {
        this.SERVERMAP.clear();
        this.ROOTNODE.removeAllChildren();
        this.SERVERTREE.updateUI();
        this.GRAPH.clearData();
    }
}

