/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.text.DecimalFormat;
import org.apache.jmeter.samplers.SampleResult;

public class RunningSample {
    private final DecimalFormat rateFormatter = new DecimalFormat("#.0");
    private final DecimalFormat errorFormatter = new DecimalFormat("#0.00%");
    private long counter;
    private long runningSum;
    private long max;
    private long min;
    private long errorCount;
    private long firstTime;
    private long lastTime;
    private final String label;
    private final int index;

    public RunningSample(String label, int index) {
        this.label = label;
        this.index = index;
        this.init();
    }

    public RunningSample(RunningSample src) {
        this.counter = src.counter;
        this.errorCount = src.errorCount;
        this.firstTime = src.firstTime;
        this.index = src.index;
        this.label = src.label;
        this.lastTime = src.lastTime;
        this.max = src.max;
        this.min = src.min;
        this.runningSum = src.runningSum;
    }

    private void init() {
        this.counter = 0L;
        this.runningSum = 0L;
        this.max = Long.MIN_VALUE;
        this.min = Long.MAX_VALUE;
        this.errorCount = 0L;
        this.firstTime = Long.MAX_VALUE;
        this.lastTime = 0L;
    }

    public void clear() {
        this.init();
    }

    public long getElapsed() {
        if (this.lastTime == 0L) {
            return 0L;
        }
        return this.lastTime - this.firstTime;
    }

    public double getRate() {
        if (this.counter == 0L) {
            return 0.0;
        }
        long howLongRunning = this.lastTime - this.firstTime;
        if (howLongRunning == 0L) {
            return Double.MAX_VALUE;
        }
        return (double)this.counter / (double)howLongRunning * 1000.0;
    }

    public double getRatePerMin() {
        if (this.counter == 0L) {
            return 0.0;
        }
        long howLongRunning = this.lastTime - this.firstTime;
        if (howLongRunning == 0L) {
            return Double.MAX_VALUE;
        }
        return (double)this.counter / (double)howLongRunning * 60000.0;
    }

    public String getRateString() {
        double rate = this.getRate();
        if (rate == Double.MAX_VALUE) {
            return "N/A";
        }
        String unit = "sec";
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "min";
        }
        if (rate < 1.0) {
            rate *= 60.0;
            unit = "hour";
        }
        return this.rateFormatter.format(rate) + "/" + unit;
    }

    public String getLabel() {
        return this.label;
    }

    public int getIndex() {
        return this.index;
    }

    public void addSample(SampleResult res) {
        long aTimeInMillis = res.getTime();
        this.counter += (long)res.getSampleCount();
        this.errorCount += (long)res.getErrorCount();
        long startTime = res.getStartTime();
        long endTime = res.getEndTime();
        if (this.firstTime > startTime) {
            this.firstTime = startTime;
        }
        if (this.lastTime < endTime) {
            this.lastTime = endTime;
        }
        this.runningSum += aTimeInMillis;
        if (aTimeInMillis > this.max) {
            this.max = aTimeInMillis;
        }
        if (aTimeInMillis < this.min) {
            this.min = aTimeInMillis;
        }
    }

    public void addSample(RunningSample rs) {
        this.counter += rs.counter;
        this.errorCount += rs.errorCount;
        this.runningSum += rs.runningSum;
        if (this.firstTime > rs.firstTime) {
            this.firstTime = rs.firstTime;
        }
        if (this.lastTime < rs.lastTime) {
            this.lastTime = rs.lastTime;
        }
        if (this.max < rs.max) {
            this.max = rs.max;
        }
        if (this.min > rs.min) {
            this.min = rs.min;
        }
    }

    public long getMin() {
        long rval = 0L;
        if (this.min != Long.MAX_VALUE) {
            rval = this.min;
        }
        return rval;
    }

    public long getMax() {
        long rval = 0L;
        if (this.max != Long.MIN_VALUE) {
            rval = this.max;
        }
        return rval;
    }

    public long getAverage() {
        if (this.counter == 0L) {
            return 0L;
        }
        return this.runningSum / this.counter;
    }

    public long getNumSamples() {
        return this.counter;
    }

    public double getErrorPercentage() {
        double rval = 0.0;
        if (this.counter == 0L) {
            return rval;
        }
        rval = (double)this.errorCount / (double)this.counter;
        return rval;
    }

    public String getErrorPercentageString() {
        double myErrorPercentage = this.getErrorPercentage();
        return this.errorFormatter.format(myErrorPercentage);
    }

    public String toString() {
        StringBuilder mySB = new StringBuilder();
        mySB.append("Samples: " + this.getNumSamples() + "  ");
        mySB.append("Avg: " + this.getAverage() + "  ");
        mySB.append("Min: " + this.getMin() + "  ");
        mySB.append("Max: " + this.getMax() + "  ");
        mySB.append("Error Rate: " + this.getErrorPercentageString() + "  ");
        mySB.append("Sample Rate: " + this.getRateString());
        return mySB.toString();
    }

    public long getErrorCount() {
        return this.errorCount;
    }
}

