/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JTree;
import javax.swing.event.TreeModelEvent;
import javax.swing.event.TreeModelListener;
import org.apache.jmeter.gui.GuiPackage;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.UndoHistoryItem;
import org.apache.jmeter.gui.action.UndoCommand;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class UndoHistory
implements TreeModelListener,
Serializable {
    private static final long serialVersionUID = -974269825492906010L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private ArrayList<Integer> savedExpanded = new ArrayList();
    private int savedSelected = 0;
    private static final int INITIAL_POS = -1;
    private int position = -1;
    private static final int HISTORY_SIZE = JMeterUtils.getPropDefault("undo.history.size", 0);
    private List<UndoHistoryItem> history = new LimitedArrayList<UndoHistoryItem>(HISTORY_SIZE);
    private boolean working = false;
    private List<HistoryListener> listeners = new ArrayList<HistoryListener>();

    public void clear() {
        if (this.working) {
            return;
        }
        log.debug("Clearing undo history");
        this.history.clear();
        this.position = -1;
        this.notifyListeners();
    }

    public void add(JMeterTreeModel treeModel, String comment) {
        if (!this.isEnabled()) {
            log.debug("undo.history.size is set to 0, undo/redo feature is disabled");
            return;
        }
        if (this.working) {
            log.debug("Not adding history because of noop");
            return;
        }
        JMeterTreeNode root = (JMeterTreeNode)treeModel.getRoot();
        if (root.getChildCount() < 1) {
            log.debug("Not adding history because of no children");
            return;
        }
        String name = root.getName();
        log.debug("Adding history element " + name + ": " + comment);
        this.working = true;
        HashTree tree = treeModel.getCurrentSubTree((JMeterTreeNode)treeModel.getRoot());
        tree = (HashTree)tree.getTree(tree.getArray()[0]).clone();
        ++this.position;
        while (this.history.size() > this.position) {
            log.debug("Removing further record, position: " + this.position + ", size: " + this.history.size());
            this.history.remove(this.history.size() - 1);
        }
        HashTree copy = UndoCommand.convertAndCloneSubTree(tree);
        this.history.add(new UndoHistoryItem(copy, comment));
        log.debug("Added history element, position: " + this.position + ", size: " + this.history.size());
        this.working = false;
        this.notifyListeners();
    }

    public void moveInHistory(int offset, JMeterTreeModel acceptorModel) {
        log.debug("Moving history from position " + this.position + " with step " + offset + ", size is " + this.history.size());
        if (offset < 0 && !this.canUndo()) {
            log.warn("Can't undo, we're already on the last record");
            return;
        }
        if (offset > 0 && !this.canRedo()) {
            log.warn("Can't redo, we're already on the first record");
            return;
        }
        if (this.history.isEmpty()) {
            log.warn("Can't proceed, the history is empty");
            return;
        }
        this.position += offset;
        GuiPackage guiInstance = GuiPackage.getInstance();
        this.saveTreeState(guiInstance);
        this.loadHistoricalTree(acceptorModel, guiInstance);
        this.restoreTreeState(guiInstance);
        log.debug("Current position " + this.position + ", size is " + this.history.size());
        guiInstance.updateCurrentGui();
        guiInstance.getMainFrame().repaint();
        this.notifyListeners();
    }

    private void loadHistoricalTree(JMeterTreeModel acceptorModel, GuiPackage guiInstance) {
        HashTree newModel = this.history.get(this.position).getTree();
        acceptorModel.removeTreeModelListener(this);
        this.working = true;
        try {
            guiInstance.getTreeModel().clearTestPlan();
            guiInstance.addSubTree(newModel);
        }
        catch (Exception ex) {
            log.error("Failed to load from history", (Throwable)ex);
        }
        acceptorModel.addTreeModelListener(this);
        this.working = false;
    }

    public boolean canRedo() {
        return this.position < this.history.size() - 1;
    }

    public boolean canUndo() {
        return this.position > 0;
    }

    @Override
    public void treeNodesChanged(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes changed " + name);
        JMeterTreeModel sender = (JMeterTreeModel)tme.getSource();
        this.add(sender, "Node changed " + name);
    }

    @Override
    public void treeNodesInserted(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes inserted " + name);
        JMeterTreeModel sender = (JMeterTreeModel)tme.getSource();
        this.add(sender, "Add " + name);
    }

    @Override
    public void treeNodesRemoved(TreeModelEvent tme) {
        String name = ((JMeterTreeNode)tme.getTreePath().getLastPathComponent()).getName();
        log.debug("Nodes removed: " + name);
        this.add((JMeterTreeModel)tme.getSource(), "Remove " + name);
    }

    @Override
    public void treeStructureChanged(TreeModelEvent tme) {
        log.debug("Nodes struct changed");
        this.add((JMeterTreeModel)tme.getSource(), "Complex Change");
    }

    private void saveTreeState(GuiPackage guiPackage) {
        this.savedExpanded.clear();
        MainFrame mainframe = guiPackage.getMainFrame();
        if (mainframe != null) {
            JTree tree = mainframe.getTree();
            this.savedSelected = tree.getMinSelectionRow();
            for (int rowN = 0; rowN < tree.getRowCount(); ++rowN) {
                if (!tree.isExpanded(rowN)) continue;
                this.savedExpanded.add(rowN);
            }
        }
    }

    private void restoreTreeState(GuiPackage guiInstance) {
        JTree tree = guiInstance.getMainFrame().getTree();
        if (this.savedExpanded.size() > 0) {
            for (int rowN : this.savedExpanded) {
                tree.expandRow(rowN);
            }
        } else {
            tree.expandRow(0);
        }
        tree.setSelectionRow(this.savedSelected);
    }

    boolean isEnabled() {
        return HISTORY_SIZE > 0;
    }

    public void registerHistoryListener(HistoryListener listener) {
        this.listeners.add(listener);
    }

    private void notifyListeners() {
        for (HistoryListener listener : this.listeners) {
            listener.notifyChangeInHistory(this);
        }
    }

    private static class LimitedArrayList<T>
    extends ArrayList<T> {
        private static final long serialVersionUID = -6574380490156356507L;
        private int limit;

        public LimitedArrayList(int limit) {
            this.limit = limit;
        }

        @Override
        public boolean add(T item) {
            if (this.size() + 1 > this.limit) {
                this.remove(0);
            }
            return super.add(item);
        }
    }

    public static interface HistoryListener {
        public void notifyChangeInHistory(UndoHistory var1);
    }
}

