/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.iosp.fysat;

import ucar.nc2.iosp.fysat.AwxFileSecondHeader;
import ucar.nc2.iosp.fysat.util.EndianByteBuffer;

public final class AwxFileGridProductSecondHeader
extends AwxFileSecondHeader {
    String satelliteName;
    short gridFeature;
    short byteAmountofData;
    short dataBaseValue;
    short dataScale;
    short timePeriodCode;
    short startYear;
    short startMonth;
    short startDay;
    short startHour;
    short startMinute;
    short endYear;
    short endMonth;
    short endDay;
    short endHour;
    short endMinute;
    float leftTopLat;
    float leftTopLon;
    float rightBottomLat;
    float rightBottomLon;
    short gridSpacingUnit;
    short horizontalSpacing;
    short verticalSpacing;
    short amountofHorizontalSpacing;
    short amountofVerticalSpacing;
    short hasLand;
    short landCode;
    short hasCloud;
    short cloudCode;
    short hasWater;
    short waterCode;
    short hasIce;
    short iceCode;
    short hasQualityControl;
    short qualityControlCeiling;
    short qualityControlFloor;
    short reserved;
    public static short GRID_FEATURE_OCEAN_TEMPERATURE = 1;
    public static short GRID_FEATURE_SEA_ICE_DISTRIBUTION = (short)2;
    public static short GRID_FEATURE_SEA_ICE_DENSITY = (short)3;
    public static short GRID_FEATURE_OUTGOING_LONGWAVE_RADIATION = (short)4;
    public static short GRID_FEATURE_NORMALIZE_VEGETATIOIN_INDEX = (short)5;
    public static short GRID_FEATURE_RATIO_VEGETATIOIN_INDEX = (short)6;
    public static short GRID_FEATURE_SNOW_DISTRIBUTION = (short)7;
    public static short GRID_FEATURE_SOIL_HUMIDITY = (short)8;
    public static short GRID_FEATURE_SUNLIGHT_DURATION = (short)9;
    public static short GRID_FEATURE_CLOUD_TOP_HEIGHT = (short)10;
    public static short GRID_FEATURE_CLOUD_TOP_TEMPERATURE = (short)11;
    public static short GRID_FEATURE_LOW_CLOUD_AMOUNT = (short)12;
    public static short GRID_FEATURE_HIGH_CLOUD_AMOUNT = (short)13;
    public static short GRID_FEATURE_RAIN_INDEX_PER_HOUR = (short)14;
    public static short GRID_FEATURE_RAIN_INDEX_PER_6HOUR = (short)15;
    public static short GRID_FEATURE_RAIN_INDEX_PER_12HOUR = (short)16;
    public static short GRID_FEATURE_RAIN_INDEX_PER_24HOUR = (short)17;
    public static short GRID_SPACING_UNIT_POINT001DEGREE = 0;
    public static short GRID_SPACING_UNIT_KILOMETER = 1;
    public static short GRID_SPACING_UNIT_METER = (short)2;

    @Override
    public void fillHeader(EndianByteBuffer byteBuffer) {
        this.satelliteName = byteBuffer.getString(8).trim();
        this.gridFeature = byteBuffer.getShort();
        this.byteAmountofData = byteBuffer.getShort();
        this.dataBaseValue = byteBuffer.getShort();
        this.dataScale = byteBuffer.getShort();
        this.timePeriodCode = byteBuffer.getShort();
        this.startYear = byteBuffer.getShort();
        this.startMonth = byteBuffer.getShort();
        this.startDay = byteBuffer.getShort();
        this.startHour = byteBuffer.getShort();
        this.startMinute = byteBuffer.getShort();
        this.endYear = byteBuffer.getShort();
        this.endMonth = byteBuffer.getShort();
        this.endDay = byteBuffer.getShort();
        this.endHour = byteBuffer.getShort();
        this.endMinute = byteBuffer.getShort();
        this.leftTopLat = (float)byteBuffer.getShort() / 100.0f;
        this.leftTopLon = (float)byteBuffer.getShort() / 100.0f;
        this.rightBottomLat = (float)byteBuffer.getShort() / 100.0f;
        this.rightBottomLon = (float)byteBuffer.getShort() / 100.0f;
        this.gridSpacingUnit = byteBuffer.getShort();
        this.horizontalSpacing = byteBuffer.getShort();
        this.verticalSpacing = byteBuffer.getShort();
        this.amountofHorizontalSpacing = byteBuffer.getShort();
        this.amountofVerticalSpacing = byteBuffer.getShort();
        this.hasLand = byteBuffer.getShort();
        this.landCode = byteBuffer.getShort();
        this.hasCloud = byteBuffer.getShort();
        this.cloudCode = byteBuffer.getShort();
        this.hasWater = byteBuffer.getShort();
        this.waterCode = byteBuffer.getShort();
        this.hasIce = byteBuffer.getShort();
        this.iceCode = byteBuffer.getShort();
        this.hasQualityControl = byteBuffer.getShort();
        this.qualityControlCeiling = byteBuffer.getShort();
        this.qualityControlFloor = byteBuffer.getShort();
        this.reserved = byteBuffer.getShort();
    }

    public String getSpacingUnit() {
        switch (this.gridSpacingUnit) {
            case 0: {
                return "0.01degree";
            }
            case 1: {
                return "kilometer";
            }
            case 2: {
                return "meter";
            }
        }
        return "";
    }
}

