/*
 * Decompiled with CFR 0.152.
 */
package thredds.filesystem;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import net.jcip.annotations.ThreadSafe;
import thredds.filesystem.CacheDirectory;
import thredds.filesystem.CacheFile;
import thredds.filesystem.CacheManager;
import thredds.filesystem.MFileCached;
import thredds.inventory.MCollection;
import thredds.inventory.MController;
import thredds.inventory.MFile;

@ThreadSafe
public class ControllerCaching
implements MController {
    private CacheManager cacheManager;

    public static MController makeStandardController(String configFile, String cacheDir) throws IOException {
        CacheManager.makeStandardCacheManager(configFile, cacheDir);
        CacheManager cm = new CacheManager("directories");
        return new ControllerCaching(cm);
    }

    public static MController makeTestController(String cacheDir) {
        CacheManager.makeTestCacheManager(cacheDir);
        CacheManager cm = new CacheManager("directories");
        return new ControllerCaching(cm);
    }

    private ControllerCaching(CacheManager cacheManager) {
        this.cacheManager = cacheManager;
    }

    @Override
    public Iterator<MFile> getInventory(MCollection mc) {
        return this.getInventory(mc, true);
    }

    @Override
    public Iterator<MFile> getInventoryNoSubdirs(MCollection mc) {
        return this.getInventoryNoSubdirs(mc, true);
    }

    @Override
    public Iterator<MFile> getInventory(MCollection mc, boolean recheck) {
        CacheDirectory cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if ((cd = this.cacheManager.get(path, recheck)) == null) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIteratorWithSubdirs(cd, recheck));
    }

    @Override
    public Iterator<MFile> getInventoryNoSubdirs(MCollection mc, boolean recheck) {
        CacheDirectory cd;
        String path = mc.getDirectoryName();
        if (path.startsWith("file:")) {
            path = path.substring(5);
        }
        if ((cd = this.cacheManager.get(path, recheck)) == null) {
            return null;
        }
        if (!cd.isDirectory()) {
            return null;
        }
        return new FilteredIterator(mc, new MFileIterator(cd));
    }

    @Override
    public void close() {
        if (this.cacheManager != null) {
            this.cacheManager.close();
        }
        this.cacheManager = null;
    }

    private class Traversal {
        final CacheDirectory dir;
        final List<CacheFile> fileList;
        Iterator<CacheFile> subdirIterator;
        boolean leavesAreDone = false;

        Traversal(CacheDirectory dir) {
            this.dir = dir;
            this.fileList = new ArrayList<CacheFile>();
            ArrayList<CacheFile> subdirList = new ArrayList<CacheFile>();
            for (CacheFile f : dir.getChildren()) {
                if (f.isDirectory()) {
                    subdirList.add(f);
                    continue;
                }
                this.fileList.add(f);
            }
            if (subdirList.size() > 0) {
                this.subdirIterator = subdirList.iterator();
            }
        }
    }

    private class MFileIteratorWithSubdirs
    implements Iterator<MFile> {
        final boolean recheck;
        final Queue<Traversal> traverse = new LinkedList<Traversal>();
        Traversal currTraversal;
        Iterator<MFile> currIter;

        MFileIteratorWithSubdirs(CacheDirectory top, boolean recheck) {
            this.currTraversal = new Traversal(top);
            this.recheck = recheck;
        }

        @Override
        public boolean hasNext() {
            if (this.currIter == null) {
                this.currIter = this.getNextIterator();
                if (this.currIter == null) {
                    return false;
                }
            }
            if (!this.currIter.hasNext()) {
                this.currIter = this.getNextIterator();
                return this.hasNext();
            }
            return true;
        }

        @Override
        public MFile next() {
            return this.currIter.next();
        }

        private Iterator<MFile> getNextIterator() {
            if (!this.currTraversal.leavesAreDone) {
                this.currTraversal.leavesAreDone = true;
                return new MFileIterator(this.currTraversal.dir.getPath(), this.currTraversal.fileList);
            }
            if (this.currTraversal.subdirIterator != null && this.currTraversal.subdirIterator.hasNext()) {
                CacheFile nextDir = this.currTraversal.subdirIterator.next();
                CacheDirectory cd = ControllerCaching.this.cacheManager.get(this.currTraversal.dir.getPath() + "/" + nextDir.getShortName(), this.recheck);
                if (cd == null) {
                    return this.getNextIterator();
                }
                this.traverse.add(this.currTraversal);
                this.currTraversal = new Traversal(cd);
                return this.getNextIterator();
            }
            if (this.traverse.peek() == null) {
                return null;
            }
            this.currTraversal = this.traverse.remove();
            return this.getNextIterator();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class MFileIterator
    implements Iterator<MFile> {
        final String path;
        final List<CacheFile> files;
        int count = 0;

        MFileIterator(CacheDirectory cd) {
            this.path = cd.getPath();
            this.files = Arrays.asList(cd.getChildren());
        }

        MFileIterator(String path, List<CacheFile> files) {
            this.path = path;
            this.files = files;
        }

        @Override
        public boolean hasNext() {
            return this.count < this.files.size();
        }

        @Override
        public MFile next() {
            CacheFile cfile = this.files.get(this.count++);
            return new MFileCached(this.path, cfile);
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    private class FilteredIterator
    implements Iterator<MFile> {
        private final Iterator<MFile> orgIter;
        private final MCollection mc;
        private MFile next;

        FilteredIterator(MCollection mc, Iterator<MFile> iter) {
            this.orgIter = iter;
            this.mc = mc;
        }

        @Override
        public boolean hasNext() {
            this.next = this.nextFilteredFile();
            return this.next != null;
        }

        @Override
        public MFile next() {
            return this.next;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }

        private MFile nextFilteredFile() {
            if (this.orgIter == null) {
                return null;
            }
            if (!this.orgIter.hasNext()) {
                return null;
            }
            MFile pdata = this.orgIter.next();
            while (pdata.isDirectory() || !this.mc.accept(pdata)) {
                if (!this.orgIter.hasNext()) {
                    return null;
                }
                pdata = this.orgIter.next();
            }
            return pdata;
        }
    }
}

