/*
 * Decompiled with CFR 0.152.
 */
package org.jCharts.axisChart.axis.scale;

public abstract class ScaleCalculator {
    private double minValue;
    private double maxValue;
    private int roundingPowerOfTen;
    private int numberOfScaleItems;
    protected double increment;

    protected abstract void computeIncrement();

    public final void computeScaleValues() {
        this.computeIncrement();
    }

    public final void setMinValue(double d) {
        this.minValue = d;
    }

    public final double getMinValue() {
        return this.minValue;
    }

    public final void setMaxValue(double d) {
        this.maxValue = d;
    }

    public final double getMaxValue() {
        return this.maxValue;
    }

    public final double getIncrement() {
        return this.increment;
    }

    public int getNumberOfScaleItems() {
        return this.numberOfScaleItems;
    }

    public void setNumberOfScaleItems(int n) {
        this.numberOfScaleItems = n;
    }

    public final void setRoundingPowerOfTen(int n) {
        this.roundingPowerOfTen = n;
    }

    public final int getRoundingPowerOfTen() {
        return this.roundingPowerOfTen;
    }

    protected double round(double d, double d2) {
        if (this.roundingPowerOfTen > 0) {
            return (double)Math.round(d / d2) * d2;
        }
        if (this.roundingPowerOfTen < 0) {
            return (double)Math.round(d * d2) / d2;
        }
        return Math.round(d);
    }

    protected void roundTheIncrement(double d) {
        this.increment = this.round(this.increment, d);
        this.increment = this.roundingPowerOfTen > 0 ? (this.increment += d) : (this.increment += 1.0 / d);
    }

    public String toString() {
        StringBuffer stringBuffer = new StringBuffer(90);
        stringBuffer.append("ScaleCalculator-> min= ");
        stringBuffer.append(this.minValue);
        stringBuffer.append("  max= ");
        stringBuffer.append(this.maxValue);
        stringBuffer.append("  increment= ");
        stringBuffer.append(this.increment);
        return stringBuffer.toString();
    }
}

