/*
 * Decompiled with CFR 0.152.
 */
package javax.mail;

import java.io.BufferedReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintStream;
import java.net.InetAddress;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import javax.mail.Address;
import javax.mail.Authenticator;
import javax.mail.Folder;
import javax.mail.MessagingException;
import javax.mail.NoSuchProviderException;
import javax.mail.PasswordAuthentication;
import javax.mail.Provider;
import javax.mail.Store;
import javax.mail.Transport;
import javax.mail.URLName;
import javax.mail.internet.ParameterList;
import javax.mail.internet.ParseException;

public final class Session {
    private static final Map _addressMap = new HashMap();
    private static final Map _providers = new HashMap();
    private static Authenticator DEFAULT_AUTHENTICATOR;
    private static Session DEFAULT_SESSION;
    private static final Provider[] PROVIDER_ARRAY;
    private Authenticator _authenticator;
    private boolean _debug;
    private PrintStream _debugOut;
    private Map _passwordAuthentications = new HashMap();
    private Properties _properties = new Properties();

    private Session() {
    }

    public static synchronized Session getDefaultInstance(Properties properties) {
        if (DEFAULT_SESSION == null) {
            DEFAULT_SESSION = Session.getInstance(properties);
        }
        return DEFAULT_SESSION;
    }

    public static synchronized Session getDefaultInstance(Properties properties, Authenticator authenticator) {
        if (DEFAULT_AUTHENTICATOR == null || DEFAULT_AUTHENTICATOR == authenticator || DEFAULT_AUTHENTICATOR.getClass().getClassLoader() == authenticator.getClass().getClassLoader()) {
            if (DEFAULT_SESSION == null) {
                DEFAULT_SESSION = Session.getInstance(properties, authenticator);
                DEFAULT_AUTHENTICATOR = authenticator;
            }
            return DEFAULT_SESSION;
        }
        throw new SecurityException("Cannot access default instance with given authenticator");
    }

    public static Session getInstance(Properties properties) {
        return Session.getInstance(properties, null);
    }

    public static Session getInstance(Properties properties, Authenticator authenticator) {
        Session session = new Session();
        session._authenticator = authenticator;
        session._properties = new Properties(properties);
        session._debug = Boolean.getBoolean(properties.getProperty("mail.debug", "false"));
        return session;
    }

    private static void loadAddressMap() {
        try {
            String slash = System.getProperty("file.separator");
            String home = System.getProperty("java.home");
            Session.loadAddressMap(new FileInputStream(home + slash + "lib" + slash + "javamail.address.map"));
        }
        catch (RuntimeException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Session.loadAddressMap("/META-INF/javamail.address.map");
        }
        catch (RuntimeException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        try {
            Session.loadAddressMap("/META-INF/javamail.default.address.map");
        }
        catch (RuntimeException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private static void loadAddressMap(InputStream in) throws IOException {
        String line;
        if (in == null) {
            return;
        }
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            if (line.trim().equals("") || line.startsWith("#")) continue;
            int eq = line.indexOf("=");
            String type = line.substring(0, eq).trim();
            String transport = line.substring(eq + 1).trim();
            _addressMap.put(type, transport);
        }
        br.close();
    }

    private static void loadAddressMap(String file) throws IOException {
        Session.loadAddressMap(Session.class.getResourceAsStream(file));
    }

    private static void loadProviders() {
        try {
            String slash = System.getProperty("file.separator");
            String home = System.getProperty("java.home");
            Session.loadProviders(new FileInputStream(home + slash + "lib" + slash + "javamail.providers"));
        }
        catch (RuntimeException e) {
        }
        catch (IOException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            Session.loadProviders("/META-INF/javamail.providers");
        }
        catch (RuntimeException e) {
        }
        catch (IOException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        try {
            Session.loadProviders("/META-INF/javamail.default.providers");
        }
        catch (RuntimeException e) {
        }
        catch (IOException e) {
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
    }

    private static void loadProviders(InputStream in) throws IOException, ParseException {
        String line;
        BufferedReader br = new BufferedReader(new InputStreamReader(in));
        while ((line = br.readLine()) != null) {
            if (line.trim().equals("") || line.startsWith("#")) continue;
            ParameterList pl = new ParameterList(line);
            pl.get(line);
            String protocol = pl.get("protocol");
            String className = pl.get("class");
            String typeString = pl.get("type");
            Provider.Type type = Provider.Type.getType(typeString);
            String vendor = pl.get("vendor");
            String version = pl.get("version");
            Provider provider = new Provider(protocol, className, type, vendor, version);
            _providers.put(typeString, provider);
        }
        br.close();
    }

    private static void loadProviders(String file) throws ParseException, IOException {
        Session.loadProviders(Session.class.getResourceAsStream(file));
    }

    public boolean getDebug() {
        return this._debug;
    }

    public PrintStream getDebugOut() {
        return System.err;
    }

    public Folder getFolder(URLName name) throws MessagingException {
        return null;
    }

    public PasswordAuthentication getPasswordAuthentication(URLName name) {
        return (PasswordAuthentication)this._passwordAuthentications.get(name);
    }

    public Properties getProperties() {
        return this._properties;
    }

    public String getProperty(String property) {
        return this.getProperties().getProperty(property);
    }

    public Provider getProvider(String name) throws NoSuchProviderException {
        return (Provider)_providers.get(name);
    }

    public Provider[] getProviders() {
        return _providers.values().toArray(PROVIDER_ARRAY);
    }

    public Store getStore() throws NoSuchProviderException {
        return this.getStore(this._properties.getProperty("mail.store.protocol"));
    }

    public Store getStore(Provider provider) throws NoSuchProviderException {
        Store store;
        try {
            store = (Store)Class.forName(provider.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchProviderException(e.toString());
        }
        return store;
    }

    public Store getStore(String protocol) throws NoSuchProviderException {
        if (protocol == null) {
            throw new NoSuchProviderException("No protocol specified in mail.store.protocol property or none given");
        }
        Provider provider = (Provider)_providers.get(protocol);
        if (provider == null) {
            throw new NoSuchProviderException("Unknown protocol for " + protocol);
        }
        return this.getStore(provider);
    }

    public Store getStore(URLName url) throws NoSuchProviderException {
        return this.getStore(url.getProtocol());
    }

    public Transport getTransport() throws NoSuchProviderException {
        return this.getTransport(this._properties.getProperty("mail.transport.protocol"));
    }

    public Transport getTransport(Address address) throws NoSuchProviderException {
        String type = address.getType();
        return this.getTransport((String)_addressMap.get(type));
    }

    public Transport getTransport(Provider provider) throws NoSuchProviderException {
        Transport transport;
        try {
            transport = (Transport)Class.forName(provider.getClassName()).newInstance();
        }
        catch (Exception e) {
            throw new NoSuchProviderException(e.toString());
        }
        return transport;
    }

    public Transport getTransport(String protocol) throws NoSuchProviderException {
        Provider provider = null;
        return this.getTransport(provider);
    }

    public Transport getTransport(URLName name) throws NoSuchProviderException {
        return this.getTransport(name.getProtocol());
    }

    public PasswordAuthentication requestPasswordAuthentication(InetAddress host, int port, String protocol, String prompt, String defaultUserName) {
        throw new UnsupportedOperationException("Method not yet implemented");
    }

    public void setDebug(boolean debug) {
        this._debug = debug;
    }

    public void setDebugOut(PrintStream out) {
        this._debugOut = out;
    }

    public void setPasswordAuthentication(URLName name, PasswordAuthentication authenticator) {
        this._passwordAuthentications.put(name, authenticator);
    }

    public void setProvider(Provider provider) throws NoSuchProviderException {
        String protocol = provider.getProtocol();
        _providers.put(protocol, provider);
    }

    static {
        PROVIDER_ARRAY = new Provider[0];
        Session.loadProviders();
        Session.loadAddressMap();
    }
}

