/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.sampler;

import java.util.Hashtable;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.InitialDirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class LdapClient {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private DirContext dirContext = null;

    public void connect(String host, String port, String rootdn, String username, String password) throws NamingException {
        Hashtable<String, String> env = new Hashtable<String, String>();
        env.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        env.put("java.naming.provider.url", "ldap://" + host + ":" + port + "/" + rootdn);
        env.put("java.naming.referral", "throw");
        env.put("java.naming.security.credentials", password);
        env.put("java.naming.security.principal", username);
        this.dirContext = new InitialDirContext(env);
    }

    public void disconnect() {
        try {
            if (this.dirContext != null) {
                this.dirContext.close();
                this.dirContext = null;
            }
        }
        catch (NamingException e) {
            log.error("Ldap client - ", (Throwable)e);
        }
    }

    public boolean searchTest(String searchBase, String searchFilter) throws NamingException {
        SearchControls searchcontrols = new SearchControls(2, 1L, 0, null, false, false);
        NamingEnumeration<SearchResult> ne = this.dirContext.search(searchBase, searchFilter, searchcontrols);
        return ne.hasMore();
    }

    public void modifyTest(ModificationItem[] mods, String string) throws NamingException {
        this.dirContext.modifyAttributes(string, mods);
    }

    public void createTest(BasicAttributes basicattributes, String string) throws NamingException {
        this.dirContext.createSubcontext(string, (Attributes)basicattributes);
    }

    public void deleteTest(String string) throws NamingException {
        this.dirContext.destroySubcontext(string);
    }
}

