/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.web;

import java.lang.reflect.Array;
import java.util.Collections;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import org.jboss.seam.Component;
import org.jboss.seam.ScopeType;
import org.jboss.seam.annotations.Install;
import org.jboss.seam.annotations.Name;
import org.jboss.seam.annotations.Scope;
import org.jboss.seam.annotations.intercept.BypassInterceptors;
import org.jboss.seam.web.ServletContexts;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
@Name(value="org.jboss.seam.web.parameters")
@BypassInterceptors
@Scope(value=ScopeType.STATELESS)
@Install(precedence=0)
public class Parameters {
    protected Object convertRequestParameter(String requestParameter, Class type) {
        if (String.class.equals((Object)type)) {
            return requestParameter;
        }
        throw new IllegalArgumentException("No converters available");
    }

    public Map<String, String[]> getRequestParameters() {
        HttpServletRequest servletRequest;
        ServletContexts servletContexts = ServletContexts.getInstance();
        if (servletContexts != null && (servletRequest = servletContexts.getRequest()) != null) {
            return servletRequest.getParameterMap();
        }
        return Collections.EMPTY_MAP;
    }

    public Object convertMultiValueRequestParameter(Map<String, String[]> requestParameters, String name, Class<?> type) {
        String[] array = requestParameters.get(name);
        if (array == null || array.length == 0) {
            return null;
        }
        if (type.isArray()) {
            int length = Array.getLength(array);
            Class<?> elementType = type.getComponentType();
            Object newInstance = Array.newInstance(elementType, length);
            for (int i = 0; i < length; ++i) {
                Object element = this.convertRequestParameter((String)Array.get(array, i), elementType);
                Array.set(newInstance, i, element);
            }
            return newInstance;
        }
        return this.convertRequestParameter(array[0], type);
    }

    public static Parameters instance() {
        return (Parameters)Component.getInstance(Parameters.class, ScopeType.STATELESS);
    }
}

