/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.ldap.config.gui;

import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.BorderFactory;
import javax.swing.ButtonGroup;
import javax.swing.JCheckBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import org.apache.jmeter.config.ConfigTestElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.VerticalPanel;
import org.apache.jmeter.protocol.ldap.config.gui.LDAPArgumentsPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.StringProperty;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.gui.JLabeledChoice;

public class LdapExtConfigGui
extends AbstractConfigGui
implements ItemListener {
    private static final long serialVersionUID = 240L;
    private JTextField rootdn = new JTextField(20);
    private JTextField searchbase = new JTextField(20);
    private JTextField searchfilter = new JTextField(20);
    private JTextField delete = new JTextField(20);
    private JTextField add = new JTextField(20);
    private JTextField modify = new JTextField(20);
    private JTextField servername = new JTextField(20);
    private JTextField port = new JTextField(20);
    private final String[] SCOPE_STRINGS = new String[]{JMeterUtils.getResString((String)"ldap_search_baseobject"), JMeterUtils.getResString((String)"ldap_search_onelevel"), JMeterUtils.getResString((String)"ldap_search_subtree")};
    private static final String CARDS_DEFAULT = "";
    private static final String CARDS_ADD = "Add";
    private static final String CARDS_DELETE = "Delete";
    private static final String CARDS_BIND = "Bind";
    private static final String CARDS_RENAME = "Rename";
    private static final String CARDS_COMPARE = "Compare";
    private static final String CARDS_SEARCH = "Search";
    private static final String CARDS_MODIFY = "Modify";
    private JLabeledChoice scope = new JLabeledChoice(JMeterUtils.getResString((String)"scope"), this.SCOPE_STRINGS);
    private JTextField countlim = new JTextField(20);
    private JTextField timelim = new JTextField(20);
    private JTextField attribs = new JTextField(20);
    private JCheckBox retobj = new JCheckBox(JMeterUtils.getResString((String)"retobj"));
    private JCheckBox deref = new JCheckBox(JMeterUtils.getResString((String)"deref"));
    private JTextField userdn = new JTextField(20);
    private JTextField userpw = new JPasswordField(20);
    private JTextField comparedn = new JTextField(20);
    private JTextField comparefilt = new JTextField(20);
    private JTextField modddn = new JTextField(20);
    private JTextField newdn = new JTextField(20);
    private JTextField connto = new JTextField(20);
    private JCheckBox parseflag = new JCheckBox(JMeterUtils.getResString((String)"ldap_parse_results"));
    private JCheckBox secure = new JCheckBox(JMeterUtils.getResString((String)"ldap_secure"));
    private JRadioButton addTest = new JRadioButton(JMeterUtils.getResString((String)"addtest"));
    private JRadioButton modifyTest = new JRadioButton(JMeterUtils.getResString((String)"modtest"));
    private JRadioButton deleteTest = new JRadioButton(JMeterUtils.getResString((String)"deltest"));
    private JRadioButton searchTest = new JRadioButton(JMeterUtils.getResString((String)"searchtest"));
    private JRadioButton bind = new JRadioButton(JMeterUtils.getResString((String)"bind"));
    private JRadioButton rename = new JRadioButton(JMeterUtils.getResString((String)"rename"));
    private JRadioButton unbind = new JRadioButton(JMeterUtils.getResString((String)"unbind"));
    private JRadioButton sbind = new JRadioButton(JMeterUtils.getResString((String)"sbind"));
    private JRadioButton compare = new JRadioButton(JMeterUtils.getResString((String)"compare"));
    private ButtonGroup bGroup = new ButtonGroup();
    private boolean displayName = true;
    private ArgumentsPanel tableAddPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"addtest"));
    private LDAPArgumentsPanel tableModifyPanel = new LDAPArgumentsPanel(JMeterUtils.getResString((String)"modtest"));
    private JPanel cards;

    public LdapExtConfigGui() {
        this(true);
    }

    public LdapExtConfigGui(boolean displayName) {
        this.displayName = displayName;
        this.init();
    }

    public String getLabelResource() {
        return "ldapext_sample_title";
    }

    public void configure(TestElement element) {
        super.configure(element);
        this.servername.setText(element.getPropertyAsString("servername"));
        this.port.setText(element.getPropertyAsString("port"));
        this.rootdn.setText(element.getPropertyAsString("rootdn"));
        this.scope.setSelectedIndex(element.getPropertyAsInt("scope"));
        this.countlim.setText(element.getPropertyAsString("countlimit"));
        this.timelim.setText(element.getPropertyAsString("timelimit"));
        this.attribs.setText(element.getPropertyAsString("attributes"));
        this.retobj.setSelected(element.getPropertyAsBoolean("return_object"));
        this.deref.setSelected(element.getPropertyAsBoolean("deref_aliases"));
        this.connto.setText(element.getPropertyAsString("connection_timeout"));
        this.parseflag.setSelected(element.getPropertyAsBoolean("parseflag"));
        this.secure.setSelected(element.getPropertyAsBoolean("secure"));
        this.userpw.setText(element.getPropertyAsString("user_pw"));
        this.userdn.setText(element.getPropertyAsString("user_dn"));
        this.comparedn.setText(element.getPropertyAsString("comparedn"));
        this.comparefilt.setText(element.getPropertyAsString("comparefilt"));
        this.modddn.setText(element.getPropertyAsString("modddn"));
        this.newdn.setText(element.getPropertyAsString("newdn"));
        CardLayout cl = (CardLayout)this.cards.getLayout();
        String testType = element.getPropertyAsString("test");
        if (testType.equals("unbind")) {
            this.unbind.setSelected(true);
            cl.show(this.cards, CARDS_DEFAULT);
        } else if (testType.equals("bind")) {
            this.bind.setSelected(true);
            cl.show(this.cards, CARDS_BIND);
        } else if (testType.equals("sbind")) {
            this.sbind.setSelected(true);
            cl.show(this.cards, CARDS_BIND);
        } else if (testType.equals("compare")) {
            this.compare.setSelected(true);
            cl.show(this.cards, CARDS_COMPARE);
        } else if (testType.equals("add")) {
            this.addTest.setSelected(true);
            this.add.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableAddPanel.configure((TestElement)element.getProperty("arguments").getObjectValue());
            cl.show(this.cards, CARDS_ADD);
        } else if (testType.equals("modify")) {
            this.modifyTest.setSelected(true);
            this.modify.setText(element.getPropertyAsString("base_entry_dn"));
            this.tableModifyPanel.configure((TestElement)element.getProperty("ldaparguments").getObjectValue());
            cl.show(this.cards, CARDS_MODIFY);
        } else if (testType.equals("delete")) {
            this.deleteTest.setSelected(true);
            this.delete.setText(element.getPropertyAsString("delete"));
            cl.show(this.cards, CARDS_DELETE);
        } else if (testType.equals("rename")) {
            this.rename.setSelected(true);
            cl.show(this.cards, CARDS_RENAME);
        } else if (testType.equals("search")) {
            this.searchTest.setSelected(true);
            this.searchbase.setText(element.getPropertyAsString("search"));
            this.searchfilter.setText(element.getPropertyAsString("searchfilter"));
            cl.show(this.cards, CARDS_SEARCH);
        }
    }

    public TestElement createTestElement() {
        ConfigTestElement element = new ConfigTestElement();
        this.modifyTestElement((TestElement)element);
        return element;
    }

    public void modifyTestElement(TestElement element) {
        element.clear();
        this.configureTestElement(element);
        element.setProperty("servername", this.servername.getText());
        element.setProperty("port", this.port.getText());
        element.setProperty("rootdn", this.rootdn.getText());
        element.setProperty("scope", String.valueOf(this.scope.getSelectedIndex()));
        element.setProperty("countlimit", this.countlim.getText());
        element.setProperty("timelimit", this.timelim.getText());
        element.setProperty("attributes", this.attribs.getText());
        element.setProperty("return_object", Boolean.toString(this.retobj.isSelected()));
        element.setProperty("deref_aliases", Boolean.toString(this.deref.isSelected()));
        element.setProperty("connection_timeout", this.connto.getText());
        element.setProperty("parseflag", Boolean.toString(this.parseflag.isSelected()));
        element.setProperty("secure", Boolean.toString(this.secure.isSelected()));
        element.setProperty("user_dn", this.userdn.getText());
        element.setProperty("user_pw", this.userpw.getText());
        element.setProperty("comparedn", this.comparedn.getText());
        element.setProperty("comparefilt", this.comparefilt.getText());
        element.setProperty("modddn", this.modddn.getText());
        element.setProperty("newdn", this.newdn.getText());
        if (this.addTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "add"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.add.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("arguments", this.tableAddPanel.createTestElement()));
        }
        if (this.modifyTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "modify"));
            element.setProperty((JMeterProperty)new StringProperty("base_entry_dn", this.modify.getText()));
            element.setProperty((JMeterProperty)new TestElementProperty("ldaparguments", this.tableModifyPanel.createTestElement()));
        }
        if (this.deleteTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "delete"));
            element.setProperty((JMeterProperty)new StringProperty("delete", this.delete.getText()));
        }
        if (this.searchTest.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "search"));
            element.setProperty((JMeterProperty)new StringProperty("search", this.searchbase.getText()));
            element.setProperty((JMeterProperty)new StringProperty("searchfilter", this.searchfilter.getText()));
        }
        if (this.bind.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "bind"));
        }
        if (this.sbind.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "sbind"));
        }
        if (this.compare.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "compare"));
        }
        if (this.rename.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "rename"));
        }
        if (this.unbind.isSelected()) {
            element.setProperty((JMeterProperty)new StringProperty("test", "unbind"));
        }
    }

    public void clearGui() {
        super.clearGui();
        this.rootdn.setText(CARDS_DEFAULT);
        this.searchbase.setText(CARDS_DEFAULT);
        this.searchfilter.setText(CARDS_DEFAULT);
        this.delete.setText(CARDS_DEFAULT);
        this.add.setText(CARDS_DEFAULT);
        this.modify.setText(CARDS_DEFAULT);
        this.servername.setText(CARDS_DEFAULT);
        this.port.setText(CARDS_DEFAULT);
        this.add.setText(CARDS_DEFAULT);
        this.scope.setSelectedIndex(this.SCOPE_STRINGS.length - 1);
        this.countlim.setText(CARDS_DEFAULT);
        this.timelim.setText(CARDS_DEFAULT);
        this.attribs.setText(CARDS_DEFAULT);
        this.userdn.setText(CARDS_DEFAULT);
        this.userpw.setText(CARDS_DEFAULT);
        this.comparedn.setText(CARDS_DEFAULT);
        this.comparefilt.setText(CARDS_DEFAULT);
        this.modddn.setText(CARDS_DEFAULT);
        this.newdn.setText(CARDS_DEFAULT);
        this.connto.setText(CARDS_DEFAULT);
        this.retobj.setSelected(false);
        this.deref.setSelected(false);
        this.parseflag.setSelected(false);
        this.secure.setSelected(false);
        this.addTest.setSelected(false);
        this.modifyTest.setSelected(false);
        this.deleteTest.setSelected(false);
        this.searchTest.setSelected(false);
        this.bind.setSelected(false);
        this.rename.setSelected(false);
        this.unbind.setSelected(false);
        this.sbind.setSelected(false);
        this.compare.setSelected(false);
        this.tableAddPanel.clear();
        this.tableModifyPanel.clear();
    }

    @Override
    public void itemStateChanged(ItemEvent ie) {
        CardLayout cl = (CardLayout)this.cards.getLayout();
        if (this.addTest.isSelected()) {
            cl.show(this.cards, CARDS_ADD);
        } else if (this.deleteTest.isSelected()) {
            cl.show(this.cards, CARDS_DELETE);
        } else if (this.bind.isSelected()) {
            cl.show(this.cards, CARDS_BIND);
        } else if (this.sbind.isSelected()) {
            cl.show(this.cards, CARDS_BIND);
        } else if (this.rename.isSelected()) {
            cl.show(this.cards, CARDS_RENAME);
        } else if (this.compare.isSelected()) {
            cl.show(this.cards, CARDS_COMPARE);
        } else if (this.searchTest.isSelected()) {
            cl.show(this.cards, CARDS_SEARCH);
        } else if (this.modifyTest.isSelected()) {
            cl.show(this.cards, CARDS_MODIFY);
        } else {
            cl.show(this.cards, CARDS_DEFAULT);
        }
    }

    private JPanel createServernamePanel() {
        JPanel serverPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"servername"));
        label.setLabelFor(this.servername);
        serverPanel.add((Component)label, "West");
        serverPanel.add((Component)this.servername, "Center");
        return serverPanel;
    }

    private JPanel createPortPanel() {
        JPanel portPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.port);
        portPanel.add((Component)label, "West");
        portPanel.add((Component)this.port, "Center");
        return portPanel;
    }

    private JPanel createRootdnPanel() {
        JPanel rootdnPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"ddn"));
        label.setLabelFor(this.rootdn);
        rootdnPanel.add((Component)label, "West");
        rootdnPanel.add((Component)this.rootdn, "Center");
        return rootdnPanel;
    }

    private JPanel createBindPanel() {
        VerticalPanel bindPanel = new VerticalPanel();
        bindPanel.add((Component)this.createServernamePanel());
        bindPanel.add((Component)this.createPortPanel());
        bindPanel.add((Component)this.createRootdnPanel());
        JPanel BPanel = new JPanel(new BorderLayout(5, 0));
        JLabel Blabel0 = new JLabel(JMeterUtils.getResString((String)"userdn"));
        Blabel0.setLabelFor(this.userdn);
        BPanel.add((Component)Blabel0, "West");
        BPanel.add((Component)this.userdn, "Center");
        bindPanel.add((Component)BPanel);
        JPanel B1Panel = new JPanel(new BorderLayout(5, 0));
        JLabel Blabel1 = new JLabel(JMeterUtils.getResString((String)"userpw"));
        Blabel1.setLabelFor(this.userpw);
        B1Panel.add((Component)Blabel1, "West");
        B1Panel.add((Component)this.userpw, "Center");
        bindPanel.add((Component)B1Panel);
        JPanel B2Panel = new JPanel(new BorderLayout(5, 0));
        JLabel Blabel2 = new JLabel(JMeterUtils.getResString((String)"ldap_connto"));
        Blabel2.setLabelFor(this.connto);
        B2Panel.add((Component)Blabel2, "West");
        B2Panel.add((Component)this.connto, "Center");
        bindPanel.add((Component)B2Panel);
        bindPanel.add((Component)this.secure);
        return bindPanel;
    }

    private JPanel createComparePanel() {
        VerticalPanel cbindPanel = new VerticalPanel();
        JPanel cBPanel = new JPanel(new BorderLayout(5, 0));
        JLabel cBlabel0 = new JLabel(JMeterUtils.getResString((String)"entrydn"));
        cBlabel0.setLabelFor(this.comparedn);
        cBPanel.add((Component)cBlabel0, "West");
        cBPanel.add((Component)this.comparedn, "Center");
        cbindPanel.add((Component)cBPanel);
        JPanel cBPanel1 = new JPanel(new BorderLayout(5, 0));
        JLabel cBlabel1 = new JLabel(JMeterUtils.getResString((String)"comparefilt"));
        cBlabel1.setLabelFor(this.comparefilt);
        cBPanel1.add((Component)cBlabel1, "West");
        cBPanel1.add((Component)this.comparefilt, "Center");
        cbindPanel.add((Component)cBPanel1);
        return cbindPanel;
    }

    private JPanel createSCPanel() {
        VerticalPanel SCPanel = new VerticalPanel();
        SCPanel.add((Component)this.scope);
        JPanel SC1Panel = new JPanel(new BorderLayout(5, 0));
        JLabel label1 = new JLabel(JMeterUtils.getResString((String)"countlim"));
        label1.setLabelFor(this.countlim);
        SC1Panel.add((Component)label1, "West");
        SC1Panel.add((Component)this.countlim, "Center");
        SCPanel.add((Component)SC1Panel);
        JPanel SC2Panel = new JPanel(new BorderLayout(5, 0));
        JLabel label2 = new JLabel(JMeterUtils.getResString((String)"timelim"));
        label2.setLabelFor(this.timelim);
        SC2Panel.add((Component)label2, "West");
        SC2Panel.add((Component)this.timelim, "Center");
        SCPanel.add((Component)SC2Panel);
        JPanel SC3Panel = new JPanel(new BorderLayout(5, 0));
        JLabel label3 = new JLabel(JMeterUtils.getResString((String)"attrs"));
        label3.setLabelFor(this.attribs);
        SC3Panel.add((Component)label3, "West");
        SC3Panel.add((Component)this.attribs, "Center");
        SCPanel.add((Component)SC3Panel);
        SCPanel.add((Component)this.retobj);
        SCPanel.add((Component)this.deref);
        SCPanel.add((Component)this.parseflag);
        return SCPanel;
    }

    private JPanel createSearchPanel() {
        VerticalPanel searchPanel = new VerticalPanel();
        JPanel searchBPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"searchbase"));
        label.setLabelFor(this.searchbase);
        searchBPanel.add((Component)label, "West");
        searchBPanel.add((Component)this.searchbase, "Center");
        JPanel searchFPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label20 = new JLabel(JMeterUtils.getResString((String)"searchfilter"));
        label20.setLabelFor(this.searchfilter);
        searchFPanel.add((Component)label20, "West");
        searchFPanel.add((Component)this.searchfilter, "Center");
        searchPanel.add((Component)searchBPanel);
        searchPanel.add((Component)searchFPanel);
        searchPanel.add((Component)this.createSCPanel());
        return searchPanel;
    }

    private JPanel createModdnPanel() {
        VerticalPanel modPanel = new VerticalPanel();
        JPanel renamePanel = new JPanel(new BorderLayout(5, 0));
        JLabel labelmod = new JLabel(JMeterUtils.getResString((String)"modddn"));
        labelmod.setLabelFor(this.modddn);
        renamePanel.add((Component)labelmod, "West");
        renamePanel.add((Component)this.modddn, "Center");
        JPanel rename2Panel = new JPanel(new BorderLayout(5, 0));
        JLabel labelmod2 = new JLabel(JMeterUtils.getResString((String)"newdn"));
        labelmod2.setLabelFor(this.newdn);
        rename2Panel.add((Component)labelmod2, "West");
        rename2Panel.add((Component)this.newdn, "Center");
        modPanel.add((Component)renamePanel);
        modPanel.add((Component)rename2Panel);
        return modPanel;
    }

    private JPanel createDeletePanel() {
        VerticalPanel panel = new VerticalPanel();
        JPanel deletePanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"delete"));
        label.setLabelFor(this.delete);
        deletePanel.add((Component)label, "West");
        deletePanel.add((Component)this.delete, "Center");
        panel.add((Component)deletePanel);
        return panel;
    }

    private JPanel createAddPanel() {
        JPanel addPanel = new JPanel(new BorderLayout(5, 0));
        JPanel addInnerPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"entrydn"));
        label.setLabelFor(this.add);
        addInnerPanel.add((Component)label, "West");
        addInnerPanel.add((Component)this.add, "Center");
        addPanel.add((Component)addInnerPanel, "North");
        addPanel.add((Component)this.tableAddPanel, "Center");
        return addPanel;
    }

    private JPanel createModifyPanel() {
        JPanel modifyPanel = new JPanel(new BorderLayout(5, 0));
        JPanel modifyInnerPanel = new JPanel(new BorderLayout(5, 0));
        JLabel label = new JLabel(JMeterUtils.getResString((String)"entrydn"));
        label.setLabelFor(this.modify);
        modifyInnerPanel.add((Component)label, "West");
        modifyInnerPanel.add((Component)this.modify, "Center");
        modifyPanel.add((Component)modifyInnerPanel, "North");
        modifyPanel.add((Component)((Object)this.tableModifyPanel), "Center");
        return modifyPanel;
    }

    private JPanel testPanel() {
        this.cards = new JPanel(new CardLayout());
        this.cards.add((Component)new JPanel(), CARDS_DEFAULT);
        this.cards.add((Component)this.createAddPanel(), CARDS_ADD);
        this.cards.add((Component)this.createModifyPanel(), CARDS_MODIFY);
        this.cards.add((Component)this.createModdnPanel(), CARDS_RENAME);
        this.cards.add((Component)this.createDeletePanel(), CARDS_DELETE);
        this.cards.add((Component)this.createSearchPanel(), CARDS_SEARCH);
        this.cards.add((Component)this.createBindPanel(), CARDS_BIND);
        this.cards.add((Component)this.createComparePanel(), CARDS_COMPARE);
        return this.cards;
    }

    private JPanel createTestPanel() {
        JPanel testPanel = new JPanel(new BorderLayout());
        testPanel.setBorder(BorderFactory.createTitledBorder(JMeterUtils.getResString((String)"test_configuration")));
        testPanel.add(new JLabel(JMeterUtils.getResString((String)"testt")));
        JPanel rowPanel = new JPanel();
        JPanel row2Panel = new JPanel();
        rowPanel.add(this.bind);
        this.bGroup.add(this.bind);
        rowPanel.add(this.unbind);
        this.bGroup.add(this.unbind);
        rowPanel.add(this.sbind);
        this.bGroup.add(this.sbind);
        rowPanel.add(this.rename);
        this.bGroup.add(this.rename);
        row2Panel.add(this.addTest);
        this.bGroup.add(this.addTest);
        row2Panel.add(this.deleteTest);
        this.bGroup.add(this.deleteTest);
        row2Panel.add(this.searchTest);
        this.bGroup.add(this.searchTest);
        row2Panel.add(this.compare);
        this.bGroup.add(this.compare);
        row2Panel.add(this.modifyTest);
        this.bGroup.add(this.modifyTest);
        testPanel.add((Component)rowPanel, "North");
        testPanel.add((Component)row2Panel, "South");
        return testPanel;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        if (this.displayName) {
            this.setBorder(this.makeBorder());
            this.add(this.makeTitlePanel(), "North");
        }
        VerticalPanel mainPanel = new VerticalPanel();
        mainPanel.add((Component)this.createTestPanel());
        mainPanel.add((Component)this.testPanel());
        this.add((Component)mainPanel, "Center");
        this.bind.addItemListener(this);
        this.sbind.addItemListener(this);
        this.unbind.addItemListener(this);
        this.compare.addItemListener(this);
        this.addTest.addItemListener(this);
        this.modifyTest.addItemListener(this);
        this.rename.addItemListener(this);
        this.deleteTest.addItemListener(this);
        this.searchTest.addItemListener(this);
    }
}

