/*
 * Decompiled with CFR 0.152.
 */
package com.uwyn.jhighlight.renderer;

import com.uwyn.jhighlight.JHighlightVersion;
import com.uwyn.jhighlight.highlighter.ExplicitStateHighlighter;
import com.uwyn.jhighlight.renderer.Renderer;
import com.uwyn.jhighlight.tools.ExceptionUtils;
import com.uwyn.jhighlight.tools.StringUtils;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StringBufferInputStream;
import java.io.StringReader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.logging.Logger;

public abstract class XhtmlRenderer
implements Renderer {
    public void highlight(String name, InputStream in, OutputStream out, String encoding, boolean fragment) throws IOException {
        String line;
        OutputStreamWriter osw;
        InputStreamReader isr;
        ExplicitStateHighlighter highlighter = this.getHighlighter();
        if (null == encoding) {
            isr = new InputStreamReader(in);
            osw = new OutputStreamWriter(out);
        } else {
            isr = new InputStreamReader(in, encoding);
            osw = new OutputStreamWriter(out, encoding);
        }
        BufferedReader r = new BufferedReader(isr);
        BufferedWriter w = new BufferedWriter(osw);
        if (fragment) {
            w.write(this.getXhtmlHeaderFragment(name));
        } else {
            w.write(this.getXhtmlHeader(name));
        }
        byte previous_style = 0;
        boolean newline = false;
        while ((line = r.readLine()) != null) {
            int length;
            line = line + "\n";
            line = StringUtils.convertTabsToSpaces(line, 4);
            StringReader lineReader = new StringReader(line);
            highlighter.setReader(lineReader);
            for (int index = 0; index < line.length(); index += length) {
                String css_class;
                byte style = highlighter.getNextToken();
                length = highlighter.getTokenLength();
                String token = line.substring(index, index + length);
                if ((style != previous_style || newline) && (css_class = this.getCssClass(style)) != null) {
                    if (previous_style != 0 && !newline) {
                        w.write("</span>");
                    }
                    w.write("<span class=\"" + css_class + "\">");
                    previous_style = style;
                }
                newline = false;
                w.write(StringUtils.replace(StringUtils.encodeHtml(StringUtils.replace(token, "\n", "")), " ", "&nbsp;"));
            }
            w.write("</span><br />\n");
            newline = true;
        }
        if (!fragment) {
            w.write(this.getXhtmlFooter());
        }
        w.flush();
        w.close();
    }

    public String highlight(String name, String in, String encoding, boolean fragment) throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        this.highlight(name, new StringBufferInputStream(in), out, encoding, fragment);
        return out.toString(encoding);
    }

    protected abstract Map getDefaultCssStyles();

    protected abstract String getCssClass(int var1);

    protected abstract ExplicitStateHighlighter getHighlighter();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String getCssClassDefinitions() {
        StringBuffer css = new StringBuffer();
        Properties properties = new Properties();
        URL jhighlighter_props = this.getClass().getClassLoader().getResource("jhighlight.properties");
        if (jhighlighter_props != null) {
            try {
                URLConnection connection = jhighlighter_props.openConnection();
                connection.setUseCaches(false);
                InputStream is = connection.getInputStream();
                try {
                    properties.load(is);
                }
                finally {
                    is.close();
                }
            }
            catch (IOException e) {
                Logger.getLogger("com.uwyn.jhighlight").warning("Error while reading the '" + jhighlighter_props.toExternalForm() + "' resource, using default CSS styles.\n" + ExceptionUtils.getExceptionStackTrace(e));
            }
        }
        Iterator it = this.getDefaultCssStyles().entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = (String)entry.getKey();
            css.append(key);
            css.append(" {\n");
            if (properties.containsKey(key)) {
                css.append(properties.get(key));
            } else {
                css.append(entry.getValue());
            }
            css.append("\n}\n");
        }
        return css.toString();
    }

    protected String getXhtmlHeader(String name) {
        if (null == name) {
            name = "";
        }
        return "<!DOCTYPE html PUBLIC \"-//W3C//DTD XHTML 1.0 Transitional//EN\"\n                      \"http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd\">\n<html xmlns=\"http://www.w3.org/1999/xhtml\" xml:lang=\"en\" lang=\"en\">\n<head>\n    <meta http-equiv=\"content-type\" content=\"text/html; charset=ISO-8859-1\" />\n    <meta name=\"generator\" content=\"JHighlight v" + JHighlightVersion.getVersion() + " (http://jhighlight.dev.java.net)\" />\n" + "    <title>" + StringUtils.encodeHtml(name) + "</title>\n" + "    <link rel=\"Help\" href=\"http://jhighlight.dev.java.net\" />\n" + "    <style type=\"text/css\">\n" + this.getCssClassDefinitions() + "    </style>\n" + "</head>\n" + "<body>\n" + "<h1>" + StringUtils.encodeHtml(name) + "</h1>" + "<code>";
    }

    protected String getXhtmlHeaderFragment(String name) {
        if (null == name) {
            name = "";
        }
        return "<!-- " + name + " : generated by JHighlight v" + JHighlightVersion.getVersion() + " (http://jhighlight.dev.java.net) -->\n";
    }

    protected String getXhtmlFooter() {
        return "</code>\n</body>\n</html>\n";
    }
}

