/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.seam.deployment;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.List;
import java.util.Properties;
import org.jboss.seam.util.EnumerationEnumeration;
import org.jboss.seam.util.Strings;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SeamDeploymentProperties {
    private ClassLoader classLoader;
    private Enumeration<URL> urlEnum;
    public static final String RESOURCE_BUNDLE = "META-INF/seam-deployment.properties";
    private static final String[] RESOURCE_BUNDLES = new String[]{"META-INF/seam-deployment.properties", "META-INF/seam-scanner.properties"};

    public SeamDeploymentProperties(ClassLoader classLoader) {
        this.classLoader = classLoader;
    }

    public List<String> getPropertyValues(String key) {
        ArrayList<String> values = new ArrayList<String>();
        this.addPropertiesFromSystem(key, values);
        this.addPropertiesFromResourceBundle(key, values);
        return values;
    }

    private void addPropertiesFromSystem(String key, List<String> values) {
        this.addProperty(key, System.getProperty(key), values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void addPropertiesFromResourceBundle(String key, List<String> values) {
        try {
            while (this.getResources().hasMoreElements()) {
                URL url = this.getResources().nextElement();
                Properties properties = new Properties();
                InputStream propertyStream = url.openStream();
                try {
                    properties.load(propertyStream);
                    this.addProperty(key, properties.getProperty(key), values);
                }
                finally {
                    if (propertyStream == null) continue;
                    propertyStream.close();
                }
            }
            return;
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private void addProperty(String key, String value, List<String> values) {
        if (value != null) {
            String[] properties;
            for (String property : properties = Strings.split(value, ":")) {
                values.add(property);
            }
        }
    }

    private Enumeration<URL> getResources() throws IOException {
        if (this.urlEnum == null) {
            Enumeration[] enumerations = new Enumeration[RESOURCE_BUNDLES.length];
            for (int i = 0; i < RESOURCE_BUNDLES.length; ++i) {
                enumerations[i] = this.classLoader.getResources(RESOURCE_BUNDLES[i]);
            }
            this.urlEnum = new EnumerationEnumeration<URL>(enumerations);
        }
        return this.urlEnum;
    }
}

