/*
 * Decompiled with CFR 0.152.
 */
package liquibase.database.core;

import java.math.BigInteger;
import java.sql.Timestamp;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.Vector;
import liquibase.change.ColumnConfig;
import liquibase.change.core.CreateTableChange;
import liquibase.database.AbstractDatabase;
import liquibase.database.Database;
import liquibase.database.DatabaseConnection;
import liquibase.database.structure.Column;
import liquibase.database.structure.Index;
import liquibase.database.structure.Table;
import liquibase.exception.DatabaseException;
import liquibase.exception.UnsupportedChangeException;
import liquibase.snapshot.DatabaseSnapshot;
import liquibase.snapshot.DatabaseSnapshotGeneratorFactory;
import liquibase.statement.SqlStatement;
import liquibase.statement.core.CopyRowsStatement;
import liquibase.statement.core.CreateIndexStatement;
import liquibase.statement.core.DropTableStatement;
import liquibase.statement.core.ReindexStatement;
import liquibase.statement.core.RenameTableStatement;
import liquibase.util.ISODateFormat;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SQLiteDatabase
extends AbstractDatabase {
    private Set<String> systemTables = new HashSet<String>();
    public static final String PRODUCT_NAME = "SQLite";

    public SQLiteDatabase() {
        this.systemTables.add("sqlite_sequence");
    }

    @Override
    public String getCurrentDateTimeFunction() {
        if (this.currentDateTimeFunction != null) {
            return this.currentDateTimeFunction;
        }
        return "CURRENT_TIMESTAMP";
    }

    @Override
    public String getDefaultDriver(String url) {
        if (url.startsWith("jdbc:sqlite:")) {
            return "SQLite.JDBCDriver";
        }
        return null;
    }

    @Override
    public int getPriority() {
        return 1;
    }

    @Override
    public String getTypeName() {
        return "sqlite";
    }

    @Override
    public boolean isCorrectDatabaseImplementation(DatabaseConnection conn) throws DatabaseException {
        return PRODUCT_NAME.equalsIgnoreCase(conn.getDatabaseProductName());
    }

    @Override
    public boolean supportsInitiallyDeferrableColumns() {
        return false;
    }

    @Override
    public boolean supportsTablespaces() {
        return false;
    }

    @Override
    public String getViewDefinition(String schemaName, String viewName) throws DatabaseException {
        return null;
    }

    @Override
    public boolean supportsSequences() {
        return false;
    }

    @Override
    public boolean supportsSchemas() {
        return false;
    }

    public String getTrigger(String table, String column) {
        return "CREATE TRIGGER insert_" + table + "_timeEnter AFTER  INSERT ON " + table + " BEGIN" + " UPDATE " + table + " SET " + column + " = DATETIME('NOW')" + " WHERE rowid = new.rowid END ";
    }

    @Override
    public String getAutoIncrementClause() {
        return "AUTOINCREMENT";
    }

    @Override
    protected boolean generateAutoIncrementStartWith(BigInteger startWith) {
        return false;
    }

    @Override
    protected boolean generateAutoIncrementBy(BigInteger incrementBy) {
        return false;
    }

    public static List<SqlStatement> getAlterTableStatements(AlterTableVisitor alterTableVisitor, Database database, String schemaName, String tableName) throws UnsupportedChangeException, DatabaseException {
        ArrayList<SqlStatement> statements = new ArrayList<SqlStatement>();
        DatabaseSnapshot snapshot = DatabaseSnapshotGeneratorFactory.getInstance().createSnapshot(database, null, null);
        Table table = snapshot.getTable(tableName);
        Vector<ColumnConfig> createColumns = new Vector<ColumnConfig>();
        Vector<ColumnConfig> copyColumns = new Vector<ColumnConfig>();
        if (table != null) {
            for (Column column : table.getColumns()) {
                ColumnConfig copy_column;
                ColumnConfig new_column = new ColumnConfig(column);
                if (alterTableVisitor.createThisColumn(new_column)) {
                    createColumns.add(new_column);
                }
                if (!alterTableVisitor.copyThisColumn(copy_column = new ColumnConfig(column))) continue;
                copyColumns.add(copy_column);
            }
        }
        for (ColumnConfig column : alterTableVisitor.getColumnsToAdd()) {
            ColumnConfig copy_column;
            ColumnConfig new_column = new ColumnConfig(column);
            if (alterTableVisitor.createThisColumn(new_column)) {
                createColumns.add(new_column);
            }
            if (!alterTableVisitor.copyThisColumn(copy_column = new ColumnConfig(column))) continue;
            copyColumns.add(copy_column);
        }
        Vector<Index> newIndices = new Vector<Index>();
        for (Index index : snapshot.getIndexes()) {
            if (!index.getTable().getName().equalsIgnoreCase(tableName) || !alterTableVisitor.createThisIndex(index)) continue;
            newIndices.add(index);
        }
        String temp_table_name = tableName + "_temporary";
        statements.add(new RenameTableStatement(schemaName, tableName, temp_table_name));
        CreateTableChange ct_change_tmp = new CreateTableChange();
        ct_change_tmp.setSchemaName(schemaName);
        ct_change_tmp.setTableName(tableName);
        for (ColumnConfig column : createColumns) {
            ct_change_tmp.addColumn(column);
        }
        statements.addAll(Arrays.asList(ct_change_tmp.generateStatements(database)));
        statements.add(new CopyRowsStatement(temp_table_name, tableName, copyColumns));
        statements.add(new DropTableStatement(schemaName, temp_table_name, false));
        statements.add(new ReindexStatement(schemaName, tableName));
        for (Index index_config : newIndices) {
            statements.add(new CreateIndexStatement(index_config.getName(), schemaName, tableName, index_config.isUnique(), index_config.getAssociatedWithAsString(), index_config.getColumns().toArray(new String[index_config.getColumns().size()])));
        }
        return statements;
    }

    @Override
    protected Set<String> getSystemTablesAndViews() {
        return this.systemTables;
    }

    @Override
    public String getDateTimeLiteral(Timestamp date) {
        return this.getDateLiteral(new ISODateFormat().format(date).replaceFirst("^'", "").replaceFirst("'$", ""));
    }

    public static interface AlterTableVisitor {
        public ColumnConfig[] getColumnsToAdd();

        public boolean copyThisColumn(ColumnConfig var1);

        public boolean createThisColumn(ColumnConfig var1);

        public boolean createThisIndex(Index var1);
    }
}

