/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Arrays;
import java.util.Collection;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.Border;
import org.apache.jmeter.control.gui.LogicControllerGui;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.protocol.http.control.HttpMirrorControl;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class HttpMirrorControlGui
extends LogicControllerGui
implements JMeterGUIComponent,
ActionListener,
UnsharedComponent {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private JTextField portField;
    private JTextField maxPoolSizeField;
    private JTextField maxQueueSizeField;
    private JButton stop;
    private JButton start;
    private static final String ACTION_STOP = "stop";
    private static final String ACTION_START = "start";
    private HttpMirrorControl mirrorController;

    public HttpMirrorControlGui() {
        log.debug("Creating HttpMirrorControlGui");
        this.init();
    }

    public TestElement createTestElement() {
        this.mirrorController = new HttpMirrorControl();
        log.debug("creating/configuring model = " + (Object)((Object)this.mirrorController));
        this.modifyTestElement((TestElement)this.mirrorController);
        return this.mirrorController;
    }

    public void modifyTestElement(TestElement el) {
        this.configureTestElement(el);
        if (el instanceof HttpMirrorControl) {
            this.mirrorController = (HttpMirrorControl)el;
            this.mirrorController.setPort(this.portField.getText());
            this.mirrorController.setMaxPoolSize(this.maxPoolSizeField.getText());
            this.mirrorController.setMaxQueueSize(this.maxQueueSizeField.getText());
        }
    }

    public String getLabelResource() {
        return "httpmirror_title";
    }

    public Collection<String> getMenuCategories() {
        return Arrays.asList("menu_non_test_elements");
    }

    public void configure(TestElement element) {
        log.debug("Configuring gui with " + element);
        super.configure(element);
        this.mirrorController = (HttpMirrorControl)element;
        this.portField.setText(this.mirrorController.getPortString());
        this.maxPoolSizeField.setText(this.mirrorController.getMaxPoolSizeAsString());
        this.maxQueueSizeField.setText(this.mirrorController.getMaxQueueSizeAsString());
        this.repaint();
    }

    @Override
    public void actionPerformed(ActionEvent action) {
        String command = action.getActionCommand();
        if (command.equals(ACTION_STOP)) {
            this.mirrorController.stopHttpMirror();
            this.stop.setEnabled(false);
            this.start.setEnabled(true);
        } else if (command.equals(ACTION_START)) {
            this.modifyTestElement((TestElement)this.mirrorController);
            this.mirrorController.startHttpMirror();
            this.start.setEnabled(false);
            this.stop.setEnabled(true);
        }
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        Box myBox = Box.createVerticalBox();
        myBox.add(this.createPortPanel());
        mainPanel.add((Component)myBox, "North");
        mainPanel.add((Component)this.createControls(), "Center");
        this.add(mainPanel, "Center");
    }

    private JPanel createControls() {
        this.start = new JButton(JMeterUtils.getResString((String)ACTION_START));
        this.start.addActionListener(this);
        this.start.setActionCommand(ACTION_START);
        this.start.setEnabled(true);
        this.stop = new JButton(JMeterUtils.getResString((String)ACTION_STOP));
        this.stop.addActionListener(this);
        this.stop.setActionCommand(ACTION_STOP);
        this.stop.setEnabled(false);
        JPanel panel = new JPanel();
        panel.add(this.start);
        panel.add(this.stop);
        return panel;
    }

    private JPanel createPortPanel() {
        this.portField = new JTextField(HttpMirrorControl.DEFAULT_PORT_S, 8);
        this.portField.setName("HttpMirrorControlGui.port");
        JLabel label = new JLabel(JMeterUtils.getResString((String)"port"));
        label.setLabelFor(this.portField);
        this.maxPoolSizeField = new JTextField(Integer.toString(0), 8);
        this.maxPoolSizeField.setName("HttpMirrorControlGui.maxPoolSize");
        JLabel mpsLabel = new JLabel(JMeterUtils.getResString((String)"httpmirror_max_pool_size"));
        mpsLabel.setLabelFor(this.maxPoolSizeField);
        this.maxQueueSizeField = new JTextField(Integer.toString(25), 8);
        this.maxQueueSizeField.setName("HttpMirrorControlGui.maxQueueSize");
        JLabel mqsLabel = new JLabel(JMeterUtils.getResString((String)"httpmirror_max_queue_size"));
        mqsLabel.setLabelFor(this.maxQueueSizeField);
        HorizontalPanel panel = new HorizontalPanel();
        panel.setBorder((Border)BorderFactory.createTitledBorder(BorderFactory.createEtchedBorder(), JMeterUtils.getResString((String)"httpmirror_settings")));
        panel.add((Component)label);
        panel.add((Component)this.portField);
        panel.add((Component)mpsLabel);
        panel.add((Component)this.maxPoolSizeField);
        panel.add((Component)mqsLabel);
        panel.add((Component)this.maxQueueSizeField);
        panel.add(Box.createHorizontalStrut(10));
        return panel;
    }

    public void clearGui() {
        super.clearGui();
        this.portField.setText(HttpMirrorControl.DEFAULT_PORT_S);
        this.maxPoolSizeField.setText(Integer.toString(0));
    }
}

