/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.DataStreamException;
import com.rmemoria.datastream.impl.Constants;
import java.lang.constant.Constable;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;

public class FieldAccess {
    private String name;
    private Method setMethod;
    private Method getMethod;

    public FieldAccess(String fieldName, Method getMethod, Method setMethod) {
        this.name = fieldName;
        this.setMethod = setMethod;
        this.getMethod = getMethod;
    }

    public Object getValue(Object obj) {
        try {
            return this.getMethod.invoke(obj, new Object[0]);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void setValue(Object obj, Object value) {
        if (obj == null) {
            throw new DataStreamException("Invalid null object to set value of " + this.getName() + ": " + this.getFieldType());
        }
        if (this.setMethod == null) {
            throw new RuntimeException("No set method found for property " + this.getName() + ": " + this.getFieldType());
        }
        try {
            if (value == Constants.NULL_VALUE || value == null) {
                this.setNullValue(obj);
            } else {
                this.setMethod.invoke(obj, value);
            }
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private void setNullValue(Object obj) throws InvocationTargetException, IllegalAccessException {
        Class<?> ftype = this.getFieldType();
        Constable arg = null;
        if (ftype.isPrimitive()) {
            if (Number.class.isAssignableFrom(ftype)) {
                arg = 0;
            } else if (Boolean.class.isAssignableFrom(ftype)) {
                arg = Boolean.valueOf(false);
            }
        }
        this.setMethod.invoke(obj, arg);
    }

    public boolean isWritable() {
        return this.setMethod != null;
    }

    public Class<?> getFieldType() {
        return this.getMethod.getReturnType();
    }

    public String getName() {
        return this.name;
    }

    public Method getSetMethod() {
        return this.setMethod;
    }

    public void setSetMethod(Method setMethod) {
        this.setMethod = setMethod;
    }

    public Method getGetMethod() {
        return this.getMethod;
    }

    public void setGetMethod(Method getMethod) {
        this.getMethod = getMethod;
    }
}

