/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.gui;

import java.awt.Component;
import java.awt.event.MouseEvent;
import java.beans.Introspector;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComponent;
import javax.swing.JOptionPane;
import javax.swing.JPopupMenu;
import javax.swing.JToolBar;
import javax.swing.SwingUtilities;
import org.apache.jmeter.engine.util.ValueReplacer;
import org.apache.jmeter.exceptions.IllegalUserActionException;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.LoggerPanel;
import org.apache.jmeter.gui.MainFrame;
import org.apache.jmeter.gui.Stoppable;
import org.apache.jmeter.gui.UndoHistory;
import org.apache.jmeter.gui.UnsharedComponent;
import org.apache.jmeter.gui.tree.JMeterTreeListener;
import org.apache.jmeter.gui.tree.JMeterTreeModel;
import org.apache.jmeter.gui.tree.JMeterTreeNode;
import org.apache.jmeter.gui.util.JMeterToolBar;
import org.apache.jmeter.services.FileServer;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.TestBeanGUI;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.TestPlan;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.testelement.property.TestElementProperty;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jorphan.collections.HashTree;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public final class GuiPackage
implements LocaleChangeListener,
UndoHistory.HistoryListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static GuiPackage guiPack;
    private boolean dirty = false;
    private Map<TestElement, JMeterGUIComponent> nodesToGui = new HashMap<TestElement, JMeterGUIComponent>();
    private Map<Class<?>, JMeterGUIComponent> guis = new HashMap();
    private Map<Class<?>, JMeterGUIComponent> testBeanGUIs = new HashMap();
    private JMeterTreeNode currentNode = null;
    private boolean currentNodeUpdated = false;
    private final JMeterTreeModel treeModel;
    private final JMeterTreeListener treeListener;
    private MainFrame mainFrame;
    private JToolBar toolbar;
    private JCheckBoxMenuItem menuToolBar;
    private JCheckBoxMenuItem menuItemLoggerPanel;
    private LoggerPanel loggerPanel;
    private UndoHistory undoHistory = new UndoHistory();
    private String testPlanFile;
    private final List<Stoppable> stoppables = Collections.synchronizedList(new ArrayList());

    private GuiPackage(JMeterTreeModel treeModel, JMeterTreeListener treeListener) {
        this.treeModel = treeModel;
        if (this.undoHistory.isEnabled()) {
            this.treeModel.addTreeModelListener(this.undoHistory);
        }
        this.treeListener = treeListener;
    }

    public static GuiPackage getInstance() {
        return guiPack;
    }

    public void registerAsListener() {
        if (this.undoHistory.isEnabled()) {
            this.undoHistory.registerHistoryListener(this);
        }
        JMeterUtils.addLocaleChangeListener(this);
    }

    public static GuiPackage getInstance(JMeterTreeListener listener, JMeterTreeModel treeModel) {
        if (guiPack == null) {
            guiPack = new GuiPackage(treeModel, listener);
            GuiPackage.guiPack.undoHistory.add(treeModel, "Created");
        }
        return guiPack;
    }

    public JMeterGUIComponent getGui(TestElement node) {
        String testClassName = node.getPropertyAsString("TestElement.test_class");
        String guiClassName = node.getPropertyAsString("TestElement.gui_class");
        try {
            Class<?> testClass = testClassName.equals("") ? node.getClass() : Class.forName(testClassName);
            Class<?> guiClass = null;
            if (!guiClassName.equals("")) {
                guiClass = Class.forName(guiClassName);
            }
            return this.getGui(node, guiClass, testClass);
        }
        catch (ClassNotFoundException e) {
            log.error("Could not get GUI for " + node, (Throwable)e);
            return null;
        }
    }

    public JMeterGUIComponent getGui(TestElement node, Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.nodesToGui.get(node);
            if (comp == null) {
                comp = this.getGuiFromCache(guiClass, testClass);
                this.nodesToGui.put(node, comp);
            }
            log.debug("Gui retrieved = " + comp);
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public void removeNode(TestElement node) {
        this.nodesToGui.remove(node);
    }

    public JMeterGUIComponent getCurrentGui() {
        try {
            this.updateCurrentNode();
            TestElement curNode = this.treeListener.getCurrentNode().getTestElement();
            JMeterGUIComponent comp = this.getGui(curNode);
            comp.clearGui();
            log.debug("Updating gui to new node");
            comp.configure(curNode);
            this.currentNodeUpdated = false;
            return comp;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public JMeterTreeNode getNodeOf(TestElement userObject) {
        return this.treeModel.getNodeOf(userObject);
    }

    public TestElement createTestElement(Class<?> guiClass, Class<?> testClass) {
        try {
            JMeterGUIComponent comp = this.getGuiFromCache(guiClass, testClass);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
            return null;
        }
    }

    public TestElement createTestElement(String objClass) {
        try {
            Class<?> c = Class.forName(objClass);
            JMeterGUIComponent comp = TestBean.class.isAssignableFrom(c) ? this.getGuiFromCache(TestBeanGUI.class, c) : this.getGuiFromCache(c, null);
            comp.clearGui();
            TestElement node = comp.createTestElement();
            this.nodesToGui.put(node, comp);
            return node;
        }
        catch (NoClassDefFoundError e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            String msg = "Cannot find class: " + e.getMessage();
            JOptionPane.showMessageDialog(null, msg, "Missing jar? See log file.", 0);
            throw new RuntimeException(e.toString(), e);
        }
        catch (ClassNotFoundException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        catch (InstantiationException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
        catch (IllegalAccessException e) {
            log.error("Problem retrieving gui for " + objClass, (Throwable)e);
            throw new RuntimeException(e.toString(), e);
        }
    }

    private JMeterGUIComponent getGuiFromCache(Class<?> guiClass, Class<?> testClass) throws InstantiationException, IllegalAccessException {
        JMeterGUIComponent comp;
        if (guiClass == TestBeanGUI.class) {
            comp = this.testBeanGUIs.get(testClass);
            if (comp == null) {
                comp = new TestBeanGUI(testClass);
                this.testBeanGUIs.put(testClass, comp);
            }
        } else {
            comp = this.guis.get(guiClass);
            if (comp == null && !((comp = (JMeterGUIComponent)guiClass.newInstance()) instanceof UnsharedComponent)) {
                this.guis.put(guiClass, comp);
            }
        }
        return comp;
    }

    public void updateCurrentGui() {
        this.updateCurrentNode();
        this.currentNode = this.treeListener.getCurrentNode();
        TestElement element = this.currentNode.getTestElement();
        JMeterGUIComponent comp = this.getGui(element);
        comp.configure(element);
        this.currentNodeUpdated = false;
    }

    public void updateCurrentNode() {
        try {
            if (this.currentNode != null && !this.currentNodeUpdated) {
                log.debug("Updating current node " + this.currentNode.getName());
                JMeterGUIComponent comp = this.getGui(this.currentNode.getTestElement());
                TestElement el = this.currentNode.getTestElement();
                int before = this.getTestElementCheckSum(el);
                comp.modifyTestElement(el);
                int after = this.getTestElementCheckSum(el);
                if (before != after) {
                    this.currentNode.nameChanged();
                }
            }
            this.currentNodeUpdated = true;
            this.currentNode = this.treeListener.getCurrentNode();
        }
        catch (Exception e) {
            log.error("Problem retrieving gui", (Throwable)e);
        }
    }

    public JMeterTreeNode getCurrentNode() {
        return this.treeListener.getCurrentNode();
    }

    public TestElement getCurrentElement() {
        return this.getCurrentNode().getTestElement();
    }

    public void setDirty(boolean dirty) {
        this.dirty = dirty;
    }

    public boolean isDirty() {
        return this.dirty;
    }

    public HashTree addSubTree(HashTree subTree) throws IllegalUserActionException {
        HashTree hashTree = this.treeModel.addSubTree(subTree, this.treeListener.getCurrentNode());
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Loaded tree");
        return hashTree;
    }

    public HashTree getCurrentSubTree() {
        return this.treeModel.getCurrentSubTree(this.treeListener.getCurrentNode());
    }

    public JMeterTreeModel getTreeModel() {
        return this.treeModel;
    }

    public ValueReplacer getReplacer() {
        return new ValueReplacer((TestPlan)((JMeterTreeNode)this.getTreeModel().getTestPlan().getArray()[0]).getTestElement());
    }

    public void setMainFrame(MainFrame newMainFrame) {
        this.mainFrame = newMainFrame;
    }

    public MainFrame getMainFrame() {
        return this.mainFrame;
    }

    public JMeterTreeListener getTreeListener() {
        return this.treeListener;
    }

    public void setMainToolbar(JToolBar newToolbar) {
        this.toolbar = newToolbar;
    }

    public JToolBar getMainToolbar() {
        return this.toolbar;
    }

    public void setMenuItemToolbar(JCheckBoxMenuItem newMenuToolBar) {
        this.menuToolBar = newMenuToolBar;
    }

    public JCheckBoxMenuItem getMenuItemToolbar() {
        return this.menuToolBar;
    }

    public void displayPopUp(MouseEvent e, JPopupMenu popup) {
        this.displayPopUp((Component)e.getSource(), e, popup);
    }

    public void displayPopUp(Component invoker, MouseEvent e, JPopupMenu popup) {
        if (popup != null) {
            log.debug("Showing pop up for " + invoker + " at x,y = " + e.getX() + "," + e.getY());
            popup.pack();
            popup.show(invoker, e.getX(), e.getY());
            popup.setVisible(true);
            popup.requestFocusInWindow();
        }
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        this.updateCurrentNode();
        this.guis = new HashMap();
        this.nodesToGui = new HashMap<TestElement, JMeterGUIComponent>();
        this.testBeanGUIs = new HashMap();
        Introspector.flushCaches();
        MainFrame mf = this.getMainFrame();
        if (mf == null) {
            log.warn("Mainframe is null");
        } else {
            mf.setMainPanel((JComponent)((Object)this.getCurrentGui()));
            mf.setEditMenu(this.getTreeListener().getCurrentNode().createPopupMenu());
        }
    }

    public void setTestPlanFile(String f) {
        this.testPlanFile = f;
        this.getMainFrame().setExtendedFrameTitle(this.testPlanFile);
        this.getMainFrame().setFileRevertEnabled(f != null);
        this.getMainFrame().setProjectFileLoaded(f);
        try {
            FileServer.getFileServer().setBasedir(this.testPlanFile);
        }
        catch (IllegalStateException e1) {
            log.error("Failure setting file server's base dir", (Throwable)e1);
        }
    }

    public String getTestPlanFile() {
        return this.testPlanFile;
    }

    public void clearTestPlan() {
        this.getTreeModel().clearTestPlan();
        this.nodesToGui.clear();
        this.setTestPlanFile(null);
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Initial Tree");
    }

    public void clearTestPlan(TestElement element) {
        this.getTreeModel().clearTestPlan(element);
        this.removeNode(element);
        this.undoHistory.clear();
        this.undoHistory.add(this.treeModel, "Initial Tree");
    }

    public static void showErrorMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 0);
    }

    public static void showInfoMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 1);
    }

    public static void showWarningMessage(String message, String title) {
        GuiPackage.showMessage(message, title, 2);
    }

    public static void showMessage(final String message, final String title, final int type) {
        if (guiPack == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                JOptionPane.showMessageDialog(null, message, title, type);
            }
        });
    }

    public void unregister(Stoppable stoppable) {
        Iterator<Stoppable> iterator = this.stoppables.iterator();
        while (iterator.hasNext()) {
            Stoppable stopable = iterator.next();
            if (stopable != stoppable) continue;
            iterator.remove();
        }
    }

    public void register(Stoppable stoppable) {
        this.stoppables.add(stoppable);
    }

    public List<Stoppable> getStoppables() {
        ArrayList<Stoppable> list = new ArrayList<Stoppable>();
        list.addAll(this.stoppables);
        return list;
    }

    public void setMenuItemLoggerPanel(JCheckBoxMenuItem menuItemLoggerPanel) {
        this.menuItemLoggerPanel = menuItemLoggerPanel;
    }

    public JCheckBoxMenuItem getMenuItemLoggerPanel() {
        return this.menuItemLoggerPanel;
    }

    public void setLoggerPanel(LoggerPanel loggerPanel) {
        this.loggerPanel = loggerPanel;
    }

    public LoggerPanel getLoggerPanel() {
        return this.loggerPanel;
    }

    public void goInHistory(int offset) {
        this.undoHistory.moveInHistory(offset, this.treeModel);
    }

    public boolean canRedo() {
        return this.undoHistory.canRedo();
    }

    public boolean canUndo() {
        return this.undoHistory.canUndo();
    }

    private int getTestElementCheckSum(TestElement el) {
        int ret = el.getClass().hashCode();
        PropertyIterator it = el.propertyIterator();
        while (it.hasNext()) {
            JMeterProperty obj = it.next();
            if (obj instanceof TestElementProperty) {
                ret ^= this.getTestElementCheckSum(((TestElementProperty)obj).getElement());
                continue;
            }
            ret ^= obj.getName().hashCode();
            ret ^= obj.getStringValue().hashCode();
        }
        return ret;
    }

    @Override
    public void notifyChangeInHistory(UndoHistory history) {
        ((JMeterToolBar)this.toolbar).updateUndoRedoIcons(history.canUndo(), history.canRedo());
    }
}

