/*
 * Decompiled with CFR 0.152.
 */
package jodd.util;

import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Map;
import java.util.Properties;
import jodd.io.StreamUtil;
import jodd.io.findfile.ClassFinder;
import jodd.io.findfile.ClassScanner;
import jodd.util.StringTemplateParser;
import jodd.util.StringUtil;

public class PropertiesUtil {
    private static final StringTemplateParser stp = new StringTemplateParser();

    public static Properties createFromFile(String fileName) throws IOException {
        return PropertiesUtil.createFromFile(new File(fileName));
    }

    public static Properties createFromFile(File file) throws IOException {
        Properties prop = new Properties();
        PropertiesUtil.loadFromFile(prop, file);
        return prop;
    }

    public static void loadFromFile(Properties p, String fileName) throws IOException {
        PropertiesUtil.loadFromFile(p, new File(fileName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromFile(Properties p, File file) throws IOException {
        FileInputStream fis = null;
        try {
            fis = new FileInputStream(file);
            p.load(fis);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            StreamUtil.close(fis);
            throw throwable;
        }
        StreamUtil.close(fis);
    }

    public static void writeToFile(Properties p, String fileName) throws IOException {
        PropertiesUtil.writeToFile(p, new File(fileName), null);
    }

    public static void writeToFile(Properties p, String fileName, String header) throws IOException {
        PropertiesUtil.writeToFile(p, new File(fileName), header);
    }

    public static void writeToFile(Properties p, File file) throws IOException {
        PropertiesUtil.writeToFile(p, file, null);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void writeToFile(Properties p, File file, String header) throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(file);
            p.store(fos, header);
            Object var5_4 = null;
        }
        catch (Throwable throwable) {
            Object var5_5 = null;
            StreamUtil.close(fos);
            throw throwable;
        }
        StreamUtil.close(fos);
    }

    public static Properties createFromString(String data) throws IOException {
        Properties p = new Properties();
        PropertiesUtil.loadFromString(p, data);
        return p;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void loadFromString(Properties p, String data) throws IOException {
        ByteArrayInputStream is = new ByteArrayInputStream(data.getBytes("ISO-8859-1"));
        try {
            p.load(is);
            Object var4_3 = null;
        }
        catch (Throwable throwable) {
            Object var4_4 = null;
            is.close();
            throw throwable;
        }
        is.close();
    }

    public static Properties subset(Properties p, String prefix, boolean stripPrefix) {
        if (StringUtil.isBlank(prefix)) {
            return p;
        }
        if (!prefix.endsWith(".")) {
            prefix = prefix + '.';
        }
        Properties result = new Properties();
        int baseLen = prefix.length();
        for (Object o : p.keySet()) {
            String key = (String)o;
            if (!key.startsWith(prefix)) continue;
            result.setProperty(stripPrefix ? key.substring(baseLen) : key, p.getProperty(key));
        }
        return result;
    }

    public static Properties createFromClasspath(String ... rootTemplate) {
        Properties p = new Properties();
        return PropertiesUtil.loadFromClasspath(p, rootTemplate);
    }

    public static Properties loadFromClasspath(final Properties p, String ... rootTemplate) {
        ClassScanner scanner = new ClassScanner(){

            protected void onEntry(ClassFinder.EntryData entryData) throws IOException {
                p.load(entryData.openInputStream());
            }
        };
        scanner.setIncludeResources(true);
        scanner.setIgnoreException(true);
        scanner.setExcludeAllEntries(true);
        scanner.setIncludedEntries(rootTemplate);
        scanner.scanDefaultClasspath();
        return p;
    }

    public static String getProperty(Map map, String key) {
        return PropertiesUtil.getProperty(map, key, null);
    }

    public static String getProperty(Map map, String key, String defaultValue) {
        Object val = map.get(key);
        return val instanceof String ? (String)val : defaultValue;
    }

    public static void resolveAllVariables(Properties prop) {
        for (Object o : prop.keySet()) {
            String key = (String)o;
            String value = PropertiesUtil.resolveProperty(prop, key);
            prop.setProperty(key, value);
        }
    }

    public static String resolveProperty(final Map map, String key) {
        String value = PropertiesUtil.getProperty(map, key);
        if (value == null) {
            return null;
        }
        value = stp.parse(value, new StringTemplateParser.MacroResolver(){

            public String resolve(String macroName) {
                return PropertiesUtil.getProperty(map, macroName);
            }
        });
        return value;
    }

    static {
        stp.setParseValues(true);
    }
}

