/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.DataConverter;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;

public class DefaultConverters
implements DataConverter {
    private static final SimpleDateFormat dtformat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ssZ");

    @Override
    public String convertToString(Object obj) {
        if (obj == null) {
            return "";
        }
        Class<?> classType = obj.getClass();
        if (classType == String.class) {
            return (String)obj;
        }
        if (classType == Integer.TYPE || classType == Integer.class) {
            return Integer.toString((Integer)obj);
        }
        if (classType == Long.TYPE || classType == Long.class) {
            return Long.toString((Long)obj);
        }
        if (classType == Character.TYPE || classType == Character.class) {
            return ((Character)obj).toString();
        }
        if (classType == Boolean.TYPE || classType == Boolean.class) {
            return (Boolean)obj != false ? "1" : "0";
        }
        if (classType == Float.class || classType == Float.TYPE) {
            return Float.toString(((Float)obj).floatValue());
        }
        if (classType == Double.class || classType == Double.TYPE) {
            return Double.toString((Double)obj);
        }
        if (Date.class.isAssignableFrom(classType)) {
            return dtformat.format((Date)obj);
        }
        if (Enum.class.isAssignableFrom(classType)) {
            return obj.toString();
        }
        throw new IllegalArgumentException("Class " + classType.toString() + " not supported for serialization");
    }

    @Override
    public Object convertFromString(String s, Class classType) {
        if (s == null || s.isEmpty()) {
            return null;
        }
        if (classType == String.class) {
            return s;
        }
        if (classType == Integer.TYPE || classType == Integer.class) {
            return Integer.parseInt(s);
        }
        if (classType == Long.TYPE || classType == Long.class) {
            return Long.parseLong(s);
        }
        if (classType == Character.TYPE || classType == Character.class) {
            if (s.length() > 0) {
                return Character.valueOf(s.charAt(0));
            }
            this.raiseConvertionError(s, classType);
        }
        if (classType == Boolean.TYPE || classType == Boolean.class) {
            if (s.equals("1") || s.equalsIgnoreCase("true")) {
                return true;
            }
            if (s.equals("0") || s.equalsIgnoreCase("false")) {
                return false;
            }
            this.raiseConvertionError(s, classType);
        }
        if (Date.class.isAssignableFrom(classType)) {
            try {
                return dtformat.parseObject(s);
            }
            catch (ParseException e) {
                this.raiseConvertionError(s, Date.class);
            }
        }
        if (classType == Float.TYPE || classType == Float.class) {
            return Float.valueOf(Float.parseFloat(s));
        }
        if (classType == Double.TYPE || classType == Double.class) {
            return Double.parseDouble(s);
        }
        if (Enum.class.isAssignableFrom(classType)) {
            return this.stringToEnum(s, classType);
        }
        this.raiseConvertionError(s, classType);
        return null;
    }

    protected Object stringToEnum(String s, Class classType) {
        Enum[] vals;
        for (Enum val : vals = (Enum[])classType.getEnumConstants()) {
            if (!val.toString().equals(s)) continue;
            return val;
        }
        throw new IllegalArgumentException("Value " + s + " is not valid for " + classType.toString());
    }

    protected void raiseConvertionError(String s, Class classType) {
        throw new IllegalArgumentException("Value " + s + " cannot be converted to " + classType.toString());
    }
}

