/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.StreamContext;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.Constants;
import com.rmemoria.datastream.impl.PropertyMetaData;
import com.rmemoria.datastream.impl.PropertyValue;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ObjectValues {
    private ClassMetaData classMetaData;
    private List<PropertyValue> properties = new ArrayList<PropertyValue>();
    private Map<String, String> customProperties;

    public ObjectValues(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public void addValue(String propertyName, Object value) {
        String[] props = propertyName.split("\\.");
        PropertyMetaData prop = this.classMetaData.findPropertyByName(props[0]);
        if (prop == null) {
            throw new RuntimeException("Property not found: " + propertyName);
        }
        PropertyValue pv = this.findPropertyValue(prop);
        if (pv == null) {
            pv = new PropertyValue(null, prop, null);
            this.properties.add(pv);
        }
        if (props.length > 1) {
            for (int i = 1; i < props.length; ++i) {
                PropertyMetaData aux = prop.findPropertyByName(props[i]);
                if (aux == null) {
                    throw new RuntimeException("Property not found: " + props[i]);
                }
                PropertyValue pvchild = pv.findChildPropertyValue(aux);
                if (pvchild == null) {
                    pvchild = pv.addChildValue(aux, null);
                }
                prop = aux;
                pv = pvchild;
            }
        }
        pv.setValue(value);
    }

    public Object getValue(String propname) {
        String[] props = propname.split("\\.");
        PropertyValue val = null;
        for (String pname : props) {
            if ((val = val == null ? this.findPropertyByName(pname) : val.findChildPropertyByName(pname)) == null) break;
        }
        return val != null ? val.getValue() : null;
    }

    private PropertyValue findPropertyByName(String propname) {
        for (PropertyValue pv : this.properties) {
            if (!pv.getProperty().getPropertyName().equals(propname)) continue;
            return pv;
        }
        return null;
    }

    public PropertyValue findPropertyValue(PropertyMetaData pmd) {
        for (PropertyValue pv : this.properties) {
            if (pv.getProperty() != pmd) continue;
            return pv;
        }
        return null;
    }

    public Object createObject(StreamContext context) {
        HashMap<String, Object> attrs = new HashMap<String, Object>();
        for (PropertyValue val : this.properties) {
            if (val.getValue() == Constants.NULL_VALUE) continue;
            val.addAttributes(attrs, null);
        }
        Object obj = context.createInstance(this.getClassMetaData().getGraphClass(), attrs);
        if (obj != null) {
            for (PropertyValue val : this.properties) {
                if (val.getValue() == Constants.NULL_VALUE) continue;
                val.writePropertyValue(context, obj);
            }
        }
        return obj;
    }

    public ClassMetaData getClassMetaData() {
        return this.classMetaData;
    }

    public void setClassMetaData(ClassMetaData classMetaData) {
        this.classMetaData = classMetaData;
    }

    public List<PropertyValue> getProperties() {
        return this.properties;
    }

    public Map<String, String> getCustomProperties() {
        return this.customProperties;
    }

    public void setCustomProperties(Map<String, String> customProperties) {
        this.customProperties = customProperties;
    }
}

