/*
 * Decompiled with CFR 0.152.
 */
package org.apache.avalon.excalibur.logger.logkit;

import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import org.apache.avalon.excalibur.logger.DefaultLogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.DefaultLogTargetManager;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManageable;
import org.apache.avalon.excalibur.logger.LogTargetFactoryManager;
import org.apache.avalon.excalibur.logger.LogTargetManager;
import org.apache.avalon.excalibur.logger.util.LoggerUtil;
import org.apache.avalon.framework.activity.Disposable;
import org.apache.avalon.framework.configuration.Configurable;
import org.apache.avalon.framework.configuration.Configuration;
import org.apache.avalon.framework.configuration.ConfigurationException;
import org.apache.avalon.framework.container.ContainerUtil;
import org.apache.avalon.framework.context.Context;
import org.apache.avalon.framework.context.ContextException;
import org.apache.avalon.framework.context.Contextualizable;
import org.apache.avalon.framework.logger.AbstractLogEnabled;
import org.apache.log.Hierarchy;
import org.apache.log.LogTarget;
import org.apache.log.Logger;
import org.apache.log.Priority;
import org.apache.log.util.Closeable;

public class LogKitConfHelper
extends AbstractLogEnabled
implements Contextualizable,
Configurable,
Disposable {
    private final Hierarchy m_hierarchy;
    private final Set m_targets = new HashSet();
    private Context m_context;

    public LogKitConfHelper(Hierarchy hierarchy) {
        if (hierarchy == null) {
            throw new NullPointerException("hierarchy");
        }
        this.m_hierarchy = hierarchy;
    }

    public final void contextualize(Context context) throws ContextException {
        this.m_context = context;
    }

    public final void configure(Configuration configuration) throws ConfigurationException {
        Configuration factories = configuration.getChild("factories");
        LogTargetFactoryManager targetFactoryManager = this.setupTargetFactoryManager(factories);
        Configuration targets = configuration.getChild("targets");
        LogTargetManager targetManager = this.setupTargetManager(targets, targetFactoryManager);
        Configuration categories = configuration.getChild("categories");
        this.setupLoggers(targetManager, null, categories, true, categories.getAttributeAsBoolean("additive", false));
    }

    private final LogTargetFactoryManager setupTargetFactoryManager(Configuration configuration) throws ConfigurationException {
        DefaultLogTargetFactoryManager targetFactoryManager = new DefaultLogTargetFactoryManager();
        ContainerUtil.enableLogging((Object)targetFactoryManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        try {
            ContainerUtil.contextualize((Object)targetFactoryManager, (Context)this.m_context);
        }
        catch (ContextException ce) {
            throw new ConfigurationException("cannot contextualize default factory manager", (Throwable)ce);
        }
        ContainerUtil.configure((Object)targetFactoryManager, (Configuration)configuration);
        return targetFactoryManager;
    }

    private final LogTargetManager setupTargetManager(Configuration configuration, LogTargetFactoryManager targetFactoryManager) throws ConfigurationException {
        DefaultLogTargetManager targetManager = new DefaultLogTargetManager();
        ContainerUtil.enableLogging((Object)targetManager, (org.apache.avalon.framework.logger.Logger)this.getLogger());
        if (targetManager instanceof LogTargetFactoryManageable) {
            targetManager.setLogTargetFactoryManager(targetFactoryManager);
        }
        ContainerUtil.configure((Object)targetManager, (Configuration)configuration);
        return targetManager;
    }

    private final void setupLoggers(LogTargetManager targetManager, String parentCategory, Configuration parentElement, boolean root, boolean defaultAdditive) throws ConfigurationException {
        boolean rootLoggerConfigured = false;
        Configuration[] categories = parentElement.getChildren("category");
        if (null != categories) {
            int i = 0;
            while (i < categories.length) {
                Logger logger;
                String fullCategory;
                String message;
                Configuration category = categories[i];
                String name = category.getAttribute("name");
                String loglevel = category.getAttribute("log-level").toUpperCase();
                boolean additive = category.getAttributeAsBoolean("additive", defaultAdditive);
                Configuration[] targets = category.getChildren("log-target");
                LogTarget[] logTargets = new LogTarget[targets.length];
                int j = 0;
                while (j < targets.length) {
                    String id = targets[j].getAttribute("id-ref");
                    logTargets[j] = targetManager.getLogTarget(id);
                    if (!this.m_targets.contains(logTargets[j])) {
                        this.m_targets.add(logTargets[j]);
                    }
                    ++j;
                }
                if ("".equals(name)) {
                    if (!root) {
                        message = "'category' element with empty name not at the root level: " + category.getLocation();
                        throw new ConfigurationException(message);
                    }
                    if (logTargets.length == 0) {
                        message = "At least one log-target should be specified for the root category " + category.getLocation();
                        throw new ConfigurationException(message);
                    }
                    fullCategory = null;
                    logger = this.m_hierarchy.getRootLogger();
                    rootLoggerConfigured = true;
                } else {
                    fullCategory = LoggerUtil.getFullCategoryName(parentCategory, name);
                    logger = this.m_hierarchy.getLoggerFor(fullCategory);
                }
                if (this.getLogger().isDebugEnabled()) {
                    message = "LogKitConfHelper: adding logger for category '" + (fullCategory != null ? fullCategory : "") + "'";
                    this.getLogger().debug(message);
                }
                logger.setPriority(Priority.getPriorityForName((String)loglevel));
                logger.setLogTargets(logTargets);
                logger.setAdditivity(additive);
                this.setupLoggers(targetManager, fullCategory, category, false, defaultAdditive);
                ++i;
            }
        }
        if (root && !rootLoggerConfigured) {
            String message = "No configuration for root category (<category name=''/>) found in " + parentElement.getLocation();
            throw new ConfigurationException(message);
        }
    }

    public void dispose() {
        Iterator iterator = this.m_targets.iterator();
        while (iterator.hasNext()) {
            LogTarget target = (LogTarget)iterator.next();
            if (!(target instanceof Closeable)) continue;
            ((Closeable)target).close();
        }
    }
}

