/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.threads;

import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.jmeter.util.JMeterUtils;

public class JMeterVariables {
    private final Map<String, Object> variables = new HashMap<String, Object>();
    private int iteration = 0;
    private static final String[] PRE_LOAD = new String[]{"START.MS", "START.YMD", "START.HMS", "TESTSTART.MS"};

    public JMeterVariables() {
        this.preloadVariables();
    }

    private void preloadVariables() {
        for (int i = 0; i < PRE_LOAD.length; ++i) {
            String property = PRE_LOAD[i];
            String value = JMeterUtils.getProperty(property);
            if (value == null) continue;
            this.variables.put(property, value);
        }
    }

    public String getThreadName() {
        return Thread.currentThread().getName();
    }

    public int getIteration() {
        return this.iteration;
    }

    public void incIteration() {
        ++this.iteration;
    }

    public void initialize() {
        this.variables.clear();
        this.preloadVariables();
    }

    public Object remove(String key) {
        return this.variables.remove(key);
    }

    public void put(String key, String value) {
        this.variables.put(key, value);
    }

    public void putObject(String key, Object value) {
        this.variables.put(key, value);
    }

    public void putAll(Map<String, ?> vars) {
        this.variables.putAll(vars);
    }

    public void putAll(JMeterVariables vars) {
        this.putAll(vars.variables);
    }

    public String get(String key) {
        return (String)this.variables.get(key);
    }

    public Object getObject(String key) {
        return this.variables.get(key);
    }

    public Iterator<Map.Entry<String, Object>> getIterator() {
        return Collections.unmodifiableMap(this.variables).entrySet().iterator();
    }

    public Set<Map.Entry<String, Object>> entrySet() {
        return Collections.unmodifiableMap(this.variables).entrySet();
    }
}

