/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import java.util.Calendar;
import java.util.GregorianCalendar;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.NumberEval;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.NumericFunction;
import org.apache.poi.ss.formula.functions.Var2or3ArgFunction;
import org.apache.poi.ss.usermodel.DateUtil;

public class Days360
extends Var2or3ArgFunction {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1) {
        double result;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            result = Days360.evaluate(d0, d1, false);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0, ValueEval arg1, ValueEval arg2) {
        double result;
        try {
            double d0 = NumericFunction.singleOperandEvaluate(arg0, srcRowIndex, srcColumnIndex);
            double d1 = NumericFunction.singleOperandEvaluate(arg1, srcRowIndex, srcColumnIndex);
            ValueEval ve = OperandResolver.getSingleValue(arg2, srcRowIndex, srcColumnIndex);
            Boolean method = OperandResolver.coerceValueToBoolean(ve, false);
            result = Days360.evaluate(d0, d1, method == null ? false : method);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        return new NumberEval(result);
    }

    private static double evaluate(double d0, double d1, boolean method) {
        Calendar startingDate = Days360.getStartingDate(d0);
        Calendar endingDate = Days360.getEndingDateAccordingToStartingDate(d1, startingDate);
        long startingDay = startingDate.get(2) * 30 + startingDate.get(5);
        long endingDay = (endingDate.get(1) - startingDate.get(1)) * 360 + endingDate.get(2) * 30 + endingDate.get(5);
        return endingDay - startingDay;
    }

    private static Calendar getDate(double date) {
        GregorianCalendar processedDate = new GregorianCalendar();
        processedDate.setTime(DateUtil.getJavaDate(date, false));
        return processedDate;
    }

    private static Calendar getStartingDate(double date) {
        Calendar startingDate = Days360.getDate(date);
        if (Days360.isLastDayOfMonth(startingDate)) {
            startingDate.set(5, 30);
        }
        return startingDate;
    }

    private static Calendar getEndingDateAccordingToStartingDate(double date, Calendar startingDate) {
        Calendar endingDate = Days360.getDate(date);
        endingDate.setTime(DateUtil.getJavaDate(date, false));
        if (Days360.isLastDayOfMonth(endingDate) && startingDate.get(5) < 30) {
            endingDate = Days360.getFirstDayOfNextMonth(endingDate);
        }
        return endingDate;
    }

    private static boolean isLastDayOfMonth(Calendar date) {
        Calendar clone = (Calendar)date.clone();
        clone.add(2, 1);
        clone.add(5, -1);
        int lastDayOfMonth = clone.get(5);
        return date.get(5) == lastDayOfMonth;
    }

    private static Calendar getFirstDayOfNextMonth(Calendar date) {
        Calendar newDate = (Calendar)date.clone();
        if (date.get(2) < 11) {
            newDate.set(2, date.get(2) + 1);
        } else {
            newDate.set(2, 1);
            newDate.set(1, date.get(1) + 1);
        }
        newDate.set(5, 1);
        return newDate;
    }
}

