/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers.backend;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.swing.ComboBoxModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.config.Argument;
import org.apache.jmeter.config.Arguments;
import org.apache.jmeter.config.gui.ArgumentsPanel;
import org.apache.jmeter.gui.util.HorizontalPanel;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.visualizers.backend.BackendListener;
import org.apache.jmeter.visualizers.backend.BackendListenerClient;
import org.apache.jmeter.visualizers.gui.AbstractListenerGui;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.reflect.ClassFinder;
import org.apache.log.Logger;

public class BackendListenerGui
extends AbstractListenerGui
implements ActionListener {
    private static final long serialVersionUID = 4331668988576438604L;
    private static final Logger LOGGER = LoggingManager.getLoggerForClass();
    private JComboBox classnameCombo;
    private JTextField queueSize;
    private ArgumentsPanel argsPanel;

    public BackendListenerGui() {
        this.init();
    }

    public String getLabelResource() {
        return "backend_listener";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel classnameRequestPanel = new JPanel(new BorderLayout(0, 5));
        classnameRequestPanel.add((Component)this.createClassnamePanel(), "North");
        classnameRequestPanel.add((Component)this.createParameterPanel(), "Center");
        this.add(classnameRequestPanel, "Center");
    }

    private JPanel createClassnamePanel() {
        List possibleClasses = new ArrayList();
        try {
            possibleClasses = ClassFinder.findClassesThatExtend((String[])JMeterUtils.getSearchPaths(), (Class[])new Class[]{BackendListenerClient.class});
            possibleClasses.remove(BackendListener.class.getName() + "$ErrorBackendListenerClient");
        }
        catch (Exception e) {
            LOGGER.debug("Exception getting interfaces.", (Throwable)e);
        }
        JLabel label = new JLabel(JMeterUtils.getResString((String)"backend_listener_classname"));
        this.classnameCombo = new JComboBox<Object>(possibleClasses.toArray());
        this.classnameCombo.addActionListener(this);
        this.classnameCombo.setEditable(false);
        label.setLabelFor(this.classnameCombo);
        HorizontalPanel classNamePanel = new HorizontalPanel();
        classNamePanel.add((Component)label);
        classNamePanel.add((Component)this.classnameCombo);
        this.queueSize = new JTextField("5000", 5);
        this.queueSize.setName("Queue Size");
        JLabel queueSizeLabel = new JLabel(JMeterUtils.getResString((String)"backend_listener_queue_size"));
        queueSizeLabel.setLabelFor(this.queueSize);
        HorizontalPanel queueSizePanel = new HorizontalPanel();
        queueSizePanel.add((Component)queueSizeLabel, (Object)"West");
        queueSizePanel.add((Component)this.queueSize);
        JPanel panel = new JPanel(new BorderLayout(0, 5));
        panel.add((Component)classNamePanel, "North");
        panel.add((Component)queueSizePanel, "Center");
        return panel;
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        if (event.getSource() == this.classnameCombo) {
            String className = ((String)this.classnameCombo.getSelectedItem()).trim();
            try {
                BackendListenerClient client = (BackendListenerClient)Class.forName(className, true, Thread.currentThread().getContextClassLoader()).newInstance();
                Arguments currArgs = new Arguments();
                this.argsPanel.modifyTestElement((TestElement)currArgs);
                Map currArgsMap = currArgs.getArgumentsAsMap();
                Arguments newArgs = new Arguments();
                Arguments testParams = null;
                try {
                    testParams = client.getDefaultParameters();
                }
                catch (AbstractMethodError e) {
                    LOGGER.warn("BackendListenerClient doesn't implement getDefaultParameters.  Default parameters won't be shown.  Please update your client class: " + className);
                }
                if (testParams != null) {
                    PropertyIterator i = testParams.getArguments().iterator();
                    while (i.hasNext()) {
                        String newVal;
                        Argument arg = (Argument)i.next().getObjectValue();
                        String name = arg.getName();
                        String value = arg.getValue();
                        if (currArgsMap.containsKey(name) && (newVal = (String)currArgsMap.get(name)) != null && newVal.length() > 0) {
                            value = newVal;
                        }
                        newArgs.addArgument(name, value);
                    }
                }
                this.argsPanel.configure((TestElement)newArgs);
            }
            catch (Exception e) {
                LOGGER.error("Error getting argument list for " + className, (Throwable)e);
            }
        }
    }

    private JPanel createParameterPanel() {
        this.argsPanel = new ArgumentsPanel(JMeterUtils.getResString((String)"backend_listener_paramtable"));
        return this.argsPanel;
    }

    public void configure(TestElement config) {
        super.configure(config);
        this.argsPanel.configure((TestElement)((Arguments)config.getProperty("arguments").getObjectValue()));
        String className = config.getPropertyAsString("classname");
        if (BackendListenerGui.checkContainsClassName(this.classnameCombo.getModel(), className)) {
            this.classnameCombo.setSelectedItem(className);
        } else {
            LOGGER.error("Error setting class:'" + className + "' in BackendListener: " + this.getName() + ", check for a missing jar in your jmeter 'search_paths' and 'plugin_dependency_paths' properties");
        }
        this.queueSize.setText(((BackendListener)config).getQueueSize());
    }

    private static final boolean checkContainsClassName(ComboBoxModel model, String className) {
        int size = model.getSize();
        HashSet<String> set = new HashSet<String>(size);
        for (int i = 0; i < size; ++i) {
            set.add((String)model.getElementAt(i));
        }
        return set.contains(className);
    }

    public TestElement createTestElement() {
        BackendListener config = new BackendListener();
        this.modifyTestElement((TestElement)config);
        return config;
    }

    public void modifyTestElement(TestElement config) {
        this.configureTestElement(config);
        BackendListener backendListener = (BackendListener)config;
        backendListener.setArguments((Arguments)this.argsPanel.createTestElement());
        backendListener.setClassname(String.valueOf(this.classnameCombo.getSelectedItem()));
        backendListener.setQueueSize(this.queueSize.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.argsPanel.clearGui();
        this.classnameCombo.setSelectedIndex(0);
        this.queueSize.setText("5000");
    }
}

