/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.control.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.apache.jmeter.control.SwitchController;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.util.JMeterUtils;

public class SwitchControllerGui
extends AbstractControllerGui {
    private static final long serialVersionUID = 240L;
    private static final String SWITCH_LABEL = "switch_controller_label";
    private JTextField switchValue;

    public SwitchControllerGui() {
        this.init();
    }

    public TestElement createTestElement() {
        SwitchController ic = new SwitchController();
        this.modifyTestElement((TestElement)ic);
        return ic;
    }

    public void modifyTestElement(TestElement ic) {
        this.configureTestElement(ic);
        ((SwitchController)ic).setSelection(this.switchValue.getText());
    }

    public void clearGui() {
        super.clearGui();
        this.switchValue.setText("");
    }

    public void configure(TestElement el) {
        super.configure(el);
        this.switchValue.setText(((SwitchController)el).getSelection());
    }

    public String getLabelResource() {
        return "switch_controller_title";
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add(this.makeTitlePanel(), "North");
        JPanel mainPanel = new JPanel(new BorderLayout());
        mainPanel.add((Component)this.createSwitchPanel(), "North");
        this.add(mainPanel, "Center");
    }

    private JPanel createSwitchPanel() {
        JPanel switchPanel = new JPanel(new BorderLayout(5, 0));
        JLabel selectionLabel = new JLabel(JMeterUtils.getResString((String)SWITCH_LABEL));
        this.switchValue = new JTextField("");
        selectionLabel.setLabelFor(this.switchValue);
        switchPanel.add((Component)selectionLabel, "West");
        switchPanel.add((Component)this.switchValue, "Center");
        return switchPanel;
    }
}

