/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.expectation;

import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import org.jmock.expectation.AbstractExpectation;
import org.jmock.expectation.ExpectationCollection;

public abstract class AbstractExpectationCollection
extends AbstractExpectation
implements ExpectationCollection {
    public AbstractExpectationCollection(String string) {
        super(string);
    }

    public void addActual(Object object) {
        this.getActualCollection().add(object);
        if (this.shouldCheckImmediately()) {
            this.checkImmediateValues(object);
        }
    }

    public void addActual(int n) {
        this.addActual(new Integer(n));
    }

    public void addActualMany(Object[] objectArray) {
        if (objectArray == null) {
            return;
        }
        for (int i = 0; i < objectArray.length; ++i) {
            this.addActual(objectArray[i]);
        }
    }

    public void addActualMany(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addActual(enumeration.nextElement());
        }
    }

    public void addActualMany(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addActual(iterator.next());
        }
    }

    public void addExpected(int n) {
        this.addExpected(new Integer(n));
    }

    public void addExpected(Object object) {
        this.getExpectedCollection().add(object);
        this.setHasExpectations();
    }

    public void addExpectedMany(Object[] objectArray) {
        for (int i = 0; i < objectArray.length; ++i) {
            this.addExpected(objectArray[i]);
        }
        this.setHasExpectations();
    }

    public void addExpectedMany(Enumeration enumeration) {
        while (enumeration.hasMoreElements()) {
            this.addExpected(enumeration.nextElement());
        }
        this.setHasExpectations();
    }

    public void addExpectedMany(Iterator iterator) {
        while (iterator.hasNext()) {
            this.addExpected(iterator.next());
        }
        this.setHasExpectations();
    }

    protected abstract void checkImmediateValues(Object var1);

    public void clearActual() {
        this.getActualCollection().clear();
    }

    protected void clearExpectation() {
        this.getExpectedCollection().clear();
    }

    protected abstract Collection getActualCollection();

    protected abstract Collection getExpectedCollection();

    public void setExpectNothing() {
        this.clearExpectation();
        this.setHasExpectations();
    }

    public void verify() {
        this.assertEquals("did not receive the expected collection items.", this.getExpectedCollection(), this.getActualCollection());
    }

    public void addActual(long l) {
        this.addActual(new Long(l));
    }

    public void addExpected(long l) {
        this.addExpected(new Long(l));
    }
}

