/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.CustomPropertiesWriter;
import com.rmemoria.datastream.DataConverter;
import com.rmemoria.datastream.DataStreamException;
import com.rmemoria.datastream.DataUnmarshaller;
import com.rmemoria.datastream.ObjectConsumer;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.CollectionMetaData;
import com.rmemoria.datastream.impl.Constants;
import com.rmemoria.datastream.impl.NodeSelection;
import com.rmemoria.datastream.impl.ObjectValues;
import com.rmemoria.datastream.impl.PropertyMetaData;
import com.rmemoria.datastream.impl.PropertyValue;
import com.rmemoria.datastream.impl.StreamContextImpl;
import com.rmemoria.datastream.jaxb.ObjectGraph;
import com.rmemoria.datastream.jaxb.Property;
import com.rmemoria.datastream.jaxb.PropertyUse;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Deque;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class XmlDataUnmarshallerImpl
implements DataUnmarshaller {
    private StreamContextImpl context;
    private CollectionMetaData currentCollection;
    private Collection results;
    private ObjectConsumer consumer;
    private NodeSelection node;
    private List<CustomPropertiesWriter> propWriters;
    private Deque<ObjectValues> objects = new ArrayDeque<ObjectValues>();
    private Map<String, String> customProperties;
    private String customPropName;
    private boolean saxCharacterCalled;

    public XmlDataUnmarshallerImpl(StreamContextImpl context) {
        this.context = context;
    }

    @Override
    public Object unmarshall(InputStream xmlstream) {
        this.results = new ArrayList();
        this.startParse(xmlstream);
        if (this.currentCollection != null || this.results.size() > 1) {
            return this.results;
        }
        if (this.results.size() == 0) {
            return null;
        }
        return ((ArrayList)this.results).get(0);
    }

    @Override
    public void unmarshall(InputStream stream, ObjectConsumer consumer) {
        this.consumer = consumer;
        this.startParse(stream);
    }

    protected void startParse(InputStream xmlstream) {
        SAXParserFactory factory = SAXParserFactory.newInstance();
        try {
            SAXParser parser = factory.newSAXParser();
            DefaultHandler handler = new DefaultHandler(){

                @Override
                public void startElement(String uri, String localName, String qName, Attributes attributes) throws SAXException {
                    XmlDataUnmarshallerImpl.this.saxStartElement(qName, attributes);
                }

                @Override
                public void endElement(String uri, String localName, String qName) throws SAXException {
                    XmlDataUnmarshallerImpl.this.saxEndElement(qName);
                }

                @Override
                public void characters(char[] ch, int start, int length) throws SAXException {
                    XmlDataUnmarshallerImpl.this.saxCharacters(new String(ch, start, length));
                }
            };
            InputSource is = new InputSource(new InputStreamReader(xmlstream, "UTF-8"));
            parser.parse(is, handler);
        }
        catch (SAXException e) {
            throw new RuntimeException(e);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        catch (ParserConfigurationException e) {
            throw new RuntimeException(e);
        }
    }

    protected void saxStartElement(String name, Attributes attributes) {
        NodeType nodeType = this.getNodeType();
        this.saxCharacterCalled = false;
        switch (nodeType) {
            case ROOT: {
                this.startRootNode(name, attributes);
                break;
            }
            case CLASS: {
                this.startPropertyNode(name, attributes);
                break;
            }
            case PROPERTY: {
                this.startClassNode(name, attributes);
                break;
            }
            case CUSTOM_PROPERTIES: {
                this.startCustomPropertiesNode(name, attributes);
            }
        }
    }

    protected void startCustomPropertiesNode(String name, Attributes attributes) {
        this.customPropName = name;
    }

    protected void startRootNode(String name, Attributes attributes) {
        if (this.currentCollection == null && this.context.getCollectionMetaData() != null) {
            this.currentCollection = this.context.getCollectionMetaData();
            String collname = this.currentCollection.getObjectCollection().getName();
            if (!collname.equals(name)) {
                throw new DataStreamException(this.getNodeHistory() + ": Expected element '" + collname + "' but found '" + name + "'");
            }
        } else {
            ClassMetaData cmd = this.context.findClassByElement(name);
            if (cmd == null) {
                throw new DataStreamException(this.getNodeHistory() + ": No class mapped for element " + name);
            }
            this.node = new NodeSelection(null, cmd);
            this.startClass(attributes);
            if (this.consumer != null) {
                this.consumer.startObjectReading(cmd.getGraphClass());
            }
        }
    }

    protected void startClassNode(String name, Attributes attributes) {
        ClassMetaData cmd = this.node.getPropertyMetaData().getCompactibleTypeMetaData();
        if (cmd == null) {
            throw new DataStreamException(this.node.getPropertyMetaData().getClassMetaData(), this.node.getPropertyMetaData(), this.getNodeHistory() + ": " + "A new element was found in property but no graph defined for property " + this.node.getPropertyMetaData() + ": element " + name);
        }
        this.node = new NodeSelection(this.node, cmd);
        this.startClass(attributes);
    }

    protected void startPropertyNode(String name, Attributes attributes) {
        if (name.equals(this.node.getClassMetaData().getGraph().getCustomPropertiesNode())) {
            this.customProperties = new HashMap<String, String>();
        } else {
            PropertyMetaData prop = this.node.getClassMetaData().findPropertyByElementName(name);
            if (prop == null) {
                throw new DataStreamException(this.node.getClassMetaData(), null, this.getNodeHistory() + ": Invalid element " + name + " in node " + this.node.getClassMetaData().getGraph().getName());
            }
            this.node = new NodeSelection(this.node, prop);
            if (prop.getCompactibleTypeMetaData() != null && !prop.isCollection()) {
                this.node = new NodeSelection(this.node, prop.getCompactibleTypeMetaData());
                this.startClass(attributes);
            }
        }
    }

    protected void startClass(Attributes attributes) {
        ClassMetaData currentClass = this.node.getClassMetaData();
        ObjectValues vals = new ObjectValues(currentClass);
        this.objects.push(vals);
        if (attributes != null) {
            for (int i = 0; i < attributes.getLength(); ++i) {
                String elemName = attributes.getQName(i);
                String propvalue = attributes.getValue(i);
                PropertyMetaData prop = currentClass.findPropertyByElementName(elemName);
                if (prop == null) {
                    throw new DataStreamException(currentClass, null, this.getNodeHistory() + ": Invalid element " + elemName + " in node " + currentClass.getGraph().getName());
                }
                Object val = this.convertValueFromString(prop, propvalue);
                vals.addValue(prop.getPath(), val);
            }
        }
    }

    protected Object convertValueFromString(PropertyMetaData prop, String value) {
        if (value != null && value.isEmpty()) {
            return Constants.NULL_VALUE;
        }
        Class type = prop.getConvertionType();
        DataConverter conv = this.context.findConverter(type);
        return conv.convertFromString(value, type);
    }

    protected void saxEndElement(String name) {
        switch (this.getNodeType()) {
            case ROOT: {
                return;
            }
            case PROPERTY: {
                this.endPropertyNode(name);
                break;
            }
            case CLASS: {
                this.endClassNode(name);
                break;
            }
            case CUSTOM_PROPERTIES: {
                this.endCustomPropertiesNode(name);
            }
        }
    }

    protected void endPropertyNode(String nodeName) {
        if (!this.saxCharacterCalled) {
            this.handleContentProperty(null);
        }
        this.node = this.node.getParent();
    }

    protected void endClassNode(String nodeName) {
        Object obj;
        this.node = this.node.getParent();
        ObjectValues vals = this.objects.pop();
        if (vals.getProperties().size() != 0) {
            this.checkRequiredProperties(vals);
            obj = vals.createObject(this.context);
            if (vals.getCustomProperties() != null) {
                this.notifyCustomPropWriters(obj, vals.getCustomProperties());
            }
        } else {
            obj = null;
        }
        if (this.node != null && this.node.isPropertySelection()) {
            ObjectValues parent = this.objects.pop();
            PropertyMetaData prop = this.node.getPropertyMetaData();
            if (prop.isCollection()) {
                HashSet<Object> lst = (HashSet<Object>)parent.getValue(prop.getPath());
                if (lst == null) {
                    lst = new HashSet<Object>();
                    parent.addValue(prop.getPath(), lst);
                }
                if (obj != null) {
                    lst.add(obj);
                }
            } else {
                parent.addValue(prop.getPath(), obj);
                this.node = this.node.getParent();
            }
            this.objects.push(parent);
        } else if (this.consumer != null) {
            this.consumer.onNewObject(obj);
        } else {
            this.results.add(obj);
        }
    }

    protected void notifyCustomPropWriters(Object obj, Map<String, String> customProperties) {
        if (this.propWriters == null) {
            return;
        }
        for (CustomPropertiesWriter writer : this.propWriters) {
            writer.writeCustomProperties(obj, customProperties);
        }
    }

    protected void endCustomPropertiesNode(String nodeName) {
        if (this.customPropName != null) {
            this.customPropName = null;
        } else {
            ObjectValues objvals = this.objects.getLast();
            objvals.setCustomProperties(this.customProperties);
            this.customProperties = null;
        }
    }

    private void checkRequiredProperties(ObjectValues vals) {
        ObjectGraph graph = vals.getClassMetaData().getGraph();
        for (Property prop : graph.getProperty()) {
            Object val;
            if (prop.getUse() != PropertyUse.REQUIRED || (val = vals.getValue(prop.getName())) != null) continue;
            String pname = prop.getElementName() != null ? prop.getElementName() : prop.getName();
            String s = "Property '" + vals.getClassMetaData().getGraph().getName() + "." + pname + "' is required";
            throw new DataStreamException(this.getNodeHistory() + ": " + s);
        }
    }

    protected void saxCharacters(String value) {
        this.saxCharacterCalled = true;
        if (value == null) {
            return;
        }
        if ((value = value.trim()).isEmpty()) {
            return;
        }
        switch (this.getNodeType()) {
            case ROOT: {
                return;
            }
            case PROPERTY: {
                this.handleContentProperty(value);
                break;
            }
            case CLASS: {
                this.handleContentClass(value);
                break;
            }
            case CUSTOM_PROPERTIES: {
                this.handleContentCustomProperty(value);
            }
        }
    }

    protected void handleContentProperty(String value) {
        PropertyMetaData prop = this.node.getPropertyMetaData();
        Object val = this.convertValueFromString(prop, value);
        ObjectValues vals = this.objects.pop();
        if (vals.findPropertyValue(prop) == null) {
            vals.addValue(prop.getPath(), val);
        }
        this.objects.push(vals);
    }

    protected void handleContentClass(String value) {
        throw new DataStreamException(this.node.getClassMetaData(), null, this.getNodeHistory() + ": A class element cannot have a content: " + this.node.getClassMetaData().getGraph().getName());
    }

    protected void handleContentCustomProperty(String value) {
        if (this.customPropName == null) {
            throw new DataStreamException(this.node.getClassMetaData(), null, this.getNodeHistory() + ":" + this.node.getClassMetaData().getGraph().getCustomPropertiesNode() + " Node cannot have a content, just other nodes");
        }
        this.customProperties.put(this.customPropName, value);
    }

    protected String getNodeHistory() {
        String s = "";
        for (ObjectValues obj : this.objects) {
            if (!s.isEmpty()) {
                s = s + ", ";
            }
            s = s + obj.getClassMetaData().getGraph().getName();
            if (obj.getProperties() == null || obj.getProperties().size() <= 0) continue;
            String text = "";
            for (PropertyValue prop : obj.getProperties()) {
                if (!text.isEmpty()) {
                    text = text + ", ";
                }
                String propname = prop.getProperty().getElementName() != null ? prop.getProperty().getElementName() : prop.getProperty().getPropertyName();
                text = text + propname + "=" + prop.getValue();
            }
            s = s + "[" + text + "]";
        }
        return s;
    }

    @Override
    public void addPropertyWriter(CustomPropertiesWriter writer) {
        if (this.propWriters == null) {
            this.propWriters = new ArrayList<CustomPropertiesWriter>();
        }
        this.propWriters.add(writer);
    }

    @Override
    public void removePropertyWriter(CustomPropertiesWriter writer) {
        if (this.propWriters == null) {
            return;
        }
        this.propWriters.remove(writer);
    }

    public NodeType getNodeType() {
        if (this.node == null) {
            return NodeType.ROOT;
        }
        if (this.customProperties != null) {
            return NodeType.CUSTOM_PROPERTIES;
        }
        if (this.node.isClassSelection()) {
            return NodeType.CLASS;
        }
        return NodeType.PROPERTY;
    }

    public static enum NodeType {
        ROOT,
        CLASS,
        PROPERTY,
        CUSTOM_PROPERTIES;

    }
}

