/*
 * Decompiled with CFR 0.152.
 */
package org.jmock.core.stub;

import java.util.HashMap;
import java.util.Map;
import junit.framework.Assert;
import org.jmock.core.Invocation;
import org.jmock.core.Stub;

public class ReturnStub
extends Assert
implements Stub {
    private Object result;
    private static Map BOX_TYPES = new HashMap();
    static /* synthetic */ Class class$java$lang$Boolean;
    static /* synthetic */ Class class$java$lang$Byte;
    static /* synthetic */ Class class$java$lang$Character;
    static /* synthetic */ Class class$java$lang$Short;
    static /* synthetic */ Class class$java$lang$Integer;
    static /* synthetic */ Class class$java$lang$Long;
    static /* synthetic */ Class class$java$lang$Float;
    static /* synthetic */ Class class$java$lang$Double;

    public ReturnStub(Object object) {
        this.result = object;
    }

    public Object invoke(Invocation invocation) throws Throwable {
        this.checkTypeCompatiblity(invocation.invokedMethod.getReturnType());
        return this.result;
    }

    public StringBuffer describeTo(StringBuffer stringBuffer) {
        return stringBuffer.append("returns <").append(this.result).append(">");
    }

    private void checkTypeCompatiblity(Class clazz) {
        if (this.result == null) {
            if (clazz.isPrimitive()) {
                this.reportInvalidNullValue(clazz);
            }
        } else if (clazz == Void.TYPE) {
            this.reportReturnFromVoidMethod();
        } else {
            Class<?> clazz2 = this.result.getClass();
            if (!this.isCompatible(clazz, clazz2)) {
                this.reportTypeError(clazz, clazz2);
            }
        }
    }

    private boolean isCompatible(Class clazz, Class clazz2) {
        if (clazz.isPrimitive()) {
            return this.isBoxedType(clazz, clazz2);
        }
        return clazz.isAssignableFrom(clazz2);
    }

    private boolean isBoxedType(Class clazz, Class clazz2) {
        return BOX_TYPES.get(clazz) == clazz2;
    }

    private void reportTypeError(Class clazz, Class clazz2) {
        ReturnStub.fail((String)("tried to return an incompatible value: expected a " + clazz + " but returned a " + clazz2));
    }

    private void reportInvalidNullValue(Class clazz) {
        ReturnStub.fail((String)("tried to return null value from invokedMethod returning " + clazz));
    }

    private void reportReturnFromVoidMethod() {
        ReturnStub.fail((String)"tried to return a value from a void method");
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    static {
        BOX_TYPES.put(Boolean.TYPE, class$java$lang$Boolean == null ? (class$java$lang$Boolean = ReturnStub.class$("java.lang.Boolean")) : class$java$lang$Boolean);
        BOX_TYPES.put(Byte.TYPE, class$java$lang$Byte == null ? (class$java$lang$Byte = ReturnStub.class$("java.lang.Byte")) : class$java$lang$Byte);
        BOX_TYPES.put(Character.TYPE, class$java$lang$Character == null ? (class$java$lang$Character = ReturnStub.class$("java.lang.Character")) : class$java$lang$Character);
        BOX_TYPES.put(Short.TYPE, class$java$lang$Short == null ? (class$java$lang$Short = ReturnStub.class$("java.lang.Short")) : class$java$lang$Short);
        BOX_TYPES.put(Integer.TYPE, class$java$lang$Integer == null ? (class$java$lang$Integer = ReturnStub.class$("java.lang.Integer")) : class$java$lang$Integer);
        BOX_TYPES.put(Long.TYPE, class$java$lang$Long == null ? (class$java$lang$Long = ReturnStub.class$("java.lang.Long")) : class$java$lang$Long);
        BOX_TYPES.put(Float.TYPE, class$java$lang$Float == null ? (class$java$lang$Float = ReturnStub.class$("java.lang.Float")) : class$java$lang$Float);
        BOX_TYPES.put(Double.TYPE, class$java$lang$Double == null ? (class$java$lang$Double = ReturnStub.class$("java.lang.Double")) : class$java$lang$Double);
    }
}

