/*
 * Decompiled with CFR 0.152.
 */
package javax.mail.internet;

import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.StringTokenizer;
import javax.mail.internet.ParseException;

public class ParameterList {
    private Map _parameters = new HashMap();

    public ParameterList() {
    }

    public ParameterList(String list) throws ParseException {
        if (list == null) {
            return;
        }
        StringTokenizer tokenizer = new StringTokenizer(list, ";");
        while (tokenizer.hasMoreTokens()) {
            String parameter = tokenizer.nextToken();
            int eq = parameter.indexOf("=");
            if (eq == -1) {
                throw new ParseException(parameter);
            }
            String name = parameter.substring(0, eq);
            String value = parameter.substring(eq + 1);
            this.set(name, value);
        }
    }

    public int size() {
        return this._parameters.size();
    }

    public String get(String name) {
        return (String)this._parameters.get(name);
    }

    public void set(String name, String value) {
        this._parameters.put(name.trim(), value.trim());
    }

    public void remove(String name) {
        this._parameters.remove(name);
    }

    public Enumeration getNames() {
        return Collections.enumeration(this._parameters.keySet());
    }

    public String toString() {
        Iterator it = this._parameters.entrySet().iterator();
        StringBuffer result = new StringBuffer();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            result.append(";");
            result.append(entry.getKey());
            result.append("=");
            result.append(entry.getValue());
        }
        return result.toString();
    }

    public String toString(int lineBreak) {
        String answer = this.toString();
        if (answer.length() > lineBreak) {
            return "";
        }
        return answer;
    }
}

