/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.Component;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorSupport;
import java.util.ResourceBundle;
import javax.swing.DefaultComboBoxModel;
import javax.swing.JComboBox;
import org.apache.jmeter.gui.ClearGui;

class EnumEditor
extends PropertyEditorSupport
implements ClearGui {
    private final JComboBox combo;
    private final DefaultComboBoxModel model = new DefaultComboBoxModel();
    private final int defaultIndex;

    public EnumEditor(PropertyDescriptor descriptor, Class<? extends Enum<?>> enumClazz, ResourceBundle rb) {
        this.combo = new JComboBox(this.model);
        this.combo.setEditable(false);
        for (Enum<?> e : enumClazz.getEnumConstants()) {
            this.model.addElement(rb.getObject(e.toString()));
        }
        Object def = descriptor.getValue("default");
        this.defaultIndex = def instanceof Integer ? (Integer)def : 0;
        this.combo.setSelectedIndex(this.defaultIndex);
    }

    @Override
    public boolean supportsCustomEditor() {
        return true;
    }

    @Override
    public Component getCustomEditor() {
        return this.combo;
    }

    @Override
    public Object getValue() {
        return this.combo.getSelectedIndex();
    }

    @Override
    public String getAsText() {
        Object value = this.combo.getSelectedItem();
        return (String)value;
    }

    @Override
    public void setValue(Object value) {
        if (value instanceof Enum) {
            this.combo.setSelectedIndex(((Enum)value).ordinal());
        } else if (value instanceof Integer) {
            this.combo.setSelectedIndex((Integer)value);
        } else {
            this.combo.setSelectedItem(value);
        }
    }

    @Override
    public void setAsText(String value) {
        this.combo.setSelectedItem(value);
    }

    @Override
    public void clearGui() {
        this.combo.setSelectedIndex(this.defaultIndex);
    }
}

