/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import thredds.catalog.DatasetFilter;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import ucar.nc2.units.DateType;

public abstract class InvCatalog {
    protected String name;
    protected String version;
    protected URI baseURI = null;
    protected InvDatasetImpl topDataset;
    protected Map<String, InvDataset> dsHash = new HashMap<String, InvDataset>();
    protected Map<String, InvService> serviceHash = new HashMap<String, InvService>();
    protected List<InvService> services = new ArrayList<InvService>();
    protected List<InvProperty> properties = new ArrayList<InvProperty>();
    protected List<InvDataset> datasets = new ArrayList<InvDataset>();
    protected DateType expires;

    protected InvCatalog() {
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public InvDatasetImpl getDataset() {
        return this.topDataset;
    }

    public InvDataset findDatasetByID(String id) {
        return this.dsHash.get(id);
    }

    public List<InvDataset> getDatasets() {
        return this.datasets;
    }

    public List<InvService> getServices() {
        return this.services;
    }

    public List<InvProperty> getProperties() {
        return this.properties;
    }

    public String findProperty(String name) {
        InvProperty result = null;
        for (InvProperty p : this.getProperties()) {
            if (!p.getName().equals(name)) continue;
            result = p;
        }
        return result == null ? null : result.getValue();
    }

    public DateType getExpires() {
        return this.expires;
    }

    public InvService findService(String name) {
        if (name == null) {
            return null;
        }
        for (InvService s : this.services) {
            if (name.equals(s.getName())) {
                return s;
            }
            for (InvService nested : s.getServices()) {
                if (!name.equals(nested.getName())) continue;
                return nested;
            }
        }
        return null;
    }

    public URI resolveUri(String uriString) throws URISyntaxException {
        URI want = new URI(uriString);
        if (this.baseURI == null || want.isAbsolute()) {
            return want;
        }
        String scheme = this.baseURI.getScheme();
        if (scheme != null && scheme.equals("file")) {
            String baseString = this.baseURI.toString();
            if (uriString.length() > 0 && uriString.charAt(0) == '#') {
                return new URI(baseString + uriString);
            }
            int pos = baseString.lastIndexOf(47);
            if (pos > 0) {
                String r = baseString.substring(0, pos + 1) + uriString;
                return new URI(r);
            }
        }
        return this.baseURI.resolve(want);
    }

    public String getUriString() {
        return this.baseURI.toString();
    }

    public abstract boolean check(StringBuilder var1, boolean var2);

    public boolean check(StringBuilder out) {
        return this.check(out, false);
    }

    public abstract void subset(InvDataset var1);

    public abstract void filter(DatasetFilter var1);
}

