/*
 * Decompiled with CFR 0.152.
 */
package org.richfaces.renderkit.html.images;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Graphics2D;
import java.awt.RenderingHints;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.util.Date;
import javax.faces.context.FacesContext;
import org.ajax4jsf.resource.InternetResourceBuilder;
import org.ajax4jsf.resource.Java2Dresource;
import org.ajax4jsf.resource.PngRenderer;
import org.ajax4jsf.resource.ResourceRenderer;
import org.ajax4jsf.util.HtmlColor;
import org.ajax4jsf.util.Zipper2;
import org.richfaces.skin.Skin;
import org.richfaces.skin.SkinFactory;

public abstract class EditorIcons
extends Java2Dresource {
    public static final String ADDITIONAL_BACKGROUND_COLOR = "additionalBackgroundColor";
    public static final String SELECT_CONTROL_COLOR = "selectControlColor";
    public static final String PANEL_BORDER_COLOR = "panelBorderColor";
    public static final String GENERAL_TEXT_COLOR = "generalTextColor";
    private final int SUB_BORDER_TRANSPARENCY = 150;

    public EditorIcons() {
        this.setRenderer((ResourceRenderer)new PngRenderer());
        this.setLastModified(new Date(InternetResourceBuilder.getInstance().getStartTime()));
    }

    protected Object getDataToStore(FacesContext context, Object data) {
        Skin skin = SkinFactory.getInstance().getSkin(context);
        Skin defaultSkin = SkinFactory.getInstance().getDefaultSkin(context);
        String additionalBackgroundColor = this.getSkinParameter(skin, defaultSkin, context, ADDITIONAL_BACKGROUND_COLOR);
        String selectControlColor = this.getSkinParameter(skin, defaultSkin, context, SELECT_CONTROL_COLOR);
        String panelBorderColor = this.getSkinParameter(skin, defaultSkin, context, PANEL_BORDER_COLOR);
        String generalTextColor = this.getSkinParameter(skin, defaultSkin, context, GENERAL_TEXT_COLOR);
        byte[] ret = new byte[12];
        Zipper2 zipper2 = new Zipper2(ret);
        zipper2.addColor(HtmlColor.decode((String)additionalBackgroundColor).getRGB());
        zipper2.addColor(HtmlColor.decode((String)selectControlColor).getRGB());
        zipper2.addColor(HtmlColor.decode((String)panelBorderColor).getRGB());
        zipper2.addColor(HtmlColor.decode((String)generalTextColor).getRGB());
        return ret;
    }

    protected Object deserializeData(byte[] objectArray) {
        if (objectArray == null) {
            return null;
        }
        Object[] colors = new Object[5];
        Zipper2 z = new Zipper2(objectArray);
        colors[0] = z.nextColor();
        colors[1] = z.nextColor();
        colors[2] = z.nextColor();
        colors[3] = z.nextColor();
        return colors;
    }

    private String getSkinParameter(Skin skin, Skin defaultSkin, FacesContext context, String parameterName) {
        String value = (String)skin.getParameter(context, parameterName);
        if (null == value || "".equals(value)) {
            value = (String)defaultSkin.getParameter(context, parameterName);
        }
        return value;
    }

    protected BufferedImage paintMainBlock(Object[] colors, boolean selected, boolean withoutSubBorders) {
        int w = 22;
        int h = 22;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = this.prepareImage(image);
        Color additionalBackgroundColor = (Color)colors[0];
        Color selectControlColor = (Color)colors[1];
        Color panelBorderColor = (Color)colors[2];
        Color subBorderColorWithAlpha = new Color(255, 255, 255, 150);
        Color contentColor = selected ? selectControlColor : additionalBackgroundColor;
        this.fillBodyWithGradient(g2d, w, h, contentColor);
        g2d.setColor(panelBorderColor);
        g2d.drawLine(0, 0, w, 0);
        g2d.drawLine(0, h - 1, w, h - 1);
        Color subBorderColorWithAlpha2 = new Color(contentColor.getRed(), contentColor.getGreen(), contentColor.getBlue(), 150);
        if (!withoutSubBorders) {
            g2d.setColor(subBorderColorWithAlpha);
            g2d.drawLine(0, 1, 0, h - 2);
            g2d.drawLine(0, 1, w - 1, 1);
            g2d.setColor(subBorderColorWithAlpha2);
            g2d.drawLine(0, h - 2, w - 1, h - 2);
            g2d.drawLine(w - 1, 1, w - 1, h - 2);
        }
        g2d.dispose();
        return image;
    }

    protected BufferedImage paintSeparatorBlock(Object[] colors) {
        int w = 5;
        int h = 22;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = this.prepareImage(image);
        Color additionalBackgroundColor = (Color)colors[0];
        Color panelBorderColor = (Color)colors[2];
        g2d.setColor(additionalBackgroundColor);
        Rectangle2D.Double border = new Rectangle2D.Double(0.0, 0.0, w, h);
        g2d.fill(border);
        g2d.setColor(panelBorderColor);
        g2d.drawLine(0, 1, 0, h - 2);
        g2d.drawLine(w - 1, 1, w - 1, h - 2);
        return image;
    }

    protected BufferedImage paintFirstTriangleBlock(Object[] colors, boolean selected) {
        int w = 11;
        int h = 22;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = this.prepareImage(image);
        Color additionalBackgroundColor = (Color)colors[0];
        Color selectControlColor = (Color)colors[1];
        Color panelBorderColor = (Color)colors[2];
        Color generalTextColor = (Color)colors[3];
        Color subBorderColorWithAlpha = new Color(255, 255, 255, 150);
        Color contentColor = selected ? selectControlColor : additionalBackgroundColor;
        Color subBorderColorWithAlpha2 = new Color(contentColor.getRed(), contentColor.getGreen(), contentColor.getBlue(), 150);
        this.fillBodyWithGradient(g2d, w, h, contentColor);
        g2d.setColor(panelBorderColor);
        g2d.drawLine(0, 0, w, 0);
        g2d.drawLine(0, h - 1, w, h - 1);
        g2d.setColor(subBorderColorWithAlpha);
        g2d.drawLine(0, 1, 0, h - 2);
        g2d.drawLine(0, 1, w - 1, 1);
        g2d.setColor(subBorderColorWithAlpha2);
        g2d.drawLine(w - 1, 1, w - 1, h - 2);
        g2d.drawLine(0, h - 2, w - 1, h - 2);
        this.paintTriangle(g2d, 3, 10, generalTextColor, Color.WHITE, true);
        return image;
    }

    private void paintTriangle(Graphics2D g2d, int x, int y, Color main, Color shadow, boolean shadowNeeded) {
        int w = 4;
        if (shadowNeeded) {
            g2d.setColor(shadow);
            g2d.drawLine(x, y + 1, x + w, y + 1);
            g2d.drawLine(x + 1, y + 2, x + w - 1, y + 2);
            g2d.drawLine(x + 2, y + 3, x + 2, y + 3);
        }
        g2d.setColor(main);
        g2d.drawLine(x, y, x + w, y);
        g2d.drawLine(x + 1, y + 1, x + w - 1, y + 1);
        g2d.drawLine(x + 2, y + 2, x + 2, y + 2);
    }

    protected BufferedImage paintSecondTriangleBlock(Object[] colors, boolean selected) {
        int w = 14;
        int h = 22;
        BufferedImage image = new BufferedImage(w, h, 2);
        Graphics2D g2d = this.prepareImage(image);
        Color additionalBackgroundColor = (Color)colors[0];
        Color selectControlColor = (Color)colors[1];
        Color panelBorderColor = (Color)colors[2];
        Color generalTextColor = (Color)colors[3];
        Color subBorderColorWithAlpha = new Color(255, 255, 255, 150);
        Color contentColor = selected ? selectControlColor : additionalBackgroundColor;
        this.fillBodyWithGradient(g2d, w, h, contentColor);
        g2d.setColor(panelBorderColor);
        g2d.drawLine(0, 0, w, 0);
        g2d.drawLine(0, h - 1, w, h - 1);
        g2d.drawLine(0, 0, 0, h);
        g2d.drawLine(w - 1, 0, w - 1, h);
        if (selected) {
            g2d.setColor(Color.white);
        } else {
            g2d.setColor(subBorderColorWithAlpha);
        }
        if (selected) {
            g2d.drawLine(1, 1, 1, h - 2);
            g2d.drawLine(w - 2, 1, w - 2, h - 2);
        }
        g2d.drawLine(1, 1, w - 2, 1);
        g2d.drawLine(1, h - 2, w - 2, h - 2);
        this.paintTriangle(g2d, 4, 10, generalTextColor, Color.WHITE, true);
        return image;
    }

    private void fillBodyWithGradient(Graphics2D g2d, int w, int h, Color color) {
        Color halfColor = new Color(color.getRed(), color.getGreen(), color.getBlue(), 90);
        Color halfColor2 = new Color(color.getRed(), color.getGreen(), color.getBlue(), 255);
        Rectangle2D.Double border = new Rectangle2D.Double(0.0, 0.0, w, h);
        g2d.setColor(Color.WHITE);
        g2d.fill(border);
        g2d.setColor(halfColor);
        border = new Rectangle2D.Double(0.0, 0.0, w, (double)h * 0.4);
        g2d.fill(border);
        Point2D.Double point2 = new Point2D.Double((double)w * 0.5, (double)h * 0.4);
        Point2D.Double point3 = new Point2D.Double((double)w * 0.5, h);
        border = new Rectangle2D.Double(0.0, (double)h * 0.4, w, h);
        GradientPaint gradient = new GradientPaint(point2, halfColor2, point3, halfColor);
        g2d.setPaint(gradient);
        g2d.fill(border);
    }

    private Graphics2D prepareImage(BufferedImage image) {
        Graphics2D g2d = image.createGraphics();
        g2d.setRenderingHint(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
        g2d.setRenderingHint(RenderingHints.KEY_COLOR_RENDERING, RenderingHints.VALUE_COLOR_RENDER_QUALITY);
        g2d.setStroke(new BasicStroke(1.0f));
        return g2d;
    }
}

