/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.visualizers;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.swing.AbstractAction;
import javax.swing.ActionMap;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.BoxLayout;
import javax.swing.InputMap;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JEditorPane;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.BadLocationException;
import javax.swing.text.DefaultHighlighter;
import javax.swing.text.Document;
import javax.swing.text.Highlighter;
import org.apache.jmeter.gui.action.KeyStrokes;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.log.Logger;

public class SearchTextExtension
implements ActionListener,
DocumentListener {
    private static final Logger log = LoggingManager.getLoggerForClass();
    private static final String SEARCH_TEXT_COMMAND = "search_text";
    private static volatile int LAST_POSITION_DEFAULT = 0;
    private int lastPosition = LAST_POSITION_DEFAULT;
    private static final Color HILIT_COLOR = Color.LIGHT_GRAY;
    private Highlighter selection;
    private Highlighter.HighlightPainter painter;
    private JLabel label;
    private JButton findButton;
    private JTextField textToFindField;
    private JCheckBox caseChkBox;
    private JCheckBox regexpChkBox;
    private String lastTextTofind;
    private boolean newSearch = false;
    private JEditorPane results;
    private JPanel searchPanel;

    public void init(JPanel resultsPane) {
    }

    public void setResults(JEditorPane results) {
        if (this.results != null) {
            this.newSearch = true;
            this.resetTextToFind();
        }
        this.results = results;
        this.selection = new DefaultHighlighter();
        this.painter = new DefaultHighlighter.DefaultHighlightPainter(HILIT_COLOR);
        results.setHighlighter(this.selection);
    }

    private void executeAndShowTextFind() {
        String textToFind = this.textToFindField.getText();
        if (this.results != null && this.results.getText().length() > 0 && textToFind.length() > 0) {
            if (this.lastTextTofind != null && !this.lastTextTofind.equals(textToFind)) {
                this.lastPosition = LAST_POSITION_DEFAULT;
            }
            if (log.isDebugEnabled()) {
                log.debug("lastPosition=" + this.lastPosition);
            }
            Matcher matcher = null;
            try {
                Pattern pattern = this.createPattern(textToFind);
                Document contentDoc = this.results.getDocument();
                String body = contentDoc.getText(this.lastPosition, contentDoc.getLength() - this.lastPosition);
                matcher = pattern.matcher(body);
                if (matcher != null && matcher.find()) {
                    this.selection.removeAllHighlights();
                    this.selection.addHighlight(this.lastPosition + matcher.start(), this.lastPosition + matcher.end(), this.painter);
                    this.results.setCaretPosition(this.lastPosition + matcher.end());
                    this.lastPosition += matcher.end();
                    this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_next"));
                    this.lastTextTofind = textToFind;
                    this.newSearch = true;
                } else {
                    JOptionPane.showMessageDialog(null, JMeterUtils.getResString((String)"search_text_msg_not_found"), JMeterUtils.getResString((String)"search_text_title_not_found"), 1);
                    this.lastPosition = LAST_POSITION_DEFAULT;
                    this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_find"));
                    this.results.setCaretPosition(0);
                }
            }
            catch (PatternSyntaxException pse) {
                JOptionPane.showMessageDialog(null, pse.toString(), JMeterUtils.getResString((String)"error_title"), 2);
            }
            catch (BadLocationException ble) {
                log.error("Location exception in text find", (Throwable)ble);
            }
        }
    }

    private JPanel createSearchTextPanel() {
        Font font = new Font("SansSerif", 0, 10);
        this.searchPanel = new JPanel();
        this.searchPanel.setLayout(new BoxLayout(this.searchPanel, 0));
        this.searchPanel.setBorder(BorderFactory.createEmptyBorder(3, 3, 3, 3));
        this.label = new JLabel(JMeterUtils.getResString((String)"search_text_field"));
        this.label.setBorder(BorderFactory.createEmptyBorder(0, 0, 0, 5));
        this.searchPanel.add(this.label);
        this.textToFindField = new JTextField();
        this.searchPanel.add(this.textToFindField);
        this.searchPanel.add(Box.createRigidArea(new Dimension(5, 0)));
        this.textToFindField.getDocument().addDocumentListener(this);
        this.findButton = new JButton(JMeterUtils.getResString((String)"search_text_button_find"));
        this.findButton.setFont(font);
        this.findButton.setActionCommand(SEARCH_TEXT_COMMAND);
        this.findButton.addActionListener(this);
        this.searchPanel.add(this.findButton);
        this.caseChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_case"), false);
        this.caseChkBox.setFont(font);
        this.searchPanel.add(this.caseChkBox);
        this.regexpChkBox = new JCheckBox(JMeterUtils.getResString((String)"search_text_chkbox_regexp"), false);
        this.regexpChkBox.setFont(font);
        this.searchPanel.add(this.regexpChkBox);
        InputMap im = this.textToFindField.getInputMap(2);
        im.put(KeyStrokes.ENTER, SEARCH_TEXT_COMMAND);
        ActionMap am = this.textToFindField.getActionMap();
        am.put(SEARCH_TEXT_COMMAND, new EnterAction());
        this.searchPanel.setVisible(true);
        return this.searchPanel;
    }

    JPanel createSearchTextExtensionPane() {
        JPanel pane = new JPanel();
        pane.setLayout(new BoxLayout(pane, 0));
        pane.add(this.createSearchTextPanel());
        return pane;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String command = e.getActionCommand();
        if (SEARCH_TEXT_COMMAND.equals(command)) {
            this.executeAndShowTextFind();
        }
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.resetTextToFind();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.resetTextToFind();
    }

    void resetTextToFind() {
        if (this.newSearch) {
            log.debug("reset pass");
            this.lastPosition = LAST_POSITION_DEFAULT;
            this.lastTextTofind = null;
            this.findButton.setText(JMeterUtils.getResString((String)"search_text_button_find"));
            this.selection.removeAllHighlights();
            this.results.setCaretPosition(0);
            this.newSearch = false;
        }
    }

    private Pattern createPattern(String textToFind) {
        String textToFindQ = Pattern.quote(textToFind);
        if (this.regexpChkBox.isSelected()) {
            textToFindQ = textToFind;
        }
        Pattern pattern = null;
        pattern = this.caseChkBox.isSelected() ? Pattern.compile(textToFindQ) : Pattern.compile(textToFindQ, 2);
        return pattern;
    }

    private class EnterAction
    extends AbstractAction {
        private static final long serialVersionUID = 1L;

        private EnterAction() {
        }

        @Override
        public void actionPerformed(ActionEvent ev) {
            SearchTextExtension.this.executeAndShowTextFind();
        }
    }
}

