/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.DataStreamException;
import com.rmemoria.datastream.impl.ClassMetaData;
import com.rmemoria.datastream.impl.CollectionMetaData;
import com.rmemoria.datastream.impl.FieldAccess;
import com.rmemoria.datastream.impl.PropertyMetaData;
import com.rmemoria.datastream.impl.StreamContextImpl;
import com.rmemoria.datastream.jaxb.ObjectCollection;
import com.rmemoria.datastream.jaxb.ObjectGraph;
import com.rmemoria.datastream.jaxb.Property;
import java.lang.reflect.Field;
import java.lang.reflect.Method;

public class ClassPropertyScanner {
    public CollectionMetaData scan(StreamContextImpl context, ObjectCollection collection) {
        CollectionMetaData lst = new CollectionMetaData(collection);
        for (ObjectGraph graph : collection.getObjectGraph()) {
            ClassMetaData cmd = this.scan(context, graph);
            lst.getClassesMetaData().add(cmd);
        }
        return lst;
    }

    public ClassMetaData scan(StreamContextImpl context, ObjectGraph graph) {
        Class<?> clazz;
        try {
            clazz = Class.forName(graph.getClazz());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
        ClassMetaData classMetaData = new ClassMetaData(context, graph, clazz);
        for (Property property : graph.getProperty()) {
            this.createPropertyFromXML(classMetaData, property);
        }
        this.scanClass(classMetaData, clazz);
        this.checkParentProperty(classMetaData);
        return classMetaData;
    }

    protected void checkParentProperty(ClassMetaData classMetaData) {
        String parentprop = classMetaData.getGraph().getParentProperty();
        if (parentprop == null) {
            return;
        }
        PropertyMetaData aux = classMetaData.findPropertyByName(parentprop);
        if (aux == null) {
            aux = new PropertyMetaData(classMetaData);
            aux.setFieldAccess(this.createFieldAccess(classMetaData.getGraphClass(), parentprop));
            classMetaData.addProperty(aux);
        }
        classMetaData.setLinkParentObject(aux);
    }

    protected PropertyMetaData createPropertyFromXML(ClassMetaData cmd, Property property) {
        String[] props = property.getName().split("\\.");
        PropertyMetaData prop = cmd.findPropertyByName(props[0]);
        if (prop == null) {
            prop = new PropertyMetaData(cmd);
            FieldAccess fa = this.createFieldAccess(cmd.getGraphClass(), props[0]);
            if (fa == null) {
                throw new DataStreamException("Property " + property.getName() + " not found");
            }
            prop.setFieldAccess(fa);
            cmd.addProperty(prop);
        }
        if (props.length > 1) {
            PropertyMetaData parent = prop;
            for (int i = 1; i < props.length; ++i) {
                PropertyMetaData child = parent.findPropertyByName(props[i]);
                if (child == null) {
                    child = new PropertyMetaData(cmd);
                    child.setFieldAccess(this.createFieldAccess(parent.getPropertyType(), props[i]));
                    parent.addProperty(child);
                }
                parent = child;
            }
            parent.setProperty(property);
        } else {
            prop.setProperty(property);
        }
        if (prop.getProperty() != null && prop.getProperty().getObjectGraph() != null) {
            if (prop.getProperty().isXmlAttribute()) {
                throw new DataStreamException("Property that contains a graph definition cannot be used as an XML attribute: " + prop);
            }
            if (prop.isComposed()) {
                throw new IllegalArgumentException("Composed property cannot point to a graph definition: " + prop);
            }
            ClassMetaData cmdProp = this.scan(cmd.getContext(), prop.getProperty().getObjectGraph());
            prop.setTypeMetaData(cmdProp);
            cmdProp.setParentProperty(prop);
        }
        return prop;
    }

    protected void scanClass(ClassMetaData classMetaData, Class clazz) {
        this.scanRecursive(classMetaData, clazz);
    }

    private void scanRecursive(ClassMetaData classMetaData, Class clazz) {
        Field[] fields;
        for (Field field : fields = clazz.getDeclaredFields()) {
            FieldAccess fa;
            PropertyMetaData p = classMetaData.findPropertyByName(field.getName());
            if (p != null || (fa = this.createFieldAccess(clazz, field.getName())) == null) continue;
            p = new PropertyMetaData(classMetaData);
            classMetaData.addProperty(p);
            p.setFieldAccess(fa);
        }
        if ((clazz = clazz.getSuperclass()) != null && clazz != Object.class) {
            this.scanClass(classMetaData, clazz);
        }
    }

    protected FieldAccess createFieldAccess(Class clazz, String fieldname) {
        String name = Character.toUpperCase(fieldname.charAt(0)) + fieldname.substring(1);
        Class[] param1 = new Class[]{};
        Method get = this.getDeclaredMethod(clazz, "get" + name, param1);
        if (get == null) {
            get = this.getDeclaredMethod(clazz, "is" + name, param1);
        }
        if (get == null) {
            return null;
        }
        Class<?> type = get.getReturnType();
        Class[] param2 = new Class[]{type};
        Method set = this.getDeclaredMethod(clazz, "set" + name, param2);
        return new FieldAccess(fieldname, get, set);
    }

    protected Field getDeclaredField(Class clazz, String fieldname) {
        while (clazz != Object.class) {
            Field[] fields;
            for (Field fld : fields = clazz.getDeclaredFields()) {
                if (!fld.getName().equals(fieldname)) continue;
                return fld;
            }
            clazz = clazz.getSuperclass();
        }
        return null;
    }

    protected Method getDeclaredMethod(Class clazz, String metname, Class[] params) {
        while (clazz != Object.class) {
            try {
                return clazz.getDeclaredMethod(metname, params);
            }
            catch (NoSuchMethodException e) {
                if ((clazz = clazz.getSuperclass()) == null) continue;
                return this.getDeclaredMethod(clazz, metname, params);
            }
        }
        return null;
    }
}

