/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.protocol.http.util;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import java.net.UnknownHostException;
import org.apache.commons.httpclient.ConnectTimeoutException;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;
import org.apache.jmeter.util.SlowSocket;

public class SlowHttpClientSocketFactory
implements ProtocolSocketFactory {
    private final int CPS;

    public SlowHttpClientSocketFactory(int cps) {
        this.CPS = cps;
    }

    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        return new SlowSocket(this.CPS, host, port, clientHost, clientPort);
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        return new SlowSocket(this.CPS, host, port);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, ConnectTimeoutException {
        int timeout = params.getConnectionTimeout();
        if (timeout == 0) {
            return new SlowSocket(this.CPS, host, port, localAddress, localPort);
        }
        return new SlowSocket(this.CPS, host, port, localAddress, localPort, timeout);
    }
}

