/**
 * Define the application module
 * @type {{showMessage, closeMessageDlg}}
 */
mods.app = function($) {
    return {
        /**
         * Show standard message dialog, with pre define actions
         * @param options object (title, message, type: ['YESNO', 'OK'], onConfirm, onClose, onReject)
         */
        showMessage: function(options) {
            mods.modal.show('message-dlg');
            var e = $('#message-dlg');
            e.find('.dlg-header').text(options.title);
            e.find('.dlg-content').text(options.message);

            e.find('.dlg-footer #dlg-YESNO').toggle(options.type === 'YESNO');
            e.find('.dlg-footer #dlg-OK').toggle(options.type === 'OK');

            // little trick to preserve the options when closing the window
            mods.app.showMessage.options = options;
        },

        /**
         * Close the application message dialog being displayed
         * @param cmd
         */
        closeMessageDlg: function(cmd) {
            mods.modal.hide('message-dlg');
            var opts = mods.app.showMessage.options;

            // this delay is included in order to avoid conflicts when
            // one message is displayed after another (second dlg is displayed
            // and hidden)
            setTimeout(function() {
                // inform about window closing
                if (opts) {
                    delete mods.app.showMessage.options;
                    if (opts.onClose) {
                        opts.onClose(cmd);
                    }
                    if (cmd === 'yes' && opts.onConfirm) {
                        opts.onConfirm(cmd);
                    }
                    if (cmd === 'no' && opts.onReject) {
                        opts.onReject(cmd);
                    }
                }
            }, 200);
        }
    }
}(jQuery);

