/*
 * Decompiled with CFR 0.152.
 */
package com.rmemoria.datastream.impl;

import com.rmemoria.datastream.impl.PropertyMetaData;
import com.rmemoria.datastream.impl.StreamContextImpl;
import com.rmemoria.datastream.jaxb.ObjectGraph;
import java.util.ArrayList;
import java.util.List;

public class ClassMetaData {
    private ObjectGraph graph;
    private List<PropertyMetaData> properties = new ArrayList<PropertyMetaData>();
    private List<PropertyMetaData> endpointProperties;
    private Class graphClass;
    private PropertyMetaData parentProperty;
    private PropertyMetaData linkParentObject;
    private StreamContextImpl context;

    public ClassMetaData(StreamContextImpl context, ObjectGraph graph, Class graphClass) {
        this.context = context;
        this.graph = graph;
        this.graphClass = graphClass;
    }

    public List<PropertyMetaData> getProperties() {
        return this.properties;
    }

    public List<PropertyMetaData> getEndPointProperties() {
        if (this.endpointProperties == null) {
            this.endpointProperties = new ArrayList<PropertyMetaData>();
            for (PropertyMetaData pmd : this.properties) {
                pmd.findEndpointProperties(this.endpointProperties);
            }
        }
        return this.endpointProperties;
    }

    public PropertyMetaData findPropertyByElementName(String name) {
        for (PropertyMetaData prop : this.getEndPointProperties()) {
            if (!prop.getElementName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public PropertyMetaData findPropertyByName(String name) {
        if (name.indexOf(46) > 0) {
            String[] props = name.split("//.");
            PropertyMetaData pmd = this.findPropertyByName(props[0]);
            if (pmd == null) {
                return null;
            }
            for (int i = 1; i < props.length; ++i) {
                if ((pmd = pmd.findPropertyByName(props[i])) != null) continue;
                return null;
            }
            return pmd;
        }
        for (PropertyMetaData prop : this.properties) {
            if (!prop.getPropertyName().equals(name)) continue;
            return prop;
        }
        return null;
    }

    public boolean isNotDeclaredPropsIgnored() {
        return Boolean.TRUE.equals(this.graph.getIgnorePropsNotDeclared());
    }

    public ObjectGraph getGraph() {
        return this.graph;
    }

    protected void addProperty(PropertyMetaData prop) {
        this.properties.add(prop);
    }

    public Class getGraphClass() {
        return this.graphClass;
    }

    public PropertyMetaData getParentProperty() {
        return this.parentProperty;
    }

    public void setParentProperty(PropertyMetaData parentProperty) {
        this.parentProperty = parentProperty;
    }

    public PropertyMetaData getLinkParentObject() {
        return this.linkParentObject;
    }

    public void setLinkParentObject(PropertyMetaData linkParentObject) {
        this.linkParentObject = linkParentObject;
    }

    public String toString() {
        return "ClassMetaData [" + this.graphClass + "]";
    }

    public StreamContextImpl getContext() {
        return this.context;
    }
}

