/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.util;

import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.ws.rs.core.MultivaluedMap;
import org.jboss.resteasy.specimpl.MultivaluedMapImpl;
import org.jboss.resteasy.util.PathHelper;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class Encode {
    private static final Pattern PARAM_REPLACEMENT;
    private static final String[] pathEncoding;
    private static final String[] pathSegmentEncoding;
    private static final String[] matrixParameterEncoding;
    private static final String[] queryNameValueEncoding;
    private static final String[] queryStringEncoding;
    private static final Pattern nonCodes;
    private static final Pattern encodedChars;

    public static String encodeQueryString(String value) {
        return Encode.encodeValue(value, queryStringEncoding);
    }

    public static String encodePath(String value) {
        return Encode.encodeValue(value, pathEncoding);
    }

    public static String encodePathSegment(String value) {
        return Encode.encodeValue(value, pathSegmentEncoding);
    }

    public static String encodeFragment(String value) {
        return Encode.encodeValue(value, queryNameValueEncoding);
    }

    public static String encodeMatrixParam(String value) {
        return Encode.encodeValue(value, matrixParameterEncoding);
    }

    public static String encodeQueryParam(String value) {
        return Encode.encodeValue(value, queryNameValueEncoding);
    }

    public static String decodePath(String path) {
        Matcher matcher = encodedChars.matcher(path);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            String enc = matcher.group(1);
            int c = Integer.parseInt(enc, 16);
            StringBuffer cBuf = new StringBuffer();
            char chr = (char)c;
            switch (chr) {
                case '\\': {
                    cBuf.append("\\\\");
                    break;
                }
                case '$': {
                    cBuf.append("\\$");
                    break;
                }
                default: {
                    cBuf.append(chr);
                }
            }
            matcher.appendReplacement(buf, cBuf.toString());
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    public static String encodeNonCodes(String string) {
        Matcher matcher = nonCodes.matcher(string);
        StringBuffer buf = new StringBuffer();
        while (matcher.find()) {
            matcher.appendReplacement(buf, "%25$1");
        }
        matcher.appendTail(buf);
        return buf.toString();
    }

    private static boolean savePathParams(String segment, StringBuffer newSegment, List<String> params) {
        boolean foundParam = false;
        segment = PathHelper.replaceEnclosedCurlyBraces(segment);
        Matcher matcher = PathHelper.URI_TEMPLATE_PATTERN.matcher(segment);
        while (matcher.find()) {
            foundParam = true;
            String group = matcher.group();
            params.add(PathHelper.recoverEnclosedCurlyBraces(group));
            matcher.appendReplacement(newSegment, "_resteasy_uri_parameter");
        }
        matcher.appendTail(newSegment);
        return foundParam;
    }

    public static String encodeValue(String segment, String[] encoding) {
        ArrayList<String> params = new ArrayList<String>();
        boolean foundParam = false;
        StringBuffer newSegment = new StringBuffer();
        if (Encode.savePathParams(segment, newSegment, params)) {
            foundParam = true;
            segment = newSegment.toString();
        }
        String result = Encode.encodeFromArray(segment, encoding, false);
        segment = result = Encode.encodeNonCodes(result);
        if (foundParam) {
            segment = Encode.pathParamReplacement(segment, params);
        }
        return segment;
    }

    public static String encodePathAsIs(String segment) {
        return Encode.encodeFromArray(segment, pathEncoding, true);
    }

    public static String encodePathSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, pathEncoding, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodeQueryParamAsIs(String nameOrValue) {
        return Encode.encodeFromArray(nameOrValue, queryNameValueEncoding, true);
    }

    public static String encodeQueryParamSaveEncodings(String segment) {
        String result = Encode.encodeFromArray(segment, queryNameValueEncoding, false);
        result = Encode.encodeNonCodes(result);
        return result;
    }

    public static String encodeFragmentAsIs(String nameOrValue) {
        return Encode.encodeFromArray(nameOrValue, queryNameValueEncoding, true);
    }

    protected static String encodeFromArray(String segment, String[] encodingMap, boolean encodePercent) {
        StringBuffer result = new StringBuffer();
        for (int i = 0; i < segment.length(); ++i) {
            if (!encodePercent && segment.charAt(i) == '%') {
                result.append(segment.charAt(i));
                continue;
            }
            char idx = segment.charAt(i);
            String encoding = encodingMap[idx];
            if (encoding == null) {
                result.append(segment.charAt(i));
                continue;
            }
            result.append(encoding);
        }
        return result.toString();
    }

    private static String pathParamReplacement(String segment, List<String> params) {
        StringBuffer newSegment = new StringBuffer();
        Matcher matcher = PARAM_REPLACEMENT.matcher(segment);
        int i = 0;
        while (matcher.find()) {
            String replacement = params.get(i++);
            replacement = replacement.replace("\\", "\\\\");
            matcher.appendReplacement(newSegment, replacement);
        }
        matcher.appendTail(newSegment);
        segment = newSegment.toString();
        return segment;
    }

    public static MultivaluedMap<String, String> decode(MultivaluedMap<String, String> map) {
        MultivaluedMapImpl<String, String> decoded = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                try {
                    decoded.add(URLDecoder.decode((String)entry.getKey(), "UTF-8"), URLDecoder.decode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return decoded;
    }

    public static MultivaluedMap<String, String> encode(MultivaluedMap<String, String> map) {
        MultivaluedMapImpl<String, String> decoded = new MultivaluedMapImpl<String, String>();
        for (Map.Entry entry : map.entrySet()) {
            List values = (List)entry.getValue();
            for (String value : values) {
                try {
                    decoded.add(URLEncoder.encode((String)entry.getKey(), "UTF-8"), URLEncoder.encode(value, "UTF-8"));
                }
                catch (UnsupportedEncodingException e) {
                    throw new RuntimeException(e);
                }
            }
        }
        return decoded;
    }

    public static String decode(String string) {
        try {
            return URLDecoder.decode(string, "UTF-8");
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
    }

    static {
        StringBuffer sb;
        int i;
        PARAM_REPLACEMENT = Pattern.compile("_resteasy_uri_parameter");
        pathEncoding = new String[128];
        pathSegmentEncoding = new String[128];
        matrixParameterEncoding = new String[128];
        queryNameValueEncoding = new String[128];
        queryStringEncoding = new String[128];
        block11: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '@': 
                case '_': 
                case '~': {
                    continue block11;
                }
                default: {
                    sb = new StringBuffer();
                    sb.append((char)i);
                    Encode.pathEncoding[i] = URLEncoder.encode(sb.toString());
                }
            }
        }
        Encode.pathEncoding[32] = "%20";
        System.arraycopy(pathEncoding, 0, matrixParameterEncoding, 0, pathEncoding.length);
        Encode.matrixParameterEncoding[59] = "%3B";
        Encode.matrixParameterEncoding[61] = "%3D";
        System.arraycopy(pathEncoding, 0, pathSegmentEncoding, 0, pathEncoding.length);
        Encode.pathSegmentEncoding[47] = "%2F";
        block12: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '-': 
                case '.': 
                case '?': 
                case '_': 
                case '~': {
                    continue block12;
                }
                case ' ': {
                    Encode.queryNameValueEncoding[i] = "+";
                    continue block12;
                }
                default: {
                    sb = new StringBuffer();
                    sb.append((char)i);
                    Encode.queryNameValueEncoding[i] = URLEncoder.encode(sb.toString());
                }
            }
        }
        block13: for (i = 0; i < 128; ++i) {
            if (i >= 97 && i <= 122 || i >= 65 && i <= 90 || i >= 48 && i <= 57) continue;
            switch ((char)i) {
                case '!': 
                case '$': 
                case '&': 
                case '\'': 
                case '(': 
                case ')': 
                case '*': 
                case '+': 
                case ',': 
                case '-': 
                case '.': 
                case '/': 
                case ':': 
                case ';': 
                case '=': 
                case '?': 
                case '@': 
                case '_': 
                case '~': {
                    continue block13;
                }
                case ' ': {
                    Encode.queryStringEncoding[i] = "%20";
                    continue block13;
                }
                default: {
                    sb = new StringBuffer();
                    sb.append((char)i);
                    Encode.queryStringEncoding[i] = URLEncoder.encode(sb.toString());
                }
            }
        }
        nonCodes = Pattern.compile("%([^a-fA-F0-9]|[a-fA-F0-9]$|$|[a-fA-F0-9][^a-fA-F0-9])");
        encodedChars = Pattern.compile("%([a-fA-F0-9][a-fA-F0-9])");
    }
}

