/*
 * Decompiled with CFR 0.152.
 */
package org.ajax4jsf.renderkit;

import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import javax.el.MethodNotFoundException;
import javax.faces.FacesException;
import javax.faces.component.UIComponent;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import org.ajax4jsf.Messages;
import org.ajax4jsf.renderkit.RendererBase;
import org.apache.commons.beanutils.MethodUtils;

public class ComponentUtils {
    private static final String UTILS_PREFIX = "util.";

    public static Object callFunction(FacesContext context, UIComponent component, RendererBase renderer, String functionName, Object[] parameters) {
        Object object;
        String methodName;
        Object returnObject = null;
        int sizeParameters = 0;
        int sizeArrayParameters = 2;
        if (parameters != null) {
            sizeParameters = parameters.length;
            sizeArrayParameters = 3;
        }
        Object[][] arrayParameters = new Object[sizeArrayParameters][];
        arrayParameters[0] = new Object[sizeParameters + 2];
        arrayParameters[1] = new Object[sizeParameters + 1];
        if (sizeParameters != 0) {
            arrayParameters[2] = new Object[sizeParameters];
        }
        arrayParameters[0][0] = context;
        arrayParameters[0][1] = component;
        arrayParameters[1][0] = component;
        if (parameters != null) {
            for (int iParameter = 0; iParameter < parameters.length; ++iParameter) {
                arrayParameters[0][iParameter + 2] = parameters;
                arrayParameters[1][iParameter + 1] = parameters;
                arrayParameters[2][iParameter] = parameters;
            }
        }
        if (functionName.startsWith(UTILS_PREFIX)) {
            methodName = functionName.substring(UTILS_PREFIX.length());
            object = renderer.getUtils();
        } else {
            object = renderer;
            methodName = functionName;
        }
        returnObject = ComponentUtils.invokeMethod(object, methodName, arrayParameters);
        return returnObject;
    }

    private static Object invokeMethod(Object object, String methodName, Object[][] arrayParameters) {
        try {
            for (int iParameter = 0; iParameter < arrayParameters.length; ++iParameter) {
                try {
                    return MethodUtils.invokeMethod((Object)object, (String)methodName, (Object[])arrayParameters[iParameter]);
                }
                catch (NoSuchMethodException e) {
                    continue;
                }
            }
        }
        catch (InvocationTargetException e) {
            throw new FacesException(Messages.getMessage((String)"METHOD_CALL_ERROR_2b", (Object)methodName, (Object)e.getCause().getMessage()), (Throwable)e);
        }
        catch (IllegalAccessException e) {
            throw new FacesException(Messages.getMessage((String)"METHOD_CALL_ERROR_4b", (Object)methodName, (Object)e.getMessage()), (Throwable)e);
        }
        throw new MethodNotFoundException(Messages.getMessage((String)"METHOD_CALL_ERROR_6b", (Object)methodName, (Object)object));
    }

    public static void writeAttribute(ResponseWriter writer, String attribute, Object value) throws IOException {
        if (value != null && value.toString().length() != 0) {
            writer.writeAttribute(attribute, (Object)value.toString(), attribute);
        }
    }
}

