/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.resteasy.core;

import java.io.PrintStream;
import java.io.PrintWriter;
import java.io.StringWriter;

public class ExceptionAdapter
extends RuntimeException {
    private static final long serialVersionUID = 6628087350457915908L;
    private final String stackTrace;
    private Exception originalException;

    public ExceptionAdapter(Exception e) {
        this(e.getMessage(), e);
    }

    public ExceptionAdapter(String message, Exception e) {
        super((message == null ? "" : message) + " : " + e.getMessage());
        this.originalException = e;
        StringWriter sw = new StringWriter();
        e.printStackTrace(new PrintWriter(sw));
        this.stackTrace = sw.toString();
    }

    public void printStackTrace() {
        this.printStackTrace(System.err);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintStream s) {
        PrintStream printStream = s;
        synchronized (printStream) {
            s.printf("%s: ", this.getClass().getName());
            s.print(this.stackTrace);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void printStackTrace(PrintWriter s) {
        PrintWriter printWriter = s;
        synchronized (printWriter) {
            s.print(this.getClass().getName() + ": ");
            s.print(this.stackTrace);
        }
    }

    public void rethrow() throws Exception {
        throw this.originalException;
    }
}

