/*
 * Decompiled with CFR 0.152.
 */
package org.apache.jmeter.testbeans.gui;

import java.awt.BorderLayout;
import java.awt.Component;
import java.beans.BeanDescriptor;
import java.beans.BeanInfo;
import java.beans.Customizer;
import java.beans.IntrospectionException;
import java.beans.Introspector;
import java.beans.PropertyDescriptor;
import java.beans.PropertyEditorManager;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.ResourceBundle;
import javax.swing.JPopupMenu;
import org.apache.commons.collections.map.LRUMap;
import org.apache.jmeter.assertions.Assertion;
import org.apache.jmeter.assertions.gui.AbstractAssertionGui;
import org.apache.jmeter.config.ConfigElement;
import org.apache.jmeter.config.gui.AbstractConfigGui;
import org.apache.jmeter.control.Controller;
import org.apache.jmeter.control.gui.AbstractControllerGui;
import org.apache.jmeter.gui.AbstractJMeterGuiComponent;
import org.apache.jmeter.gui.JMeterGUIComponent;
import org.apache.jmeter.gui.util.MenuFactory;
import org.apache.jmeter.processor.PostProcessor;
import org.apache.jmeter.processor.PreProcessor;
import org.apache.jmeter.processor.gui.AbstractPostProcessorGui;
import org.apache.jmeter.processor.gui.AbstractPreProcessorGui;
import org.apache.jmeter.samplers.Sampler;
import org.apache.jmeter.samplers.gui.AbstractSamplerGui;
import org.apache.jmeter.testbeans.TestBean;
import org.apache.jmeter.testbeans.gui.GenericTestBeanCustomizer;
import org.apache.jmeter.testbeans.gui.SharedCustomizer;
import org.apache.jmeter.testelement.TestElement;
import org.apache.jmeter.testelement.property.AbstractProperty;
import org.apache.jmeter.testelement.property.JMeterProperty;
import org.apache.jmeter.testelement.property.PropertyIterator;
import org.apache.jmeter.timers.Timer;
import org.apache.jmeter.timers.gui.AbstractTimerGui;
import org.apache.jmeter.util.JMeterUtils;
import org.apache.jmeter.util.LocaleChangeEvent;
import org.apache.jmeter.util.LocaleChangeListener;
import org.apache.jmeter.visualizers.Visualizer;
import org.apache.jmeter.visualizers.gui.AbstractVisualizer;
import org.apache.jorphan.logging.LoggingManager;
import org.apache.jorphan.util.JOrphanUtils;
import org.apache.log.Logger;

public class TestBeanGUI
extends AbstractJMeterGuiComponent
implements JMeterGUIComponent,
LocaleChangeListener {
    private static final long serialVersionUID = 240L;
    private static final Logger log = LoggingManager.getLoggerForClass();
    private final Class<?> testBeanClass;
    private transient BeanInfo beanInfo;
    private final Class<?> customizerClass;
    private Customizer customizer = null;
    private final Map<TestElement, Customizer> customizers = new LRUMap(20);
    private int customizerIndexInPanel;
    private final Map<String, Object> propertyMap = new HashMap<String, Object>();
    private boolean initialized = false;

    @Deprecated
    public TestBeanGUI() {
        log.warn("Constructor only for use in testing");
        this.testBeanClass = null;
        this.customizerClass = null;
        this.beanInfo = null;
    }

    public TestBeanGUI(Class<?> testBeanClass) {
        log.debug("testing class: " + testBeanClass.getName());
        if (!TestBean.class.isAssignableFrom(testBeanClass)) {
            Error e = new Error();
            log.error("This should never happen!", (Throwable)e);
            throw e;
        }
        this.testBeanClass = testBeanClass;
        try {
            this.beanInfo = Introspector.getBeanInfo(testBeanClass);
        }
        catch (IntrospectionException e) {
            log.error("Can't get beanInfo for " + testBeanClass.getName(), (Throwable)e);
            throw new Error(e.toString());
        }
        this.customizerClass = this.beanInfo.getBeanDescriptor().getCustomizerClass();
        this.initialized = false;
        JMeterUtils.addLocaleChangeListener(this);
    }

    private Customizer createCustomizer() {
        try {
            return (Customizer)this.customizerClass.newInstance();
        }
        catch (InstantiationException e) {
            log.error("Could not instantiate customizer of class " + this.customizerClass, (Throwable)e);
            throw new Error(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Could not instantiate customizer of class " + this.customizerClass, (Throwable)e);
            throw new Error(e.toString());
        }
    }

    @Override
    public String getStaticLabel() {
        if (this.beanInfo == null) {
            return "null";
        }
        return this.beanInfo.getBeanDescriptor().getDisplayName();
    }

    @Override
    public TestElement createTestElement() {
        try {
            TestElement element = (TestElement)this.testBeanClass.newInstance();
            if (this.initialized) {
                this.setValues(element);
            }
            this.modifyTestElement(element);
            return element;
        }
        catch (InstantiationException e) {
            log.error("Can't create test element", (Throwable)e);
            throw new Error(e.toString());
        }
        catch (IllegalAccessException e) {
            log.error("Can't create test element", (Throwable)e);
            throw new Error(e.toString());
        }
    }

    @Override
    public void modifyTestElement(TestElement element) {
        if (this.customizer instanceof GenericTestBeanCustomizer) {
            GenericTestBeanCustomizer gtbc = (GenericTestBeanCustomizer)this.customizer;
            gtbc.saveGuiFields();
        }
        this.configureTestElement(element);
        for (PropertyDescriptor desc : this.beanInfo.getPropertyDescriptors()) {
            String name = desc.getName();
            Object value = this.propertyMap.get(name);
            log.debug("Modify " + name + " to " + value);
            if (value == null) {
                if (GenericTestBeanCustomizer.notNull(desc)) {
                    this.setPropertyInElement(element, name, desc.getValue("default"));
                    continue;
                }
                element.removeProperty(name);
                continue;
            }
            this.setPropertyInElement(element, name, value);
        }
    }

    private void setPropertyInElement(TestElement element, String name, Object value) {
        JMeterProperty jprop = AbstractProperty.createProperty(value);
        jprop.setName(name);
        element.setProperty(jprop);
    }

    @Override
    public JPopupMenu createPopupMenu() {
        if (Timer.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultTimerMenu();
        }
        if (Sampler.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultSamplerMenu();
        }
        if (ConfigElement.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultConfigElementMenu();
        }
        if (Assertion.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultAssertionMenu();
        }
        if (PostProcessor.class.isAssignableFrom(this.testBeanClass) || PreProcessor.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultExtractorMenu();
        }
        if (Visualizer.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultVisualizerMenu();
        }
        if (Controller.class.isAssignableFrom(this.testBeanClass)) {
            return MenuFactory.getDefaultControllerMenu();
        }
        log.warn("Cannot determine PopupMenu for " + this.testBeanClass.getName());
        return MenuFactory.getDefaultMenu();
    }

    @Override
    public void configure(TestElement element) {
        if (!this.initialized) {
            this.init();
        }
        this.clearGui();
        super.configure(element);
        this.setValues(element);
        this.initialized = true;
    }

    private void setValues(TestElement element) {
        PropertyIterator jprops = element.propertyIterator();
        while (jprops.hasNext()) {
            JMeterProperty jprop = jprops.next();
            this.propertyMap.put(jprop.getName(), jprop.getObjectValue());
        }
        if (this.customizer != null) {
            this.customizer.setObject(this.propertyMap);
        } else {
            Customizer c;
            if (this.initialized) {
                this.remove(this.customizerIndexInPanel);
            }
            if ((c = this.customizers.get(element)) == null) {
                c = this.createCustomizer();
                c.setObject(this.propertyMap);
                this.customizers.put(element, c);
            }
            this.add((Component)((Object)c), "Center");
        }
    }

    @Override
    public Collection<String> getMenuCategories() {
        LinkedList<String> menuCategories = new LinkedList<String>();
        BeanDescriptor bd = this.beanInfo.getBeanDescriptor();
        if (bd.isExpert() && !JMeterUtils.isExpertMode()) {
            return null;
        }
        int matches = this.setupGuiClasses(menuCategories);
        if (matches == 0) {
            log.error("Could not assign GUI class to " + this.testBeanClass.getName());
        } else if (matches > 1) {
            log.error("More than 1 GUI class found for " + this.testBeanClass.getName());
        }
        return menuCategories;
    }

    public int setupGuiClasses() {
        return this.setupGuiClasses(new ArrayList<String>());
    }

    private int setupGuiClasses(List<String> menuCategories) {
        int matches = 0;
        BeanDescriptor bd = this.beanInfo.getBeanDescriptor();
        if (Assertion.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_assertions");
            bd.setValue("TestElement.gui_class", AbstractAssertionGui.class.getName());
            ++matches;
        }
        if (ConfigElement.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_config_element");
            bd.setValue("TestElement.gui_class", AbstractConfigGui.class.getName());
            ++matches;
        }
        if (Controller.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_logic_controller");
            bd.setValue("TestElement.gui_class", AbstractControllerGui.class.getName());
            ++matches;
        }
        if (Visualizer.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_listener");
            bd.setValue("TestElement.gui_class", AbstractVisualizer.class.getName());
            ++matches;
        }
        if (PostProcessor.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_post_processors");
            bd.setValue("TestElement.gui_class", AbstractPostProcessorGui.class.getName());
            ++matches;
        }
        if (PreProcessor.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_pre_processors");
            bd.setValue("TestElement.gui_class", AbstractPreProcessorGui.class.getName());
            ++matches;
        }
        if (Sampler.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_generative_controller");
            bd.setValue("TestElement.gui_class", AbstractSamplerGui.class.getName());
            ++matches;
        }
        if (Timer.class.isAssignableFrom(this.testBeanClass)) {
            menuCategories.add("menu_timer");
            bd.setValue("TestElement.gui_class", AbstractTimerGui.class.getName());
            ++matches;
        }
        return matches;
    }

    private void init() {
        this.setLayout(new BorderLayout(0, 5));
        this.setBorder(this.makeBorder());
        this.add((Component)this.makeTitlePanel(), "North");
        this.customizerIndexInPanel = this.getComponentCount();
        if (this.customizerClass == null) {
            this.customizer = new GenericTestBeanCustomizer(this.beanInfo);
        } else if (SharedCustomizer.class.isAssignableFrom(this.customizerClass)) {
            this.customizer = this.createCustomizer();
        }
        if (this.customizer != null) {
            this.add((Component)((Object)this.customizer), "Center");
        }
    }

    @Override
    public String getLabelResource() {
        return null;
    }

    @Override
    public void clearGui() {
        super.clearGui();
        if (this.customizer instanceof GenericTestBeanCustomizer) {
            GenericTestBeanCustomizer gtbc = (GenericTestBeanCustomizer)this.customizer;
            gtbc.clearGuiFields();
        }
        this.propertyMap.clear();
    }

    public boolean isHidden() {
        return this.beanInfo.getBeanDescriptor().isHidden();
    }

    public boolean isExpert() {
        return this.beanInfo.getBeanDescriptor().isExpert();
    }

    @Override
    public void localeChanged(LocaleChangeEvent event) {
        try {
            this.beanInfo = Introspector.getBeanInfo(this.testBeanClass);
            this.setupGuiClasses();
        }
        catch (IntrospectionException e) {
            log.error("Can't get beanInfo for " + this.testBeanClass.getName(), (Throwable)e);
            JMeterUtils.reportErrorToUser("Can't get beanInfo for " + this.testBeanClass.getName());
        }
    }

    @Override
    public String getDocAnchor() {
        ResourceBundle resourceBundle = ResourceBundle.getBundle(this.testBeanClass.getName() + "Resources", new Locale("", ""));
        String name = resourceBundle.getString("displayName");
        return name.replace(' ', '_');
    }

    static {
        LinkedList<String> paths = new LinkedList<String>();
        paths.add("org.apache.jmeter.testbeans.gui");
        paths.addAll(Arrays.asList(PropertyEditorManager.getEditorSearchPath()));
        String s = JMeterUtils.getPropDefault("propertyEditorSearchPath", null);
        if (s != null) {
            paths.addAll(Arrays.asList(JOrphanUtils.split((String)s, (String)",", (String)"")));
        }
        PropertyEditorManager.setEditorSearchPath(paths.toArray(new String[paths.size()]));
    }
}

